/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.BufferStrategy;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Canvas
extends Component
implements Serializable,
Accessible {
    private static final long serialVersionUID = -2284879212465893870L;
    transient GraphicsConfiguration graphicsConfiguration;
    transient BufferStrategy bufferStrategy;

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        return super.getGraphicsConfigurationImpl();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCanvas(this);
        }
        super.addNotify();
    }

    public void paint(Graphics gfx) {
        gfx.setColor(this.getBackground());
        Dimension size = this.getSize();
        gfx.fillRect(0, 0, size.width, size.height);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCanvas();
        }
        return this.accessibleContext;
    }

    public void createBufferStrategy(int numBuffers) {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("Canvas.createBufferStrategy: number of buffers is less than one");
        }
        if (!this.isDisplayable()) {
            throw new IllegalStateException("Canvas.createBufferStrategy: canvas is not displayable");
        }
        BufferStrategy newStrategy = null;
        try {
            newStrategy = new CanvasFlipBufferStrategy(numBuffers);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        if (newStrategy == null) {
            newStrategy = new CanvasBltBufferStrategy(numBuffers, true);
        }
        this.bufferStrategy = newStrategy;
    }

    public void createBufferStrategy(int numBuffers, BufferCapabilities caps) throws AWTException {
        if (numBuffers < 1) {
            throw new IllegalArgumentException("Canvas.createBufferStrategy: number of buffers is less than one");
        }
        if (caps == null) {
            throw new IllegalArgumentException("Canvas.createBufferStrategy: capabilities object is null");
        }
        this.bufferStrategy = caps.isPageFlipping() ? new CanvasFlipBufferStrategy(numBuffers) : new CanvasBltBufferStrategy(numBuffers, true);
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void update(Graphics graphics) {
        Dimension size = this.getSize();
        graphics.clearRect(0, 0, size.width, size.height);
        this.paint(graphics);
    }

    public Canvas() {
    }

    public Canvas(GraphicsConfiguration graphicsConfiguration) {
        this.graphicsConfiguration = graphicsConfiguration;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTCanvas
    extends Component.AccessibleAWTComponent {
        private static final long serialVersionUID = -6325592262103146699L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CANVAS;
        }

        protected AccessibleAWTCanvas() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CanvasFlipBufferStrategy
    extends Component.FlipBufferStrategy {
        CanvasFlipBufferStrategy(int numBuffers) throws AWTException {
            super(numBuffers, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CanvasBltBufferStrategy
    extends Component.BltBufferStrategy {
        CanvasBltBufferStrategy(int numBuffers, boolean accelerated) {
            super(numBuffers, new BufferCapabilities(new ImageCapabilities(accelerated), new ImageCapabilities(accelerated), BufferCapabilities.FlipContents.COPIED));
        }
    }
}

