/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import com.vlsolutions.swing.docking.AutoHidePolicy;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.ui.DockingUISettings;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Image;
import java.io.IOException;
import java.util.function.BiConsumer;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.gui.CustomContainerFactory;
import org.omegat.util.gui.ResourcesUtil;
import org.omegat.util.gui.Styles;

public final class UIDesignManager {
    private UIDesignManager() {
    }

    public static void setTheme(String lafClassName, ClassLoader classLoader) {
        block2: {
            try {
                Class<?> clazz = classLoader.loadClass(lafClassName);
                UIManager.setLookAndFeel((LookAndFeel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                Log.log(e);
                if (lafClassName.equals("org.omegat.gui.theme.DefaultFlatTheme")) break block2;
                UIDesignManager.setTheme("org.omegat.gui.theme.DefaultFlatTheme", classLoader);
            }
        }
    }

    public static void initialize(ClassLoader mainClassLoader) throws IOException {
        DockingUISettings.getInstance().installUI();
        DockableContainerFactory.setFactory((DockableContainerFactory)new CustomContainerFactory());
        String theme = Preferences.getPreferenceDefault("theme_class_name", "org.omegat.gui.theme.DefaultFlatTheme");
        UIDesignManager.setTheme(theme, mainClassLoader);
        if (UIManager.getColor("OmegaT.source") == null) {
            UIDesignManager.loadDefaultColors(UIManager.getDefaults());
        }
        AutoHidePolicy.getPolicy().setExpandMode(AutoHidePolicy.ExpandMode.EXPAND_ON_ROLLOVER);
        UIManager.put("DockViewTitleBar.minimizeButtonText", OStrings.getString("DOCKING_HINT_MINIMIZE"));
        UIManager.put("DockViewTitleBar.maximizeButtonText", OStrings.getString("DOCKING_HINT_MAXIMIZE"));
        UIManager.put("DockViewTitleBar.restoreButtonText", OStrings.getString("DOCKING_HINT_RESTORE"));
        UIManager.put("DockViewTitleBar.attachButtonText", OStrings.getString("DOCKING_HINT_DOCK"));
        UIManager.put("DockViewTitleBar.floatButtonText", OStrings.getString("DOCKING_HINT_UNDOCK"));
        UIManager.put("DockViewTitleBar.closeButtonText", "");
        UIManager.put("DockTabbedPane.minimizeButtonText", OStrings.getString("DOCKING_HINT_MINIMIZE"));
        UIManager.put("DockTabbedPane.maximizeButtonText", OStrings.getString("DOCKING_HINT_MAXIMIZE"));
        UIManager.put("DockTabbedPane.restoreButtonText", OStrings.getString("DOCKING_HINT_RESTORE"));
        UIManager.put("DockTabbedPane.floatButtonText", OStrings.getString("DOCKING_HINT_UNDOCK"));
        UIManager.put("DockTabbedPane.closeButtonText", "");
        Font defaultFont = UIManager.getFont("Label.font");
        UIManager.put("DockViewTitleBar.titleFont", defaultFont);
        UIManager.put("JTabbedPaneSmartIcon.font", defaultFont);
        UIManager.put("AutoHideButton.font", defaultFont);
        UIManager.put("DockViewTitleBar.isCloseButtonDisplayed", false);
        UIManager.put("DockingDesktop.closeActionAccelerator", null);
        UIManager.put("DockingDesktop.maximizeActionAccelerator", null);
        UIManager.put("DockingDesktop.dockActionAccelerator", null);
        UIManager.put("DockingDesktop.floatActionAccelerator", null);
        UIManager.put("DockViewTitleBar.menu.close", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close.rollover", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.close.pressed", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockTabbedPane.menu.close", UIDesignManager.getIcon("empty.gif"));
        UIManager.put("DockingDesktop.notificationBlinkCount", 2);
        UIManager.put("DockingDesktop.notificationColor", Styles.EditorColor.COLOR_NOTIFICATION_MAX.getColor());
        UIDesignManager.ensureTitlebarReadability();
    }

    private static void ensureTitlebarReadability() {
        Color textColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        Color backColor = UIManager.getColor("Panel.background");
        if (textColor != null && backColor != null && textColor.equals(backColor)) {
            float[] hsb = Color.RGBtoHSB(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), null);
            float brightness = hsb[2];
            brightness = brightness >= 0.5f ? (brightness -= 0.5f) : (brightness += 0.5f);
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], brightness);
            ColorUIResource res = new ColorUIResource(rgb);
            UIManager.put("InternalFrame.inactiveTitleForeground", res);
        }
        UIManager.put("DockingDesktop.notificationBlinkCount", 2);
        UIManager.put("DockingDesktop.notificationColor", Styles.EditorColor.COLOR_NOTIFICATION_MAX.getColor());
    }

    private static ImageIcon getIcon(String iconName) {
        Image image = ResourcesUtil.getBundledImage(iconName);
        return image == null ? null : new ImageIcon(image);
    }

    public static void removeUnusedMenuSeparators(JPopupMenu menu) {
        if (menu.getComponentCount() > 0 && menu.getComponent(0) instanceof JSeparator) {
            menu.remove(0);
        }
        if (menu.getComponentCount() > 0 && menu.getComponent(menu.getComponentCount() - 1) instanceof JSeparator) {
            menu.remove(menu.getComponentCount() - 1);
        }
        for (int i = 0; i < menu.getComponentCount() - 1; ++i) {
            if (!(menu.getComponent(i) instanceof JSeparator) || !(menu.getComponent(i + 1) instanceof JSeparator)) continue;
            menu.remove(i);
        }
    }

    public static void ensureDockablesVisible(DockingDesktop desktop) {
        for (DockableState state : desktop.getDockables()) {
            if (!state.isClosed()) continue;
            desktop.addDockable(state.getDockable());
        }
    }

    public static DockingDesktop getDesktop(Container c) {
        while (c != null && !(c instanceof DockingDesktop)) {
            c = c.getParent();
        }
        return (DockingDesktop)c;
    }

    private static boolean isDarkTheme(UIDefaults uiDefaults) {
        Color foreground = uiDefaults.getColor("Table.foreground");
        Color background = uiDefaults.getColor("Table.background");
        float foreground_brightness = Color.RGBtoHSB(foreground.getRed(), foreground.getGreen(), foreground.getBlue(), null)[2];
        float background_brightness = Color.RGBtoHSB(background.getRed(), background.getGreen(), background.getBlue(), null)[2];
        return background_brightness < foreground_brightness;
    }

    private static void loadColors(UIDefaults defaults, String scheme) throws IOException {
        ResourcesUtil.getBundleColorProperties(scheme).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (v.toString().charAt(0) != '#') {
                throw new RuntimeException("Invalid color value for key " + k + ": " + v);
            }
            try {
                Color color;
                String hex = v.toString().substring(1);
                if (hex.length() <= 6) {
                    color = new Color(Integer.parseInt(hex, 16));
                } else {
                    long val = Long.parseLong(hex, 16);
                    int a = (int)(val & 0xFFL);
                    int b = (int)(val >> 8 & 0xFFL);
                    int g = (int)(val >> 16 & 0xFFL);
                    int r = (int)(val >> 24 & 0xFFL);
                    color = new Color(r, g, b, a);
                }
                defaults.put(k.toString(), color);
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("Invalid color value for key '" + k + "': " + v, ex);
            }
        }));
    }

    public static void loadDefaultColors(UIDefaults uiDefaults) throws IOException {
        Color hilite;
        if (UIDesignManager.isDarkTheme(uiDefaults)) {
            UIDesignManager.loadColors(uiDefaults, "dark");
            hilite = uiDefaults.getColor("TextArea.background").brighter();
            if (Platform.isLinux() && Color.WHITE.equals(uiDefaults.getColor("TextPane.background"))) {
                uiDefaults.put("TextPane.background", uiDefaults.getColor("List.background"));
            }
        } else {
            UIDesignManager.loadColors(uiDefaults, "light");
            Color bg = uiDefaults.getColor("TextArea.background").darker();
            hilite = new Color(bg.getRed(), bg.getBlue(), bg.getGreen(), 32);
        }
        uiDefaults.put("OmegaT.alternatingHilite", hilite);
    }
}

