/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.caffinitas.ohc.alloc.IAllocator;
import org.caffinitas.ohc.alloc.JNANativeAllocator;
import org.caffinitas.ohc.alloc.UnsafeAllocator;
import org.caffinitas.ohc.tables.UnsExt;
import org.caffinitas.ohc.tables.UnsExt7;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

final class Uns {
    private static final Logger LOGGER = LoggerFactory.getLogger(Uns.class);
    private static final Unsafe unsafe;
    private static final IAllocator allocator;
    private static final boolean __DEBUG_OFF_HEAP_MEMORY_ACCESS;
    private static final String __ALLOCATOR;
    private static final ConcurrentMap<Long, Long> ohDebug;
    private static final Map<Long, Throwable> ohFreeDebug;
    private static final UnsExt ext;
    private static final Class<?> DIRECT_BYTE_BUFFER_CLASS;
    private static final long DIRECT_BYTE_BUFFER_ADDRESS_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_CAPACITY_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_LIMIT_OFFSET;

    static void clearUnsDebugForTest() {
        if (__DEBUG_OFF_HEAP_MEMORY_ACCESS) {
            try {
                if (!ohDebug.isEmpty()) {
                    for (Map.Entry addrSize : ohDebug.entrySet()) {
                        System.err.printf("  still allocated: address=%d, size=%d%n", addrSize.getKey(), addrSize.getValue());
                    }
                    throw new RuntimeException("Not all allocated memory has been freed!");
                }
            }
            finally {
                ohDebug.clear();
                ohFreeDebug.clear();
            }
        }
    }

    private static void freed(long address) {
        if (__DEBUG_OFF_HEAP_MEMORY_ACCESS) {
            Long allocatedLen = (Long)ohDebug.remove(address);
            if (allocatedLen == null) {
                Throwable freedAt = ohFreeDebug.get(address);
                throw new IllegalStateException("Free of unallocated region " + address, freedAt);
            }
            ohFreeDebug.put(address, new Exception("free backtrace - t=" + System.nanoTime()));
        }
    }

    private static void allocated(long address, long bytes) {
        if (__DEBUG_OFF_HEAP_MEMORY_ACCESS) {
            Long allocatedLen = ohDebug.putIfAbsent(address, bytes);
            if (allocatedLen != null) {
                throw new Error("Oops - allocate() got duplicate address");
            }
            ohFreeDebug.remove(address);
        }
    }

    private static void validate(long address, long offset, long len) {
        if (__DEBUG_OFF_HEAP_MEMORY_ACCESS) {
            if (address == 0L) {
                throw new NullPointerException();
            }
            Long allocatedLen = (Long)ohDebug.get(address);
            if (allocatedLen == null) {
                Throwable freedAt = ohFreeDebug.get(address);
                throw new IllegalStateException("Access to unallocated region " + address + " - t=" + System.nanoTime(), freedAt);
            }
            if (offset < 0L) {
                throw new IllegalArgumentException("Negative offset");
            }
            if (len < 0L) {
                throw new IllegalArgumentException("Negative length");
            }
            if (offset + len > allocatedLen) {
                throw new IllegalArgumentException("Access outside allocated region");
            }
        }
    }

    private Uns() {
    }

    static long getLongFromByteArray(byte[] array, int offset) {
        if (offset < 0 || offset + 8 > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return unsafe.getLong(array, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset);
    }

    static int getIntFromByteArray(byte[] array, int offset) {
        if (offset < 0 || offset + 4 > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return unsafe.getInt(array, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset);
    }

    static short getShortFromByteArray(byte[] array, int offset) {
        if (offset < 0 || offset + 2 > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return unsafe.getShort(array, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset);
    }

    static long getAndPutLong(long address, long offset, long value) {
        Uns.validate(address, offset, 8L);
        return ext.getAndPutLong(address, offset, value);
    }

    public static boolean compareAndSwapLong(long address, long offset, long expect, long value) {
        Uns.validate(address, offset, 8L);
        return unsafe.compareAndSwapLong(null, address + offset, expect, value);
    }

    static void putLong(long address, long offset, long value) {
        Uns.validate(address, offset, 8L);
        unsafe.putLong(null, address + offset, value);
    }

    static long getLong(long address, long offset) {
        Uns.validate(address, offset, 8L);
        return unsafe.getLong(null, address + offset);
    }

    static void putInt(long address, long offset, int value) {
        Uns.validate(address, offset, 4L);
        unsafe.putInt(null, address + offset, value);
    }

    static int getInt(long address, long offset) {
        Uns.validate(address, offset, 4L);
        return unsafe.getInt(null, address + offset);
    }

    static void putShort(long address, long offset, short value) {
        Uns.validate(address, offset, 2L);
        unsafe.putShort(null, address + offset, value);
    }

    static short getShort(long address, long offset) {
        Uns.validate(address, offset, 2L);
        return unsafe.getShort(null, address + offset);
    }

    static void putByte(long address, long offset, byte value) {
        Uns.validate(address, offset, 1L);
        unsafe.putByte(null, address + offset, value);
    }

    static byte getByte(long address, long offset) {
        Uns.validate(address, offset, 1L);
        return unsafe.getByte(null, address + offset);
    }

    static void putBoolean(long address, long offset, boolean value) {
        Uns.validate(address, offset, 1L);
        unsafe.putBoolean(null, address + offset, value);
    }

    static boolean getBoolean(long address, long offset) {
        Uns.validate(address, offset, 1L);
        return unsafe.getBoolean(null, address + offset);
    }

    static void putChar(long address, long offset, char value) {
        Uns.validate(address, offset, 2L);
        unsafe.putChar(null, address + offset, value);
    }

    static char getChar(long address, long offset) {
        Uns.validate(address, offset, 2L);
        return unsafe.getChar(null, address + offset);
    }

    static void putFloat(long address, long offset, float value) {
        Uns.validate(address, offset, 4L);
        unsafe.putFloat(null, address + offset, value);
    }

    static float getFloat(long address, long offset) {
        Uns.validate(address, offset, 4L);
        return unsafe.getFloat(null, address + offset);
    }

    static void putDouble(long address, long offset, double value) {
        Uns.validate(address, offset, 8L);
        unsafe.putDouble(null, address + offset, value);
    }

    static double getDouble(long address, long offset) {
        Uns.validate(address, offset, 8L);
        return unsafe.getDouble(null, address + offset);
    }

    static boolean decrement(long address, long offset) {
        Uns.validate(address, offset, 8L);
        long v = ext.getAndAddInt(address, offset, -1);
        return v == 1L;
    }

    static void increment(long address, long offset) {
        Uns.validate(address, offset, 8L);
        ext.getAndAddInt(address, offset, 1);
    }

    static void copyMemory(long srcAddress, long srcOffset, long dstAddress, long dstOffset, long len) {
        Uns.validate(srcAddress, srcOffset, len);
        Uns.validate(dstAddress, dstOffset, len);
        unsafe.copyMemory(null, srcAddress + srcOffset, null, dstAddress + dstOffset, len);
    }

    static void copyMemory(byte[] arr, int off, long dstAddress, long dstOffset, long len) {
        Uns.validate(dstAddress, dstOffset, len);
        unsafe.copyMemory(arr, Unsafe.ARRAY_BYTE_BASE_OFFSET + off, null, dstAddress + dstOffset, len);
    }

    static void copyMemory(long srcAddress, long srcOffset, byte[] arr, int off, long len) {
        Uns.validate(srcAddress, srcOffset, len);
        unsafe.copyMemory(null, srcAddress + srcOffset, arr, Unsafe.ARRAY_BYTE_BASE_OFFSET + off, len);
    }

    static void setMemory(long address, long offset, long len, byte val) {
        Uns.validate(address, offset, len);
        unsafe.setMemory(address + offset, len, val);
    }

    static long getTotalAllocated() {
        return allocator.getTotalAllocated();
    }

    static long allocate(long bytes) {
        return Uns.allocate(bytes, false);
    }

    static long allocate(long bytes, boolean throwOOME) {
        long address = allocator.allocate(bytes);
        if (address != 0L) {
            Uns.allocated(address, bytes);
        } else if (throwOOME) {
            throw new OutOfMemoryError("unable to allocate " + bytes + " in off-heap");
        }
        return address;
    }

    static long allocateIOException(long bytes) throws IOException {
        return Uns.allocateIOException(bytes, false);
    }

    static long allocateIOException(long bytes, boolean throwOOME) throws IOException {
        long address = Uns.allocate(bytes, throwOOME);
        if (address == 0L) {
            throw new IOException("unable to allocate " + bytes + " in off-heap");
        }
        return address;
    }

    static void free(long address) {
        if (address == 0L) {
            return;
        }
        Uns.freed(address);
        allocator.free(address);
    }

    static ByteBuffer directBufferFor(long address, long offset, long len) {
        if (len > Integer.MAX_VALUE || len < 0L) {
            throw new IllegalArgumentException();
        }
        try {
            ByteBuffer bb = (ByteBuffer)unsafe.allocateInstance(DIRECT_BYTE_BUFFER_CLASS);
            unsafe.putLong(bb, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET, address + offset);
            unsafe.putInt(bb, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET, (int)len);
            unsafe.putInt(bb, DIRECT_BYTE_BUFFER_LIMIT_OFFSET, (int)len);
            bb.order(ByteOrder.nativeOrder());
            return bb;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        __DEBUG_OFF_HEAP_MEMORY_ACCESS = Boolean.parseBoolean(System.getProperty("org.caffinitas.ohc.debugOffHeapAccess", "false"));
        __ALLOCATOR = System.getProperty("org.caffinitas.ohc.allocator");
        ohDebug = __DEBUG_OFF_HEAP_MEMORY_ACCESS ? new ConcurrentHashMap(16384) : null;
        ohFreeDebug = __DEBUG_OFF_HEAP_MEMORY_ACCESS ? new ConcurrentHashMap(16384) : null;
        try {
            IAllocator alloc;
            String allocType;
            UnsExt e;
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe.addressSize() > 8) {
                throw new RuntimeException("Address size " + unsafe.addressSize() + " not supported yet (max 8 bytes)");
            }
            try {
                Unsafe.class.getDeclaredMethod("getAndAddLong", Object.class, Long.TYPE, Long.TYPE);
                Class<?> cls = Class.forName(UnsExt7.class.getName().replace('7', '8'));
                e = (UnsExt)cls.getDeclaredConstructor(Class.class).newInstance(unsafe);
                LOGGER.info("OHC using Java8 Unsafe API");
            }
            catch (Exception ignored) {
                e = new UnsExt7(unsafe);
            }
            ext = e;
            if (__DEBUG_OFF_HEAP_MEMORY_ACCESS) {
                LOGGER.warn("Degraded performance due to off-heap memory allocations and access guarded by debug code enabled via system property org.caffinitas.ohc.debugOffHeapAccess=true");
            }
            switch (allocType = __ALLOCATOR != null ? __ALLOCATOR : "jna") {
                case "unsafe": {
                    alloc = new UnsafeAllocator();
                    LOGGER.info("OHC using sun.misc.Unsafe memory allocation");
                    break;
                }
                default: {
                    alloc = new JNANativeAllocator();
                    LOGGER.info("OHC using JNA OS native malloc/free");
                }
            }
            allocator = alloc;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        try {
            Class<?> clazz = ByteBuffer.allocateDirect(0).getClass();
            DIRECT_BYTE_BUFFER_ADDRESS_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            DIRECT_BYTE_BUFFER_CAPACITY_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("capacity"));
            DIRECT_BYTE_BUFFER_LIMIT_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("limit"));
            DIRECT_BYTE_BUFFER_CLASS = clazz;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

