/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final String VERSION_REGEXP = "(\\d+)\\.(\\d+)(\\.\\d+)?(\\.\\d+)?([~\\-]\\w[.\\w]*(?:\\-\\w[.\\w]*)*)?(\\+[.\\w]+)?";
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?(\\.\\d+)?([~\\-]\\w[.\\w]*(?:\\-\\w[.\\w]*)*)?(\\+[.\\w]+)?");
    private final int major;
    private final int minor;
    private final int patch;
    private final int dsePatch;
    private final String[] preReleases;
    private final String build;

    private VersionNumber(int major, int minor, int patch, int dsePatch, String[] preReleases, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.dsePatch = dsePatch;
        this.preReleases = preReleases;
        this.build = build;
    }

    public static VersionNumber parse(String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version number: " + version);
        }
        try {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            String pa = matcher.group(3);
            int patch = pa == null || pa.isEmpty() ? 0 : Integer.parseInt(pa.substring(1));
            String dse = matcher.group(4);
            int dsePatch = dse == null || dse.isEmpty() ? -1 : Integer.parseInt(dse.substring(1));
            String pr = matcher.group(5);
            String[] preReleases = pr == null || pr.isEmpty() ? null : pr.substring(1).split("\\-");
            String bl = matcher.group(6);
            String build = bl == null || bl.isEmpty() ? null : bl.substring(1);
            return new VersionNumber(major, minor, patch, dsePatch, preReleases, build);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version number: " + version);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getDSEPatch() {
        return this.dsePatch;
    }

    public List<String> getPreReleaseLabels() {
        return Collections.unmodifiableList(Arrays.asList(this.preReleases));
    }

    public String getBuildLabel() {
        return this.build;
    }

    public VersionNumber nextStable() {
        return new VersionNumber(this.major, this.minor, this.patch, this.dsePatch, null, null);
    }

    @Override
    public int compareTo(VersionNumber other) {
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.dsePatch < 0) {
            if (other.dsePatch >= 0) {
                return -1;
            }
        } else {
            if (other.dsePatch < 0) {
                return 1;
            }
            if (this.dsePatch < other.dsePatch) {
                return -1;
            }
            if (this.dsePatch > other.dsePatch) {
                return 1;
            }
        }
        if (this.preReleases == null) {
            return other.preReleases == null ? 0 : 1;
        }
        if (other.preReleases == null) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.preReleases.length, other.preReleases.length); ++i) {
            int cmp = this.preReleases[i].compareTo(other.preReleases[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return this.preReleases.length == other.preReleases.length ? 0 : (this.preReleases.length < other.preReleases.length ? -1 : 1);
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionNumber)) {
            return false;
        }
        VersionNumber that = (VersionNumber)o;
        if (this.major != that.major || this.minor != that.minor || this.patch != that.patch) {
            return false;
        }
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.dsePatch == that.dsePatch && (this.preReleases == null ? that.preReleases == null : Arrays.equals(this.preReleases, that.preReleases)) && Objects.equal((Object)this.build, (Object)that.build);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.major, this.minor, this.patch, this.dsePatch, this.preReleases, this.build});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.dsePatch >= 0) {
            sb.append('.').append(this.dsePatch);
        }
        if (this.preReleases != null) {
            for (String preRelease : this.preReleases) {
                sb.append('-').append(preRelease);
            }
        }
        if (this.build != null) {
            sb.append('+').append(this.build);
        }
        return sb.toString();
    }
}

