/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.net.IAsyncCallback;

public abstract class AbstractPaxosCallback<T>
implements IAsyncCallback<T> {
    protected final CountDownLatch latch;
    protected final int targets;
    private final ConsistencyLevel consistency;
    private final long queryStartNanoTime;

    public AbstractPaxosCallback(int targets, ConsistencyLevel consistency, long queryStartNanoTime) {
        this.targets = targets;
        this.consistency = consistency;
        this.latch = new CountDownLatch(targets);
        this.queryStartNanoTime = queryStartNanoTime;
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }

    public int getResponseCount() {
        return (int)((long)this.targets - this.latch.getCount());
    }

    public void await() throws WriteTimeoutException {
        try {
            long timeout = TimeUnit.MILLISECONDS.toNanos(DatabaseDescriptor.getWriteRpcTimeout()) - (System.nanoTime() - this.queryStartNanoTime);
            if (!this.latch.await(timeout, TimeUnit.NANOSECONDS)) {
                throw new WriteTimeoutException(WriteType.CAS, this.consistency, this.getResponseCount(), this.targets);
            }
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
    }
}

