/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.mp4.Mp4Context;
import com.drew.metadata.mp4.boxes.Box;
import java.io.IOException;
import java.io.InputStream;

public class Mp4Reader {
    private Mp4Reader() {
    }

    public static void extract(@NotNull InputStream inputStream, @NotNull Mp4Handler handler) {
        StreamReader reader = new StreamReader(inputStream);
        reader.setMotorolaByteOrder(true);
        Mp4Context context = new Mp4Context();
        Mp4Reader.processBoxes(reader, -1L, handler, context);
    }

    private static void processBoxes(StreamReader reader, long atomEnd, Mp4Handler handler, Mp4Context context) {
        try {
            while (atomEnd == -1L || reader.getPosition() < atomEnd) {
                Box box = new Box(reader);
                if (handler.shouldAcceptContainer(box)) {
                    Mp4Reader.processBoxes(reader, box.size + reader.getPosition() - 8L, handler.processContainer(box, context), context);
                    continue;
                }
                if (handler.shouldAcceptBox(box)) {
                    handler = handler.processBox(box, reader.getBytes((int)box.size - 8), context);
                    continue;
                }
                if (box.usertype != null) {
                    reader.skip(box.size - 24L);
                    continue;
                }
                if (box.size > 1L) {
                    if (box.isLargeSize) {
                        reader.skip(box.size - 16L);
                        continue;
                    }
                    reader.skip(box.size - 8L);
                    continue;
                }
                if (box.size != -1L) continue;
                break;
            }
        }
        catch (IOException e) {
            handler.addError(e.getMessage());
        }
    }
}

