/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.impl;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.FileLocation;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemLocation;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.cc.impl.problems.BuildNameProvider;
import org.gradle.internal.cc.impl.problems.JsonSource;
import org.gradle.internal.cc.impl.problems.JsonWriter;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.configuration.problems.CommonReport;
import org.gradle.internal.configuration.problems.DecoratedFailure;
import org.gradle.internal.configuration.problems.DecoratedReportProblemKt;
import org.gradle.internal.configuration.problems.FailureDecorator;
import org.gradle.internal.configuration.problems.PropertyProblemKt;
import org.gradle.internal.configuration.problems.StructuredMessage;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.problems.buildtree.ProblemReporter;
import org.gradle.problems.internal.ProblemReportCreator;
import org.gradle.problems.internal.impl.DefaultProblemsReportCreator;
import org.gradle.problems.internal.impl.DefaultProblemsReportCreatorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0018\u0010\u0013\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gradle/problems/internal/impl/DefaultProblemsReportCreator;", "Lorg/gradle/problems/internal/ProblemReportCreator;", "executorFactory", "Lorg/gradle/internal/concurrent/ExecutorFactory;", "temporaryFileProvider", "Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;", "internalOptions", "Lorg/gradle/internal/buildoption/InternalOptions;", "startParameter", "Lorg/gradle/api/internal/StartParameterInternal;", "failureFactory", "Lorg/gradle/internal/problems/failure/FailureFactory;", "buildNameProvider", "Lorg/gradle/internal/cc/impl/problems/BuildNameProvider;", "(Lorg/gradle/internal/concurrent/ExecutorFactory;Lorg/gradle/api/internal/file/temp/TemporaryFileProvider;Lorg/gradle/internal/buildoption/InternalOptions;Lorg/gradle/api/internal/StartParameterInternal;Lorg/gradle/internal/problems/failure/FailureFactory;Lorg/gradle/internal/cc/impl/problems/BuildNameProvider;)V", "failureDecorator", "Lorg/gradle/internal/configuration/problems/FailureDecorator;", "problemCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "report", "Lorg/gradle/internal/configuration/problems/CommonReport;", "taskNames", "", "", "emit", "", "problem", "Lorg/gradle/api/problems/internal/Problem;", "id", "Lorg/gradle/internal/operations/OperationIdentifier;", "getId", "reportDir", "Ljava/io/File;", "validationFailures", "Lorg/gradle/problems/buildtree/ProblemReporter$ProblemConsumer;", "problems"})
public final class DefaultProblemsReportCreator
implements ProblemReportCreator {
    @NotNull
    private final FailureFactory failureFactory;
    @NotNull
    private final BuildNameProvider buildNameProvider;
    @NotNull
    private final CommonReport report;
    @NotNull
    private final List<String> taskNames;
    @NotNull
    private final AtomicInteger problemCount;
    @NotNull
    private final FailureDecorator failureDecorator;

    public DefaultProblemsReportCreator(@NotNull ExecutorFactory executorFactory, @NotNull TemporaryFileProvider temporaryFileProvider, @NotNull InternalOptions internalOptions, @NotNull StartParameterInternal startParameter, @NotNull FailureFactory failureFactory, @NotNull BuildNameProvider buildNameProvider) {
        Intrinsics.checkNotNullParameter((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkNotNullParameter((Object)temporaryFileProvider, (String)"temporaryFileProvider");
        Intrinsics.checkNotNullParameter((Object)internalOptions, (String)"internalOptions");
        Intrinsics.checkNotNullParameter((Object)startParameter, (String)"startParameter");
        Intrinsics.checkNotNullParameter((Object)failureFactory, (String)"failureFactory");
        Intrinsics.checkNotNullParameter((Object)buildNameProvider, (String)"buildNameProvider");
        this.failureFactory = failureFactory;
        this.buildNameProvider = buildNameProvider;
        this.report = new CommonReport(executorFactory, temporaryFileProvider, internalOptions, "problem report", "problem-report");
        List list = startParameter.getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"startParameter.taskNames");
        this.taskNames = list;
        this.problemCount = new AtomicInteger(0);
        this.failureDecorator = new FailureDecorator();
    }

    @NotNull
    public String getId() {
        return "DefaultProblemsReportCreator";
    }

    public void report(@NotNull File reportDir, @NotNull ProblemReporter.ProblemConsumer validationFailures) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
            Intrinsics.checkNotNullParameter((Object)validationFailures, (String)"validationFailures");
            File file = this.report.writeReportFileTo(reportDir, new JsonSource(this){
                final /* synthetic */ DefaultProblemsReportCreator this$0;
                {
                    this.this$0 = $receiver;
                }

                public void writeToJson(@NotNull JsonWriter jsonWriter) {
                    Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
                    DefaultProblemsReportCreator defaultProblemsReportCreator = this.this$0;
                    JsonWriter $this$writeToJson_u24lambda_u241 = jsonWriter;
                    boolean bl = false;
                    $this$writeToJson_u24lambda_u241.property("reportContext", "problem report");
                    String string = DefaultProblemsReportCreator.access$getProblemCount$p(defaultProblemsReportCreator).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"problemCount.toString()");
                    $this$writeToJson_u24lambda_u241.property("totalProblemCount", string);
                    String string2 = DefaultProblemsReportCreator.access$getBuildNameProvider$p(defaultProblemsReportCreator).buildName();
                    if (string2 != null) {
                        String it = string2;
                        boolean bl2 = false;
                        $this$writeToJson_u24lambda_u241.property("buildName", it);
                    }
                    $this$writeToJson_u24lambda_u241.property("requestedTasks", CollectionsKt.joinToString$default((Iterable)DefaultProblemsReportCreator.access$getTaskNames$p(defaultProblemsReportCreator), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                    String string3 = new DocumentationRegistry().getDocumentationFor("problem-report");
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DocumentationRegistry().\u2026tionFor(\"problem-report\")");
                    $this$writeToJson_u24lambda_u241.property("documentationLink", string3);
                    $this$writeToJson_u24lambda_u241.property("documentationLinkCaption", "Problem report");
                }
            });
            if (file == null) break block0;
            File it = file;
            boolean bl = false;
            String url = new ConsoleRenderer().asClickableFileUrl(it);
            DefaultProblemsReportCreatorKt.getLogger().warn("Problems report is available at: " + url);
        }
    }

    public void emit(@NotNull Problem problem, @Nullable OperationIdentifier id) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.problemCount.incrementAndGet();
        this.report.onProblem(new JsonSource(problem, this){
            final /* synthetic */ Problem $problem;
            final /* synthetic */ DefaultProblemsReportCreator this$0;
            {
                this.$problem = $problem;
                this.this$0 = $receiver;
            }

            public void writeToJson(@NotNull JsonWriter jsonWriter) {
                Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
                Problem problem = this.$problem;
                DefaultProblemsReportCreator defaultProblemsReportCreator = this.this$0;
                JsonWriter $this$writeToJson_u24lambda_u240 = jsonWriter;
                boolean bl = false;
                $this$writeToJson_u24lambda_u240.jsonObject((Function0)new Function0<Unit>($this$writeToJson_u24lambda_u240, problem, this, defaultProblemsReportCreator){
                    final /* synthetic */ JsonWriter $this_with;
                    final /* synthetic */ Problem $problem;
                    final /* synthetic */ emit.1 this$0;
                    final /* synthetic */ DefaultProblemsReportCreator this$1;
                    {
                        this.$this_with = $receiver;
                        this.$problem = $problem;
                        this.this$0 = $receiver2;
                        this.this$1 = $receiver3;
                        super(0);
                    }

                    public final void invoke() {
                        block2: {
                            String it;
                            JsonWriter jsonWriter;
                            Object object;
                            this.$this_with.property("trace", (Function0)new Function0<Unit>(this.$this_with, this.this$0){
                                final /* synthetic */ JsonWriter $this_with;
                                final /* synthetic */ emit.1 this$0;
                                {
                                    this.$this_with = $receiver;
                                    this.this$0 = $receiver2;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$this_with.jsonObjectList((Iterable)CollectionsKt.listOf((Object)emit.1.access$getFirstFileLocation(this.this$0)), (Function1)new Function1<String, Unit>(this.$this_with){
                                        final /* synthetic */ JsonWriter $this_with;
                                        {
                                            this.$this_with = $receiver;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull String path) {
                                            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                                            this.$this_with.property("kind", "Project");
                                            this.$this_with.property("path", path);
                                        }
                                    });
                                }
                            });
                            this.$this_with.property("problem", (Function0)new Function0<Unit>(this.$this_with, this.$problem){
                                final /* synthetic */ JsonWriter $this_with;
                                final /* synthetic */ Problem $problem;
                                {
                                    this.$this_with = $receiver;
                                    this.$problem = $problem;
                                    super(0);
                                }

                                public final void invoke() {
                                    String string = this.$problem.getDefinition().getId().getDisplayName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"problem.definition.id.displayName");
                                    PropertyProblemKt.writeStructuredMessage((JsonWriter)this.$this_with, (StructuredMessage)StructuredMessage.Companion.forText(string));
                                }
                            });
                            String string = this.$problem.getDetails();
                            if (string != null) {
                                object = string;
                                jsonWriter = this.$this_with;
                                it = object;
                                boolean bl = false;
                                jsonWriter.property("problemDetails", (Function0)new Function0<Unit>(jsonWriter, it){
                                    final /* synthetic */ JsonWriter $this_with;
                                    final /* synthetic */ String $it;
                                    {
                                        this.$this_with = $receiver;
                                        this.$it = $it;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        StructuredMessage.Builder builder = new StructuredMessage.Builder();
                                        String string = this.$it;
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                                        PropertyProblemKt.writeStructuredMessage((JsonWriter)this.$this_with, (StructuredMessage)builder.text(string).build());
                                    }
                                });
                            }
                            DocLink docLink = this.$problem.getDefinition().getDocumentationLink();
                            if (docLink != null) {
                                object = docLink;
                                jsonWriter = this.$this_with;
                                it = object;
                                boolean bl = false;
                                String string2 = it.getUrl();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.url");
                                jsonWriter.property("documentationLink", string2);
                            }
                            RuntimeException runtimeException = this.$problem.getException();
                            if (runtimeException == null) break block2;
                            object = runtimeException;
                            jsonWriter = this.$this_with;
                            DefaultProblemsReportCreator defaultProblemsReportCreator = this.this$1;
                            Object it2 = object;
                            boolean bl = false;
                            FailureDecorator failureDecorator = DefaultProblemsReportCreator.access$getFailureDecorator$p(defaultProblemsReportCreator);
                            Failure failure = DefaultProblemsReportCreator.access$getFailureFactory$p(defaultProblemsReportCreator).create((Throwable)it2);
                            Intrinsics.checkNotNullExpressionValue((Object)failure, (String)"failureFactory.create(it)");
                            DecoratedReportProblemKt.writeError((JsonWriter)jsonWriter, (DecoratedFailure)failureDecorator.decorate(failure));
                        }
                    }
                });
            }

            private final String getFirstFileLocation() {
                String string;
                Object v1;
                block3: {
                    List list = this.$problem.getLocations();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"problem.locations");
                    Iterable iterable = list;
                    for (T t : iterable) {
                        ProblemLocation it = (ProblemLocation)t;
                        boolean bl = false;
                        if (!(it instanceof FileLocation)) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                ProblemLocation problemLocation = v1;
                if (problemLocation != null) {
                    ProblemLocation it = problemLocation;
                    boolean bl = false;
                    string = ((FileLocation)it).getPath();
                } else {
                    string = null;
                }
                String string2 = string;
                return string2 == null ? "<N/A>" : string2;
            }

            public static final /* synthetic */ String access$getFirstFileLocation(emit.1 $this) {
                return $this.getFirstFileLocation();
            }
        });
    }

    public static final /* synthetic */ AtomicInteger access$getProblemCount$p(DefaultProblemsReportCreator $this) {
        return $this.problemCount;
    }

    public static final /* synthetic */ BuildNameProvider access$getBuildNameProvider$p(DefaultProblemsReportCreator $this) {
        return $this.buildNameProvider;
    }

    public static final /* synthetic */ List access$getTaskNames$p(DefaultProblemsReportCreator $this) {
        return $this.taskNames;
    }

    public static final /* synthetic */ FailureDecorator access$getFailureDecorator$p(DefaultProblemsReportCreator $this) {
        return $this.failureDecorator;
    }

    public static final /* synthetic */ FailureFactory access$getFailureFactory$p(DefaultProblemsReportCreator $this) {
        return $this.failureFactory;
    }
}

