/*
 * Decompiled with CFR 0.152.
 */
package free.jin.scripter;

import free.jin.BadChangesException;
import free.jin.I18n;
import free.jin.scripter.BeanShellScript;
import free.jin.scripter.BeanShellScriptDialog;
import free.jin.scripter.CommandScript;
import free.jin.scripter.CommandsScriptDialog;
import free.jin.scripter.Script;
import free.jin.scripter.ScriptDialog;
import free.jin.scripter.Scripter;
import free.jin.ui.PreferencesPanel;
import free.util.AWTUtilities;
import free.util.Utilities;
import free.util.WindowDisposingListener;
import free.workarounds.FixedJTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScripterPreferencesPanel
extends PreferencesPanel {
    private final Scripter scripter;
    private final DefaultListModel scriptsListModel;

    public ScripterPreferencesPanel(Scripter scripter) {
        this.scripter = scripter;
        Script[] scriptArray = scripter.getScripts();
        this.scriptsListModel = new DefaultListModel();
        for (int i = 0; i < scriptArray.length; ++i) {
            this.scriptsListModel.addElement(scriptArray[i]);
        }
        this.createUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScript() {
        try {
            ScriptTypeSelectionDialog scriptTypeSelectionDialog = new ScriptTypeSelectionDialog((Component)((Object)this));
            AWTUtilities.centerWindow((Window)scriptTypeSelectionDialog, (Component)((Object)this));
            String string = scriptTypeSelectionDialog.askScriptType();
            if (string == null) {
                return;
            }
            ScriptDialog scriptDialog = this.scriptDialogForType(string, null);
            if (scriptDialog == null) {
                throw new IllegalStateException("Unknown script type: " + string);
            }
            AWTUtilities.centerWindow((Window)scriptDialog, (Component)((Object)this));
            Script script = scriptDialog.askForScript();
            if (script != null) {
                this.scriptsListModel.addElement(script);
                this.fireStateChanged();
            }
        }
        finally {
            SwingUtilities.windowForComponent((Component)((Object)this)).toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editScript(Script script) {
        try {
            String string = script.getType();
            ScriptDialog scriptDialog = this.scriptDialogForType(string, script);
            if (scriptDialog == null) {
                throw new IllegalStateException("Unknown script type: " + string);
            }
            AWTUtilities.centerWindow((Window)scriptDialog, (Component)((Object)this));
            Script script2 = scriptDialog.askForScript();
            if (script2 != null) {
                int n = this.scriptsListModel.indexOf(script);
                this.scriptsListModel.removeElementAt(n);
                this.scriptsListModel.insertElementAt(script2, n);
                this.fireStateChanged();
            }
        }
        finally {
            SwingUtilities.windowForComponent((Component)((Object)this)).toFront();
        }
    }

    private void deleteScript(Script script) {
        this.scriptsListModel.removeElement(script);
        this.fireStateChanged();
    }

    private ScriptDialog scriptDialogForType(String string, Script script) {
        if ("commands".equals(string)) {
            return new CommandsScriptDialog((Component)((Object)this), this.scripter, (CommandScript)script);
        }
        if ("beanshell".equals(string)) {
            return new BeanShellScriptDialog((Component)((Object)this), this.scripter, (BeanShellScript)script);
        }
        return null;
    }

    protected void createUI() {
        I18n i18n = I18n.get((Class)ScripterPreferencesPanel.class);
        this.setLayout(new BorderLayout(10, 5));
        final JList jList = new JList(this.scriptsListModel);
        jList.setSelectionMode(0);
        jList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getModifiers() == 16 && (n = jList.getSelectedIndex()) != -1) {
                    ScripterPreferencesPanel.this.editScript((Script)ScripterPreferencesPanel.this.scriptsListModel.getElementAt(n));
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 31);
        jScrollPane.setPreferredSize(new Dimension(200, 70));
        JLabel jLabel = i18n.createLabel("scriptsLabel");
        jLabel.setLabelFor(jLabel);
        JButton jButton = i18n.createButton("addScriptButton");
        final JButton jButton2 = i18n.createButton("editScriptButton");
        final JButton jButton3 = i18n.createButton("removeScriptButton");
        final JCheckBox jCheckBox = i18n.createCheckBox("scriptEnabledCheckBox");
        jButton2.setEnabled(false);
        jButton3.setEnabled(false);
        jCheckBox.setEnabled(false);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = jList.getSelectedIndex();
                if (n == -1) {
                    jButton2.setEnabled(false);
                    jButton3.setEnabled(false);
                    jCheckBox.setEnabled(false);
                } else {
                    Script script = (Script)ScripterPreferencesPanel.this.scriptsListModel.getElementAt(n);
                    jButton2.setEnabled(true);
                    jButton3.setEnabled(true);
                    jCheckBox.setEnabled(true);
                    jCheckBox.setSelected(script.isEnabled());
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScripterPreferencesPanel.this.addScript();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jList.getSelectedIndex();
                ScripterPreferencesPanel.this.editScript((Script)ScripterPreferencesPanel.this.scriptsListModel.getElementAt(n));
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jList.getSelectedIndex();
                ScripterPreferencesPanel.this.deleteScript((Script)ScripterPreferencesPanel.this.scriptsListModel.getElementAt(n));
                if (n < ScripterPreferencesPanel.this.scriptsListModel.getSize()) {
                    jList.setSelectedIndex(n);
                } else if (ScripterPreferencesPanel.this.scriptsListModel.getSize() != 0) {
                    jList.setSelectedIndex(ScripterPreferencesPanel.this.scriptsListModel.getSize() - 1);
                } else {
                    jButton2.setEnabled(false);
                    jButton3.setEnabled(false);
                    jCheckBox.setEnabled(false);
                }
            }
        });
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jList.getSelectedIndex();
                Script script = (Script)ScripterPreferencesPanel.this.scriptsListModel.getElementAt(n);
                ScripterPreferencesPanel.this.scriptsListModel.removeElementAt(n);
                Script script2 = script.createCopy();
                script2.setEnabled(jCheckBox.isSelected());
                ScripterPreferencesPanel.this.scriptsListModel.insertElementAt(script2, n);
                jList.setSelectedIndex(n);
                ScripterPreferencesPanel.this.fireStateChanged();
            }
        });
        jButton.setDefaultCapable(false);
        jButton2.setDefaultCapable(false);
        jButton3.setDefaultCapable(false);
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 5));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        box.add(jPanel);
        box.add(Box.createVerticalGlue());
        this.add(jLabel, "North");
        this.add(jScrollPane, "Center");
        this.add(box, "East");
        this.add(jCheckBox, "South");
    }

    public void applyChanges() throws BadChangesException {
        Object object;
        int n;
        Script[] scriptArray = this.scripter.getScripts();
        Object[] objectArray = new Script[this.scriptsListModel.getSize()];
        this.scriptsListModel.copyInto(objectArray);
        for (n = 0; n < scriptArray.length; ++n) {
            object = scriptArray[n];
            int n2 = Utilities.indexOf((Object[])objectArray, (Object)object);
            if (n2 == -1) {
                this.scripter.removeScript((Script)object);
                continue;
            }
            objectArray[n2] = null;
        }
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            if (object == null) continue;
            this.scripter.addScript((Script)object);
        }
    }

    private class ScriptTypeSelectionDialog
    extends JDialog {
        private String scriptType;
        WindowDisposingListener closer;

        public ScriptTypeSelectionDialog(Component component) {
            super(AWTUtilities.frameForComponent((Component)component), "", true);
            this.closer = new WindowDisposingListener(this){

                public void beforeDisposing(EventObject eventObject) {
                    ScriptTypeSelectionDialog.this.scriptType = null;
                }
            };
            this.setTitle(I18n.get((Class)(class$free$jin$scripter$ScripterPreferencesPanel == null ? (class$free$jin$scripter$ScripterPreferencesPanel = ScripterPreferencesPanel.class$("free.jin.scripter.ScripterPreferencesPanel")) : class$free$jin$scripter$ScripterPreferencesPanel)).getString("scriptTypeSelectionDialog.title"));
            this.setDefaultCloseOperation(0);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.getRootPane().registerKeyboardAction((ActionListener)this.closer, keyStroke, 2);
            this.addWindowListener((WindowListener)this.closer);
            this.createUI();
        }

        private void createUI() {
            I18n i18n = I18n.get((Class)(class$free$jin$scripter$ScripterPreferencesPanel == null ? (class$free$jin$scripter$ScripterPreferencesPanel = ScripterPreferencesPanel.class$("free.jin.scripter.ScripterPreferencesPanel")) : class$free$jin$scripter$ScripterPreferencesPanel));
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            this.setContentPane(jPanel);
            jPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
            JRadioButton jRadioButton = i18n.createRadioButton("serverCommandsScriptTypeRadioButton");
            JRadioButton jRadioButton2 = i18n.createRadioButton("beanshellScriptTypeRadioButton");
            jRadioButton.setActionCommand("commands");
            jRadioButton2.setActionCommand("beanshell");
            final ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
            jPanel2.add(jRadioButton);
            jPanel2.add(jRadioButton2);
            FixedJTextArea fixedJTextArea = new FixedJTextArea(){
                private Dimension prefSize = null;

                public boolean isFocusTraversable() {
                    return false;
                }

                public Dimension getPreferredSize() {
                    if (this.prefSize == null) {
                        this.prefSize = this.calculatePreferredSize();
                    }
                    return this.prefSize;
                }

                private Dimension calculatePreferredSize() {
                    I18n i18n = I18n.get((Class)(class$free$jin$scripter$ScripterPreferencesPanel == null ? (class$free$jin$scripter$ScripterPreferencesPanel = ScripterPreferencesPanel.class$("free.jin.scripter.ScripterPreferencesPanel")) : class$free$jin$scripter$ScripterPreferencesPanel));
                    String[] stringArray = new String[]{i18n.getString("scriptExplanation.commands"), i18n.getString("scriptExplanation.beanshell")};
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    int n = 0;
                    int n2 = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "\n");
                        if (stringTokenizer.countTokens() * fontMetrics.getHeight() > n2) {
                            n2 = stringTokenizer.countTokens() * fontMetrics.getHeight();
                        }
                        while (stringTokenizer.hasMoreTokens()) {
                            String string = stringTokenizer.nextToken();
                            int n3 = fontMetrics.stringWidth(string);
                            if (n3 <= n) continue;
                            n = n3;
                        }
                    }
                    return new Dimension(n, n2);
                }
            };
            fixedJTextArea.setEditable(false);
            fixedJTextArea.setOpaque(false);
            ActionListener actionListener = new ActionListener((JTextArea)fixedJTextArea){
                private final /* synthetic */ JTextArea val$typeExplanationTextArea;
                {
                    this.val$typeExplanationTextArea = jTextArea;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonModel buttonModel = buttonGroup.getSelection();
                    ScriptTypeSelectionDialog.this.scriptType = buttonModel.getActionCommand();
                    String string = I18n.get((Class)(class$free$jin$scripter$ScripterPreferencesPanel == null ? (class$free$jin$scripter$ScripterPreferencesPanel = ScripterPreferencesPanel.class$("free.jin.scripter.ScripterPreferencesPanel")) : class$free$jin$scripter$ScripterPreferencesPanel)).getString("scriptExplanation." + ScriptTypeSelectionDialog.this.scriptType);
                    this.val$typeExplanationTextArea.setText(string);
                }
            };
            jRadioButton.addActionListener(actionListener);
            jRadioButton2.addActionListener(actionListener);
            JButton jButton = i18n.createButton("scriptTypeSelectionDialog.nextButton");
            JButton jButton2 = i18n.createButton("scriptTypeSelectionDialog.cancelButton");
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel3.add(jButton);
            jPanel3.add(jButton2);
            jButton.addActionListener((ActionListener)new WindowDisposingListener((Window)this));
            jButton2.addActionListener((ActionListener)this.closer);
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)fixedJTextArea, "Center");
            jPanel.add((Component)jPanel3, "South");
            this.getRootPane().setDefaultButton(jButton);
        }

        public String askScriptType() {
            this.setVisible(true);
            return this.scriptType;
        }
    }
}

