/*
 * Decompiled with CFR 0.152.
 */
package free.chess.variants;

import free.chess.ChessMove;
import free.chess.ChessPiece;
import free.chess.ChesslikeGenericVariant;
import free.chess.Move;
import free.chess.Player;
import free.chess.Position;
import free.chess.Square;

public class BothSidesCastlingVariant
extends ChesslikeGenericVariant {
    public BothSidesCastlingVariant(String string, String string2) {
        super(string, string2);
    }

    public boolean isShortCastling(Position position, Square square, Square square2, ChessPiece chessPiece) {
        if (chessPiece != null) {
            return false;
        }
        ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(square);
        ChessPiece chessPiece3 = (ChessPiece)position.getPieceAt(square2);
        if (chessPiece3 != null) {
            return false;
        }
        if (chessPiece2 == ChessPiece.WHITE_KING) {
            if (square.equals("e1") && square2.equals("g1") && position.getPieceAt("h1") == ChessPiece.WHITE_ROOK && position.getPieceAt("f1") == null) {
                return true;
            }
            if (square.equals("d1") && square2.equals("b1") && position.getPieceAt("a1") == ChessPiece.WHITE_ROOK && position.getPieceAt("c1") == null) {
                return true;
            }
        } else if (chessPiece2 == ChessPiece.BLACK_KING) {
            if (square.equals("e8") && square2.equals("g8") && position.getPieceAt("h8") == ChessPiece.BLACK_ROOK && position.getPieceAt("f8") == null) {
                return true;
            }
            if (square.equals("d8") && square2.equals("b8") && position.getPieceAt("a8") == ChessPiece.BLACK_ROOK && position.getPieceAt("c8") == null) {
                return true;
            }
        }
        return false;
    }

    public boolean isLongCastling(Position position, Square square, Square square2, ChessPiece chessPiece) {
        if (chessPiece != null) {
            return false;
        }
        ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(square);
        ChessPiece chessPiece3 = (ChessPiece)position.getPieceAt(square2);
        if (chessPiece3 != null) {
            return false;
        }
        if (chessPiece2 == ChessPiece.WHITE_KING) {
            if (square.equals("e1") && square2.equals("c1") && position.getPieceAt("a1") == ChessPiece.WHITE_ROOK && position.getPieceAt("b1") == null && position.getPieceAt("d1") == null) {
                return true;
            }
            return square.equals("d1") && square2.equals("f1") && position.getPieceAt("h1") == ChessPiece.WHITE_ROOK && position.getPieceAt("e1") == null && position.getPieceAt("g1") == null;
        }
        if (chessPiece2 == ChessPiece.BLACK_KING) {
            if (square.equals("e8") && square2.equals("c8") && position.getPieceAt("a8") == ChessPiece.BLACK_ROOK && position.getPieceAt("b8") == null && position.getPieceAt("d8") == null) {
                return true;
            }
            return square.equals("d8") && square2.equals("f8") && position.getPieceAt("h8") == ChessPiece.BLACK_ROOK && position.getPieceAt("e8") == null && position.getPieceAt("g8") == null;
        }
        return false;
    }

    public void makeMove(Move move, Position position, Position.Modifier modifier) {
        this.checkPosition(position);
        if (!(move instanceof ChessMove)) {
            throw new IllegalArgumentException("The given move must be an instance of " + ChessMove.class.getName());
        }
        ChessMove chessMove = (ChessMove)move;
        Square square = chessMove.getStartingSquare();
        Square square2 = chessMove.getEndingSquare();
        ChessPiece chessPiece = (ChessPiece)position.getPieceAt(square);
        if (chessMove.isCastling()) {
            int n = chessMove.isShortCastling() ^ square.getFile() == 3 ? 1 : -1;
            int n2 = n == -1 ? 0 : 7;
            Square square3 = Square.getInstance(n2, square.getRank());
            Square square4 = Square.getInstance(square2.getFile() - n, square.getRank());
            ChessPiece chessPiece2 = (ChessPiece)position.getPieceAt(square3);
            modifier.setPieceAt(null, square);
            modifier.setPieceAt(null, square3);
            modifier.setPieceAt(chessPiece, square2);
            modifier.setPieceAt(chessPiece2, square4);
            modifier.setCurrentPlayer(position.getCurrentPlayer().getOpponent());
        } else {
            super.makeMove(move, position, modifier);
        }
    }

    public Move createShortCastling(Position position) {
        this.checkPosition(position);
        Player player = position.getCurrentPlayer();
        if (player.isWhite()) {
            if (position.getPieceAt(Square.parseSquare("e1")) == ChessPiece.WHITE_KING) {
                return WHITE_SHORT_CASTLING;
            }
            if (position.getPieceAt(Square.parseSquare("d1")) == ChessPiece.WHITE_KING) {
                return new ChessMove(Square.parseSquare("d1"), Square.parseSquare("b1"), Player.WHITE_PLAYER, false, true, false, null, -1, null, "O-O");
            }
            throw new IllegalArgumentException("Castling is not allowed in the specified position");
        }
        if (position.getPieceAt(Square.parseSquare("e8")) == ChessPiece.BLACK_KING) {
            return BLACK_SHORT_CASTLING;
        }
        if (position.getPieceAt(Square.parseSquare("d8")) == ChessPiece.BLACK_KING) {
            return new ChessMove(Square.parseSquare("d8"), Square.parseSquare("b8"), Player.BLACK_PLAYER, false, true, false, null, -1, null, "O-O");
        }
        throw new IllegalArgumentException("Castling is not allowed in the specified position");
    }

    public Move createLongCastling(Position position) {
        this.checkPosition(position);
        Player player = position.getCurrentPlayer();
        if (player.isWhite()) {
            if (position.getPieceAt(Square.parseSquare("e1")) == ChessPiece.WHITE_KING) {
                return WHITE_LONG_CASTLING;
            }
            if (position.getPieceAt(Square.parseSquare("d1")) == ChessPiece.WHITE_KING) {
                return new ChessMove(Square.parseSquare("d1"), Square.parseSquare("f1"), Player.WHITE_PLAYER, false, false, true, null, -1, null, "O-O-O");
            }
            throw new IllegalArgumentException("Castling is not allowed in the specified position");
        }
        if (position.getPieceAt(Square.parseSquare("e8")) == ChessPiece.BLACK_KING) {
            return BLACK_LONG_CASTLING;
        }
        if (position.getPieceAt(Square.parseSquare("d8")) == ChessPiece.BLACK_KING) {
            return new ChessMove(Square.parseSquare("d8"), Square.parseSquare("f8"), Player.BLACK_PLAYER, false, false, true, null, -1, null, "O-O-O");
        }
        throw new IllegalArgumentException("Castling is not allowed in the specified position");
    }
}

