/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.VCursor;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JPanel;
import net.claribole.zvtm.engine.RepaintListener;
import net.claribole.zvtm.engine.ViewEventHandler;
import net.claribole.zvtm.lens.Lens;

public abstract class ViewPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
ComponentListener {
    public static final short NONE = 0;
    public static final short OVAL = 1;
    public static final short CIRCLE = 2;
    Graphics2D backBufferGraphics = null;
    GraphicsConfiguration gconf;
    Graphics2D stableRefToBackBufferGraphics = null;
    Thread runView;
    public Camera[] cams;
    public int activeLayer = 0;
    public View parent;
    boolean inside = false;
    boolean active = true;
    ViewEventHandler[] evHs;
    boolean repaintNow = true;
    RepaintListener repaintListener;
    boolean updateMouseOnly = false;
    boolean alwaysRepaintMe = false;
    boolean notBlank = true;
    Color blankColor = null;
    boolean computeListAtEachRepaint = false;
    int frameTime = 25;
    int minimumSleepTime = 10;
    int noRepaintAdditionalTime = 20;
    int inactiveSleepTime = 500;
    int blankSleepTime = 100;
    public long loopStartTime;
    public long loopTotalTime;
    long timeToSleep;
    Color backColor = Color.BLACK;
    Stroke standardStroke;
    AffineTransform standardTransform;
    float uncoef;
    long viewW;
    long viewH;
    long viewWC;
    long viewNC;
    long viewEC;
    long viewSC;
    int[] visibilityPadding = new int[]{0, 0, 0, 0};
    Dimension size;
    int camIndex;
    int beginAt = 0;
    Vector drawnGlyphs;
    Glyph gl;
    Glyph[] gll;
    boolean updateFont = false;
    boolean updateAntialias = true;
    boolean antialias = false;
    protected int oldX = 0;
    protected int oldY = 0;
    protected int origDragx;
    protected int origDragy;
    protected int curDragx;
    protected int curDragy;
    boolean drawDrag = false;
    boolean drawRect = false;
    boolean drawOval = false;
    boolean circleOnly = false;
    protected boolean drawVTMcursor = true;
    protected Cursor awtCursor;
    protected Lens lens;
    int cursorInsidePortals = 0;
    Timer timer = new Timer(true);
    int currentTaskID = 0;
    long resizeDelay = 200L;

    public abstract void stop();

    void setEventHandler(ViewEventHandler eh, int layer) {
        this.evHs[layer] = eh;
    }

    public ViewEventHandler[] getEventHandlers() {
        return this.evHs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetCursorInsidePortals() {
        ViewPanel viewPanel = this;
        synchronized (viewPanel) {
            this.cursorInsidePortals = 0;
            for (int i = 0; i < this.parent.portals.length; ++i) {
                if (!this.parent.portals[i].coordInside(this.oldX, this.oldY)) continue;
                ++this.cursorInsidePortals;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCursorInsidePortals(int x, int y) {
        ViewPanel viewPanel = this;
        synchronized (viewPanel) {
            for (int i = 0; i < this.parent.portals.length; ++i) {
                this.cursorInsidePortals += this.parent.portals[i].cursorInOut(x, y);
            }
        }
    }

    protected void setAWTCursor(int cursorType) {
        block6: {
            if (cursorType == -1) {
                BufferedImage cImage = new BufferedImage(1, 1, 2);
                try {
                    this.awtCursor = Toolkit.getDefaultToolkit().createCustomCursor(cImage, new Point(0, 0), "zvtmCursor");
                    this.drawVTMcursor = true;
                }
                catch (IndexOutOfBoundsException e) {
                    VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
                    if (VirtualSpaceManager.debug) {
                        System.err.println("Error while creating custom cursor " + e);
                        this.awtCursor = new Cursor(1);
                        this.drawVTMcursor = false;
                    }
                    break block6;
                }
            }
            this.drawVTMcursor = false;
            try {
                this.awtCursor = Cursor.getPredefinedCursor(cursorType);
            }
            catch (IndexOutOfBoundsException e) {
                VirtualSpaceManager cfr_ignored_1 = this.parent.parent;
                if (!VirtualSpaceManager.debug) break block6;
                System.err.println("Error while creating AWT cursor " + e);
                this.awtCursor = new Cursor(0);
            }
        }
        this.setCursor(this.awtCursor);
    }

    protected void setAWTCursor(Cursor c) {
        this.awtCursor = c;
        this.drawVTMcursor = false;
        this.setCursor(this.awtCursor);
    }

    public void setDrawDrag(boolean b) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawDrag = b;
        this.parent.repaintNow();
    }

    public void setDrawSegment(boolean b) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawDrag = b;
        this.parent.repaintNow();
    }

    public void setDrawRect(boolean b) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        this.drawRect = b;
        this.parent.repaintNow();
    }

    public void setDrawOval(short s) {
        this.curDragx = this.origDragx;
        this.curDragy = this.origDragy;
        if (s == 1) {
            this.drawOval = true;
            this.circleOnly = false;
        } else if (s == 2) {
            this.drawOval = true;
            this.circleOnly = true;
        } else if (s == 0) {
            this.drawOval = false;
        }
        this.parent.repaintNow();
    }

    public void mousePressed(MouseEvent e) {
        if (this.evHs[this.activeLayer] == null) {
            return;
        }
        int whichButton = e.getModifiers();
        this.origDragx = e.getX();
        this.origDragy = e.getY();
        if ((whichButton & 0x10) == 16) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].press1(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].press1(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].press1(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].press1(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].press1(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].press1(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].press1(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].press1(this, 0, e.getX(), e.getY(), e);
            }
        } else if ((whichButton & 8) == 8) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].press2(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].press2(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].press2(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].press2(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].press2(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].press2(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].press2(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].press2(this, 0, e.getX(), e.getY(), e);
            }
        } else if ((whichButton & 4) == 4) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].press3(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].press3(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].press3(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].press3(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].press3(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].press3(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].press3(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].press3(this, 0, e.getX(), e.getY(), e);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.evHs[this.activeLayer] == null) {
            return;
        }
        int whichButton = e.getModifiers();
        if ((whichButton & 0x10) == 16) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].click1(this, 3, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].click1(this, 5, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].click1(this, 7, e.getX(), e.getY(), e.getClickCount(), e);
                } else {
                    this.evHs[this.activeLayer].click1(this, 1, e.getX(), e.getY(), e.getClickCount(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].click1(this, 2, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].click1(this, 4, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].click1(this, 6, e.getX(), e.getY(), e.getClickCount(), e);
            } else {
                this.evHs[this.activeLayer].click1(this, 0, e.getX(), e.getY(), e.getClickCount(), e);
            }
        } else if ((whichButton & 8) == 8) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].click2(this, 3, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].click2(this, 5, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].click2(this, 7, e.getX(), e.getY(), e.getClickCount(), e);
                } else {
                    this.evHs[this.activeLayer].click2(this, 1, e.getX(), e.getY(), e.getClickCount(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].click2(this, 2, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].click2(this, 4, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].click2(this, 6, e.getX(), e.getY(), e.getClickCount(), e);
            } else {
                this.evHs[this.activeLayer].click2(this, 0, e.getX(), e.getY(), e.getClickCount(), e);
            }
        } else if ((whichButton & 4) == 4) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].click3(this, 3, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].click3(this, 5, e.getX(), e.getY(), e.getClickCount(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].click3(this, 7, e.getX(), e.getY(), e.getClickCount(), e);
                } else {
                    this.evHs[this.activeLayer].click3(this, 1, e.getX(), e.getY(), e.getClickCount(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].click3(this, 2, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].click3(this, 4, e.getX(), e.getY(), e.getClickCount(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].click3(this, 6, e.getX(), e.getY(), e.getClickCount(), e);
            } else {
                this.evHs[this.activeLayer].click3(this, 0, e.getX(), e.getY(), e.getClickCount(), e);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.evHs[this.activeLayer] == null) {
            return;
        }
        int whichButton = e.getModifiers();
        if ((whichButton & 0x10) == 16) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].release1(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].release1(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].release1(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].release1(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].release1(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].release1(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].release1(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].release1(this, 0, e.getX(), e.getY(), e);
            }
        } else if ((whichButton & 8) == 8) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].release2(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].release2(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].release2(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].release2(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].release2(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].release2(this, 4, e.getX(), e.getY(), e);
            } else if (e.isAltDown()) {
                this.evHs[this.activeLayer].release2(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].release2(this, 0, e.getX(), e.getY(), e);
            }
        } else if ((whichButton & 4) == 4) {
            if (e.isShiftDown()) {
                if (e.isControlDown()) {
                    this.evHs[this.activeLayer].release3(this, 3, e.getX(), e.getY(), e);
                } else if (e.isMetaDown()) {
                    this.evHs[this.activeLayer].release3(this, 5, e.getX(), e.getY(), e);
                } else if (e.isAltDown()) {
                    this.evHs[this.activeLayer].release3(this, 7, e.getX(), e.getY(), e);
                } else {
                    this.evHs[this.activeLayer].release3(this, 1, e.getX(), e.getY(), e);
                }
            } else if (e.isControlDown()) {
                this.evHs[this.activeLayer].release3(this, 2, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].release3(this, 4, e.getX(), e.getY(), e);
            } else if (e.isMetaDown()) {
                this.evHs[this.activeLayer].release3(this, 6, e.getX(), e.getY(), e);
            } else {
                this.evHs[this.activeLayer].release3(this, 0, e.getX(), e.getY(), e);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.active = true;
        this.repaintNow = true;
        this.inside = true;
        this.parent.parent.setActiveView(this.parent);
    }

    public void mouseExited(MouseEvent e) {
        this.inside = false;
        if (!this.parent.isSelected() && !this.alwaysRepaintMe) {
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(MouseEvent e) {
        block8: {
            try {
                if (!this.parent.parent.mouseSync) break block8;
                ViewPanel viewPanel = this;
                synchronized (viewPanel) {
                    this.parent.mouse.moveTo(e.getX(), e.getY());
                    this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                    this.updateMouseOnly = true;
                }
                this.parent.mouse.propagateMove();
                this.updateCursorInsidePortals(e.getX(), e.getY());
                if (this.evHs[this.activeLayer] != null) {
                    if (this.parent.notifyMouseMoved) {
                        this.evHs[this.activeLayer].mouseMoved(this, e.getX(), e.getY(), e);
                    }
                    if (this.parent.mouse.isSensitive() && this.parent.mouse.computeMouseOverList(this.evHs[this.activeLayer], this.cams[this.activeLayer], this.lens)) {
                        this.parent.repaintNow();
                    }
                }
            }
            catch (NullPointerException ex) {
                VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
                if (!VirtualSpaceManager.debug) break block8;
                System.err.println("viewpanel.mousemoved " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        block24: {
            int whichButton = e.getModifiers();
            int buttonNumber = 0;
            try {
                if (this.parent.parent.mouseSync) {
                    this.parent.mouse.moveTo(e.getX(), e.getY());
                    this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                    this.parent.mouse.propagateMove();
                    this.updateCursorInsidePortals(e.getX(), e.getY());
                    if (this.evHs[this.activeLayer] != null) {
                        if ((whichButton & 0x10) == 16) {
                            buttonNumber = 1;
                        } else if ((whichButton & 8) == 8) {
                            buttonNumber = 2;
                        } else if ((whichButton & 4) == 4) {
                            buttonNumber = 3;
                        }
                        if (e.isShiftDown()) {
                            if (e.isControlDown()) {
                                this.evHs[this.activeLayer].mouseDragged(this, 3, buttonNumber, e.getX(), e.getY(), e);
                            } else if (e.isMetaDown()) {
                                this.evHs[this.activeLayer].mouseDragged(this, 5, buttonNumber, e.getX(), e.getY(), e);
                            } else if (e.isAltDown()) {
                                this.evHs[this.activeLayer].mouseDragged(this, 7, buttonNumber, e.getX(), e.getY(), e);
                            } else {
                                this.evHs[this.activeLayer].mouseDragged(this, 1, buttonNumber, e.getX(), e.getY(), e);
                            }
                        } else if (e.isControlDown()) {
                            this.evHs[this.activeLayer].mouseDragged(this, 2, buttonNumber, e.getX(), e.getY(), e);
                        } else if (e.isMetaDown()) {
                            this.evHs[this.activeLayer].mouseDragged(this, 4, buttonNumber, e.getX(), e.getY(), e);
                        } else if (e.isAltDown()) {
                            this.evHs[this.activeLayer].mouseDragged(this, 6, buttonNumber, e.getX(), e.getY(), e);
                        } else {
                            this.evHs[this.activeLayer].mouseDragged(this, 0, buttonNumber, e.getX(), e.getY(), e);
                        }
                    }
                    this.curDragx = e.getX();
                    this.curDragy = e.getY();
                    this.parent.repaintNow();
                    if (this.parent.mouse.isSensitive()) {
                        this.parent.mouse.computeMouseOverList(this.evHs[this.activeLayer], this.cams[this.activeLayer], this.lens);
                    }
                }
            }
            catch (NullPointerException ex) {
                VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
                if (!VirtualSpaceManager.debug) break block24;
                System.err.println("viewpanel.mousedragged " + ex);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        block3: {
            if (this.evHs[this.activeLayer] != null) {
                try {
                    this.evHs[this.activeLayer].mouseWheelMoved(this, e.getWheelRotation() < 0 ? (short)0 : 1, e.getX(), e.getY(), e);
                }
                catch (NullPointerException ex) {
                    VirtualSpaceManager cfr_ignored_0 = this.parent.parent;
                    if (!VirtualSpaceManager.debug) break block3;
                    System.err.println("viewpanel.mousewheelmoved " + ex);
                }
            }
        }
    }

    public VCursor getMouse() {
        return this.parent.getCursor();
    }

    public VCursor getVCursor() {
        return this.parent.getCursor();
    }

    public Glyph lastGlyphEntered() {
        return this.parent.mouse.lastGlyphEntered;
    }

    public Glyph[] getGlyphsUnderMouseList() {
        return this.parent.mouse.getGlyphsUnderMouseList();
    }

    public Vector getGlyphsUnderMouse() {
        return this.parent.mouse.getGlyphsUnderMouse();
    }

    public abstract BufferedImage getImage();

    protected void setRefreshRate(int r) {
        if (r > 0) {
            this.frameTime = r;
        } else {
            System.err.println("Error: trying to set a negative refresh rate : " + r + " ms");
        }
    }

    protected int getRefreshRate() {
        return this.frameTime;
    }

    protected Lens setLens(Lens l) {
        if (l != null) {
            this.lens = l;
            if (this.lens.getID() == null) {
                this.lens.setID(new Integer(this.parent.parent.nextlID++));
                Vector<Object> v = new Vector<Object>();
                v.addElement(this.lens);
                v.addElement(this.parent);
                this.parent.parent.allLenses.put(this.lens.getID(), v);
            }
            this.lens.setLensBuffer(this);
            this.parent.repaintNow();
            return this.lens;
        }
        if (this.lens != null) {
            this.parent.parent.allLenses.remove(this.lens.getID());
            this.lens = null;
            this.parent.repaintNow();
        }
        return null;
    }

    protected Lens getLens() {
        return this.lens;
    }

    protected void setVisibilityPadding(int[] wnesPadding) {
        this.visibilityPadding = wnesPadding;
    }

    protected int[] getVisibilityPadding() {
        return this.visibilityPadding;
    }

    public void componentResized(ComponentEvent e) {
        ResizeTask task = new ResizeTask(++this.currentTaskID);
        this.timer.schedule((TimerTask)task, this.resizeDelay);
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    private class ResizeTask
    extends TimerTask {
        private int id;

        public ResizeTask(int id) {
            this.id = id;
        }

        public void run() {
            if (this.id == ViewPanel.this.currentTaskID) {
                ViewPanel.this.parent.repaintNow();
                ViewPanel.this.currentTaskID = 0;
            }
        }
    }
}

