/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.text.DateFormatUtil;
import java.util.Comparator;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeListColumn<T extends ChangeList> {
    public static final ChangeListColumn<CommittedChangeList> DATE = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.date", new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                1.$$$reportNull$$$0(1);
            }
            String string = DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate());
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator = Comparator.comparing(CommittedChangeList::getCommitDate);
            if (comparator == null) {
                1.$$$reportNull$$$0(3);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ChangeListColumn$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ChangeListColumn$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final ChangeListColumn<CommittedChangeList> NAME = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.committer", new Object[0]);
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                2.$$$reportNull$$$0(1);
            }
            return changeList.getCommitterName();
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator comparator = (changeList1, changeList2) -> Comparing.compare((Comparable)((Object)changeList1.getCommitterName()), (Comparable)((Object)changeList2.getCommitterName()));
            if (comparator == null) {
                2.$$$reportNull$$$0(2);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ChangeListColumn$2";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ChangeListColumn$2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final ChangeListColumn<CommittedChangeList> NUMBER = new ChangeListNumberColumn(VcsBundle.message("column.name.revision.list.number", new Object[0]));
    public static final ChangeListColumn<CommittedChangeList> DESCRIPTION = new ChangeListColumn<CommittedChangeList>(){

        @Override
        @NotNull
        public String getTitle() {
            String string = VcsBundle.message("column.name.revision.list.description", new Object[0]);
            if (string == null) {
                3.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                3.$$$reportNull$$$0(1);
            }
            String string = changeList.getName();
            if (string == null) {
                3.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator = Comparator.comparing(list -> list.getName(), String::compareToIgnoreCase);
            if (comparator == null) {
                3.$$$reportNull$$$0(3);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ChangeListColumn$3";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ChangeListColumn$3";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public abstract String getTitle();

    public abstract Object getValue(T var1);

    @Nullable
    public Comparator<T> getComparator() {
        return null;
    }

    public static boolean isCustom(@NotNull ChangeListColumn column) {
        if (column == null) {
            ChangeListColumn.$$$reportNull$$$0(0);
        }
        return column != DATE && column != DESCRIPTION && column != NAME && !(column instanceof ChangeListNumberColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/openapi/vcs/ChangeListColumn", "isCustom"));
    }

    public static class ChangeListNumberColumn
    extends ChangeListColumn<CommittedChangeList> {
        private final String myTitle;

        public ChangeListNumberColumn(String title) {
            this.myTitle = title;
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        @NotNull
        public Object getValue(@NotNull CommittedChangeList changeList) {
            if (changeList == null) {
                ChangeListNumberColumn.$$$reportNull$$$0(0);
            }
            Long l = changeList.getNumber();
            if (l == null) {
                ChangeListNumberColumn.$$$reportNull$$$0(1);
            }
            return l;
        }

        @Override
        @NotNull
        public Comparator<CommittedChangeList> getComparator() {
            Comparator<CommittedChangeList> comparator = Comparator.comparingLong(CommittedChangeList::getNumber);
            if (comparator == null) {
                ChangeListNumberColumn.$$$reportNull$$$0(2);
            }
            return comparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeList";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ChangeListColumn$ChangeListNumberColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ChangeListColumn$ChangeListNumberColumn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

