/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.stubs.TypeScriptFunctionSignatureStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class TypeScriptPsiTypeParser<P extends ES6Parser>
extends JSPsiTypeParser<P> {
    private static final TokenSet NON_REFERENCE_PRIMITIVE_TYPES = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.VOID_KEYWORD, JSTokenTypes.ANY_KEYWORD, JSTokenTypes.SYMBOL_KEYWORD, JSTokenTypes.NEVER_KEYWORD, JSTokenTypes.UNKNOWN_KEYWORD, JSTokenTypes.OBJECT_TYPE_KEYWORD, JSTokenTypes.MIXED_KEYWORD, JSTokenTypes.NULL_KEYWORD});
    protected static final Predicate<PsiBuilder> AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE = builder -> {
        IElementType type = builder.getTokenType();
        if (type == null || type == JSTokenTypes.COMMA || type == JSTokenTypes.SEMICOLON || type == JSTokenTypes.QUEST || type == JSTokenTypes.COLON || type == JSTokenTypes.LPAR) {
            return false;
        }
        return !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(builder);
    };
    private static final JSModifiersStructure TYPE_MEMBER_MODIFIERS = new JSModifiersStructureLeaf(JSTokenTypes.READONLY_KEYWORD);

    protected TypeScriptPsiTypeParser(P parser) {
        super(parser);
    }

    @Override
    public boolean tryParseType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            return this.parseType();
        }
        return false;
    }

    @Override
    public boolean parseType() {
        PsiBuilder.Marker mark = this.builder.mark();
        if (!this.parseInUnionOrIntersectionType(true, true, true)) {
            mark.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD && !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder)) {
            boolean result2 = this.parseConditionalType();
            mark.done(TypeScriptElementTypes.CONDITIONAL_TYPE);
            return result2;
        }
        mark.drop();
        return true;
    }

    private boolean parseConditionalType() {
        this.builder.advanceLexer();
        if (!this.parseType()) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type.name", (Object[])new Object[0]));
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.QUEST) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.question", (Object[])new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        if (!this.parseType()) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type.name", (Object[])new Object[0]));
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        if (!this.parseType()) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type.name", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean parseInUnionOrIntersectionType(boolean expectedUnion, boolean isTopLevel, boolean functionTypeAllowedByContext) {
        boolean result2;
        int typeCounter = 0;
        PsiBuilder.Marker unionTypeMarker = this.builder.mark();
        do {
            if (this.builder.getTokenType() == JSTokenTypes.OR || this.builder.getTokenType() == JSTokenTypes.AND) {
                this.builder.advanceLexer();
            }
            boolean bl = expectedUnion ? this.parseInUnionOrIntersectionType(false, isTopLevel && typeCounter == 1, functionTypeAllowedByContext) : (result2 = this.parseUnionOrIntersectionComponent(this.isFunctionTypeAllowed(isTopLevel && ++typeCounter == 1, functionTypeAllowedByContext)));
        } while (result2 && this.builder.getTokenType() == (expectedUnion ? JSTokenTypes.OR : JSTokenTypes.AND));
        if (typeCounter == 1) {
            unionTypeMarker.drop();
        } else {
            unionTypeMarker.done(TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE);
        }
        return result2;
    }

    protected boolean isFunctionTypeAllowed(boolean isFirstComponent, boolean allowedByContext) {
        return isFirstComponent && allowedByContext;
    }

    protected boolean parseUnionOrIntersectionComponent(boolean functionTypeAllowed) {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.KEYOF_KEYWORD) {
            return this.parseTypeOperator();
        }
        if (type == JSTokenTypes.INFER_KEYWORD && this.parseInferType()) {
            return true;
        }
        return this.parseDistinctType(functionTypeAllowed);
    }

    private boolean parseInferType() {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        IElementType type = this.builder.getTokenType();
        if (this.isIdentifierToken(type)) {
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.INFER_TYPE);
            return true;
        }
        marker.rollbackTo();
        return false;
    }

    protected boolean parseTypeOperator() {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        boolean result2 = this.parseUnionOrIntersectionComponent(true);
        marker.done(TypeScriptElementTypes.TYPE_OPERATOR_TYPE);
        return result2;
    }

    protected boolean parseDistinctType(boolean functionTypeAllowed) {
        boolean result2;
        IElementType type = this.builder.getTokenType();
        PsiBuilder.Marker typeMarker = this.builder.mark();
        if (type == JSTokenTypes.LPAR) {
            boolean isFunctionType;
            boolean bl = isFunctionType = functionTypeAllowed && this.isFunctionTypeExpected();
            if (isFunctionType) {
                result2 = this.parseFunctionType();
            } else {
                PsiBuilder.Marker parenthesized = this.builder.mark();
                this.builder.advanceLexer();
                result2 = this.parseType();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
                    this.builder.advanceLexer();
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
                    result2 = false;
                }
                parenthesized.done(TypeScriptElementTypes.PARENTHESIZED_TYPE);
            }
        } else if (type == JSTokenTypes.NEW_KEYWORD || type == JSTokenTypes.LT) {
            result2 = this.parseFunctionType();
        } else if (type == JSTokenTypes.LBRACE) {
            result2 = this.isStartOfMappedType() ? this.parseMappedType() : this.parseObjectType();
        } else if (type == JSTokenTypes.LBRACKET) {
            result2 = this.parseTupleType();
        } else if (type == JSTokenTypes.IMPORT_KEYWORD) {
            result2 = true;
            PsiBuilder.Marker marker = this.builder.mark();
            this.parseImportTypeInner();
            marker.done(TypeScriptElementTypes.SINGLE_TYPE);
        } else if (type == JSTokenTypes.TYPEOF_KEYWORD) {
            if (this.builder.lookAhead(1) == JSTokenTypes.IMPORT_KEYWORD) {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                this.parseImportTypeInner();
                marker.done(TypeScriptElementTypes.SINGLE_TYPE);
            } else {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                if (!((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                }
                marker.done(TypeScriptElementTypes.TYPEOF_TYPE);
            }
            result2 = true;
        } else if (type == JSTokenTypes.THIS_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.IS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.THIS_TYPE);
            result2 = true;
        } else if (type == JSTokenTypes.PARTIAL_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            result2 = this.parseType();
            if (!result2) {
                marker.rollbackTo();
                result2 = this.parserSingleType();
            } else {
                marker.done(TypeScriptElementTypes.PARTIAL_TYPE);
            }
        } else if (type == JSTokenTypes.THIS_KEYWORD || NON_REFERENCE_PRIMITIVE_TYPES.contains(type) || this.isIdentifierToken(type)) {
            IElementType lookAhead = this.builder.lookAhead(1);
            if (lookAhead == JSTokenTypes.IS_KEYWORD) {
                PsiBuilder.Marker marker = this.builder.mark();
                PsiBuilder.Marker innerMarker = this.builder.mark();
                this.builder.advanceLexer();
                innerMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
                if (!TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder)) {
                    result2 = this.parseTypePredicate(marker);
                } else {
                    marker.rollbackTo();
                    result2 = this.parseSingleOrPrimitiveType();
                }
            } else {
                boolean isUniqueSymbol = false;
                if (this.isIdentifierToken(lookAhead) && "unique".equals(this.builder.getTokenText())) {
                    PsiBuilder.Marker mark = this.builder.mark();
                    this.builder.advanceLexer();
                    if (!"symbol".equals(this.builder.getTokenText())) {
                        mark.rollbackTo();
                    } else {
                        this.builder.advanceLexer();
                        mark.done(TypeScriptElementTypes.SINGLE_TYPE);
                        isUniqueSymbol = true;
                    }
                }
                result2 = isUniqueSymbol || this.parseSingleOrPrimitiveType();
            }
        } else if (JSTokenTypes.STRING_LITERALS.contains(type)) {
            this.parseSingleTokenLiteralType(TypeScriptElementTypes.STRING_LITERAL_TYPE);
            result2 = true;
        } else if (type == JSTokenTypes.NUMERIC_LITERAL || type == JSTokenTypes.MINUS && this.builder.lookAhead(1) == JSTokenTypes.NUMERIC_LITERAL) {
            PsiBuilder.Marker literalTypeMark = this.builder.mark();
            PsiBuilder.Marker prefixMark = null;
            if (type == JSTokenTypes.MINUS) {
                prefixMark = this.builder.mark();
                this.builder.advanceLexer();
            }
            PsiBuilder.Marker expressionMarker = this.builder.mark();
            this.builder.advanceLexer();
            expressionMarker.done(JSStubElementTypes.LITERAL_EXPRESSION);
            if (prefixMark != null) {
                prefixMark.done(JSElementTypes.PREFIX_EXPRESSION);
            }
            literalTypeMark.done(TypeScriptElementTypes.NUMBER_LITERAL_TYPE);
            result2 = true;
        } else if (JSTokenTypes.BOOLEAN_LITERALS.contains(type)) {
            this.parseSingleTokenLiteralType(TypeScriptElementTypes.BOOLEAN_LITERAL_TYPE);
            result2 = true;
        } else {
            this.builder.error(this.getTypeNameExpectedMessage());
            result2 = false;
        }
        return result2 &= this.parseArrayTypeSuffix(typeMarker);
    }

    private void parseImportTypeInner() {
        PsiBuilder.Marker expr = this.builder.mark();
        PsiBuilder.Marker call = this.builder.mark();
        ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseImportCall(call);
        if (!((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeNameRest(false, expr)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
    }

    protected boolean parseArrayTypeSuffix(@NotNull PsiBuilder.Marker typeMarker) {
        if (typeMarker == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(0);
        }
        boolean result2 = true;
        while (this.builder.getTokenType() == JSTokenTypes.LBRACKET && !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder)) {
            this.builder.advanceLexer();
            if (this.isStartOfType()) {
                this.parseType();
                if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                    result2 = false;
                    break;
                }
                this.builder.advanceLexer();
                typeMarker.done(TypeScriptElementTypes.INDEXED_ACCESS_TYPE);
                typeMarker = typeMarker.precede();
                continue;
            }
            if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                result2 = false;
                break;
            }
            this.builder.advanceLexer();
            typeMarker.done(TypeScriptElementTypes.ARRAY_TYPE);
            typeMarker = typeMarker.precede();
        }
        typeMarker.drop();
        return result2;
    }

    private void parseSingleTokenLiteralType(@NotNull JSStubElementType literalType) {
        if (literalType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker typeMarker = this.builder.mark();
        PsiBuilder.Marker expressionMarker = this.builder.mark();
        this.builder.advanceLexer();
        expressionMarker.done(JSStubElementTypes.LITERAL_EXPRESSION);
        typeMarker.done((IElementType)literalType);
    }

    private boolean parseSingleOrPrimitiveType() {
        if (NON_REFERENCE_PRIMITIVE_TYPES.contains(this.builder.getTokenType())) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.SINGLE_TYPE);
            return true;
        }
        return this.parserSingleType();
    }

    protected boolean parserSingleType() {
        PsiBuilder.Marker marker = this.builder.mark();
        boolean result2 = ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName();
        marker.done(TypeScriptElementTypes.SINGLE_TYPE);
        return result2;
    }

    private boolean parseTypePredicate(PsiBuilder.Marker marker) {
        this.builder.advanceLexer();
        boolean result2 = this.parseType();
        marker.done(TypeScriptElementTypes.TYPE_PREDICATE);
        return result2;
    }

    protected boolean isFunctionTypeExpected() {
        return this.isFunctionTypeExpected(0);
    }

    private boolean isFunctionTypeExpected(int startIndex) {
        IElementType elementTypeAfterRPar;
        IElementType elementTypeAfterLPar = this.builder.lookAhead(startIndex + 1);
        if (elementTypeAfterLPar == null || elementTypeAfterLPar == JSTokenTypes.RPAR) {
            return true;
        }
        if (elementTypeAfterLPar == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        if (FunctionParser.willParseDestructuringAssignment(elementTypeAfterLPar) && ((FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).isArrowFunctionWithParentheses()) {
            return true;
        }
        if (elementTypeAfterLPar != JSTokenTypes.THIS_KEYWORD && !this.isIdentifierToken(elementTypeAfterLPar)) {
            return false;
        }
        IElementType elementTypeAfterIdentifier = this.builder.lookAhead(startIndex + 2);
        if (elementTypeAfterIdentifier == JSTokenTypes.COMMA || elementTypeAfterIdentifier == JSTokenTypes.COLON || elementTypeAfterIdentifier == JSTokenTypes.QUEST) {
            return true;
        }
        return elementTypeAfterIdentifier == JSTokenTypes.RPAR && (elementTypeAfterRPar = this.builder.lookAhead(startIndex + 3)) == JSTokenTypes.EQGT;
    }

    private boolean parseFunctionType() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        boolean result2 = this.parseFunctionParameterList();
        result2 = this.parseFunctionReturnType(marker, result2);
        return result2;
    }

    protected boolean parseFunctionReturnType(PsiBuilder.Marker marker, boolean result2) {
        result2 &= TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.EQGT, "javascript.parser.message.expected.eqgt");
        marker.done(TypeScriptElementTypes.FUNCTION_TYPE);
        return result2 &= this.parseType();
    }

    private boolean parseTupleType() {
        boolean result2 = true;
        PsiBuilder.Marker marker = this.builder.mark();
        assert (this.builder.getTokenType() == JSTokenTypes.LBRACKET);
        this.builder.advanceLexer();
        boolean commaExpected = false;
        while (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
            if (this.builder.eof()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                marker.done(TypeScriptElementTypes.TUPLE_TYPE);
                return false;
            }
            if (commaExpected && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.tuple.comma.or.rbracket")) {
                result2 = false;
                break;
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(this.getTypeNameExpectedMessage());
                while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                }
            }
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET && this.allowLastCommaInTupleType()) break;
            PsiBuilder.Marker mark = null;
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                mark = this.builder.mark();
                this.builder.advanceLexer();
            }
            if (!this.parseType()) {
                result2 = false;
                if (mark == null) break;
                mark.drop();
                break;
            }
            if (mark != null) {
                mark.done(TypeScriptElementTypes.SPREAD_TYPE);
            } else if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.advanceLexer();
            }
            commaExpected = true;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            result2 = false;
        }
        marker.done(TypeScriptElementTypes.TUPLE_TYPE);
        return result2;
    }

    protected boolean allowLastCommaInTupleType() {
        return false;
    }

    public boolean parseObjectType() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
            return false;
        }
        return this.parseObjectType(JSTokenTypes.RBRACE, "javascript.parser.message.missing.rbrace");
    }

    public boolean parseMappedType() {
        PsiBuilder.Marker mark = this.builder.mark();
        boolean result2 = this.parseMappedTypeNoMarker();
        mark.done(TypeScriptElementTypes.MAPPED_TYPE);
        return result2;
    }

    protected boolean isStartOfMappedType() {
        IElementType nextToken;
        int startCheckIndex = 1;
        IElementType type = this.builder.lookAhead(1);
        if (type == JSTokenTypes.PLUS || type == JSTokenTypes.MINUS) {
            type = this.builder.lookAhead(2);
            ++startCheckIndex;
        }
        if (type == JSTokenTypes.READONLY_KEYWORD) {
            ++startCheckIndex;
        }
        if ((nextToken = this.builder.lookAhead(startCheckIndex)) == null) {
            return false;
        }
        if (nextToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType afterNext = this.builder.lookAhead(startCheckIndex + 1);
        if (!this.isIdentifierToken(afterNext)) {
            return false;
        }
        return this.builder.lookAhead(startCheckIndex + 2) == JSTokenTypes.IN_KEYWORD;
    }

    protected boolean parseMappedTypeNoMarker() {
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            return false;
        }
        IElementType tokenType = this.builder.getTokenType();
        boolean mustHaveReadonly = false;
        if (tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
            mustHaveReadonly = true;
        }
        if (!mustHaveReadonly && this.builder.getTokenType() == JSTokenTypes.READONLY_KEYWORD) {
            this.builder.advanceLexer();
        }
        if (mustHaveReadonly && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.READONLY_KEYWORD, "javascript.parser.message.expected.readonly")) {
            return false;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.LBRACKET, "javascript.parser.message.expected.lbracket")) {
            return false;
        }
        if (!this.parseMappedTypeParameter()) {
            return false;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            return false;
        }
        boolean mustHaveQuestion = false;
        tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
            mustHaveQuestion = true;
        }
        if (!mustHaveQuestion && this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        if (mustHaveQuestion && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.QUEST, "javascript.parser.message.expected.question")) {
            return false;
        }
        this.tryParseType();
        ((StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).forceCheckForSemicolon();
        return TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
    }

    protected boolean parseMappedTypeParameter() {
        PsiBuilder.Marker parameter = this.builder.mark();
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            parameter.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.IN_KEYWORD, "javascript.parser.message.expected.in")) {
            parameter.drop();
            return false;
        }
        boolean result2 = this.parseType();
        parameter.done(TypeScriptElementTypes.MAPPED_TYPE_PARAMETER);
        return result2;
    }

    protected final boolean parseObjectType(@NotNull IElementType rBraceType, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String missingRBraceMessageKey) {
        if (rBraceType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(2);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != rBraceType) {
            if (this.builder.eof()) {
                this.builder.error(JSBundle.message((String)missingRBraceMessageKey, (Object[])new Object[0]));
                marker.done(TypeScriptElementTypes.OBJECT_TYPE);
                return false;
            }
            this.parseTypeMember();
        }
        this.builder.advanceLexer();
        marker.done(TypeScriptElementTypes.OBJECT_TYPE);
        return true;
    }

    protected boolean parseTypeMember() {
        PsiBuilder.Marker typeMember = this.builder.mark();
        ((ES6Parser)this.myJavaScriptParser).parseModifiers(TYPE_MEMBER_MODIFIERS, true, AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE);
        return this.parseTypeMember(typeMember);
    }

    protected final boolean parseTypeMember(@NotNull PsiBuilder.Marker typeMember) {
        boolean result2;
        IElementType firstToken;
        if (typeMember == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(3);
        }
        if (this.isFunctionHeaderStart(firstToken = this.builder.getTokenType()) || firstToken == JSTokenTypes.NEW_KEYWORD && this.isFunctionHeaderStart(this.builder.lookAhead(1))) {
            result2 = this.parseFunctionHeaderNoMarker(typeMember, (IElementType)JSStubElementTypes.CALL_SIGNATURE);
        } else if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
            ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).advancePropertyName(firstToken);
            result2 = this.parseInterfaceSimplePropertyOrFunction(typeMember);
        } else if (firstToken == JSTokenTypes.LBRACKET) {
            if (this.isIndexSignatureProperty()) {
                result2 = this.parseIndexSignatureNoMarker(typeMember, false);
            } else {
                ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
                result2 = this.parseInterfaceSimplePropertyOrFunction(typeMember);
            }
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type.member", (Object[])new Object[0]));
            this.builder.advanceLexer();
            typeMember.drop();
            result2 = false;
        }
        this.forceCheckForSemicolonOrComma();
        return result2;
    }

    protected boolean isFunctionHeaderStart(IElementType token) {
        return token == JSTokenTypes.LPAR || token == JSTokenTypes.LT;
    }

    protected void forceCheckForSemicolonOrComma() {
        boolean checkForComma;
        boolean checkForSemicolon = ((StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).checkForSemicolon();
        if (!(checkForSemicolon || (checkForComma = this.checkForComma()) || TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder))) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.newline.or.semicolon", (Object[])new Object[0]));
        }
    }

    private boolean checkForComma() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    public boolean parseInterfaceSimplePropertyOrFunction(PsiBuilder.Marker typeMember) {
        boolean result2;
        if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        if (this.isFunctionHeaderStart(this.builder.getTokenType())) {
            result2 = this.parseFunctionHeaderNoMarker(typeMember, this.getFunctionSignatureElementType());
        } else {
            result2 = this.tryParseType();
            typeMember.done(TypeScriptElementTypes.PROPERTY_SIGNATURE);
            typeMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
        return result2;
    }

    @NotNull
    protected IElementType getFunctionSignatureElementType() {
        JSStubElementType<TypeScriptFunctionSignatureStub, TypeScriptFunctionSignature> jSStubElementType = JSStubElementTypes.FUNCTION_SIGNATURE;
        if (jSStubElementType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(4);
        }
        return jSStubElementType;
    }

    public boolean isIndexSignatureProperty() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType secondToken = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(secondToken)) {
            return false;
        }
        IElementType thirdToken = this.builder.lookAhead(2);
        return thirdToken == JSTokenTypes.COLON;
    }

    private boolean parseFunctionHeaderNoMarker(PsiBuilder.Marker marker, IElementType elementType) {
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        assert (this.isFunctionHeaderStart(this.builder.getTokenType()));
        boolean result2 = this.parseFunctionParameterList();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return result2 &= this.tryParseType();
    }

    protected boolean parseFunctionParameterList() {
        return ((FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterList(false);
    }

    public boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, boolean checkSemicolon) {
        return TypeScriptPsiTypeParser.parseIndexSignatureNoMarker(marker, this.builder, (ES6Parser)this.myJavaScriptParser, checkSemicolon, true);
    }

    public static boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, PsiBuilder builder, ES6Parser parser, boolean checkSemicolon, boolean requireVarName) {
        boolean isVarWithType;
        assert (builder.getTokenType() == JSTokenTypes.LBRACKET);
        builder.advanceLexer();
        boolean bl = isVarWithType = builder.lookAhead(1) == JSTokenTypes.COLON;
        if (isVarWithType) {
            if (requireVarName && !parser.isIdentifierToken(builder.getTokenType())) {
                builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
                marker.drop();
                return false;
            }
            builder.advanceLexer();
            if (builder.getTokenType() != JSTokenTypes.COLON) {
                builder.error(JSBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
                marker.drop();
                return false;
            }
            builder.advanceLexer();
        }
        boolean result2 = ((JSPsiTypeParser)parser.getTypeParser()).parseType();
        if (builder.getTokenType() != JSTokenTypes.RBRACKET) {
            builder.error(JSBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
            marker.drop();
            return false;
        }
        builder.advanceLexer();
        result2 &= ((JSPsiTypeParser)parser.getTypeParser()).tryParseType();
        if (checkSemicolon) {
            ((StatementParser)parser.getStatementParser()).forceCheckForSemicolon();
        }
        marker.done(TypeScriptElementTypes.INDEX_SIGNATURE);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return result2;
    }

    protected boolean isStartOfType() {
        return this.isStartOfType(this.builder.getTokenType(), 0);
    }

    protected boolean isStartOfType(IElementType type, int startIndex) {
        if (type == null) {
            return false;
        }
        if (NON_REFERENCE_PRIMITIVE_TYPES.contains(type) || JSKeywordSets.PRIMITIVE_TYPES.contains(type) || JSTokenTypes.THIS_KEYWORD == type || JSTokenTypes.TYPEOF_KEYWORD == type || JSTokenTypes.NEW_KEYWORD == type || JSTokenTypes.STRING_LITERAL == type || JSTokenTypes.NUMERIC_LITERAL == type || JSTokenTypes.TRUE_KEYWORD == type || JSTokenTypes.FALSE_KEYWORD == type || JSTokenTypes.LBRACE == type || JSTokenTypes.LBRACKET == type || JSTokenTypes.LT == type) {
            return true;
        }
        if (JSTokenTypes.MINUS == type && this.builder.lookAhead(startIndex + 1) == JSTokenTypes.NUMERIC_LITERAL) {
            return true;
        }
        if (type == JSTokenTypes.LPAR) {
            if (this.isFunctionTypeExpected(startIndex)) {
                return true;
            }
            IElementType lookAheadElement = this.builder.lookAhead(startIndex + 1);
            if (lookAheadElement == JSTokenTypes.RPAR) {
                return true;
            }
            return this.isStartOfType(lookAheadElement, startIndex + 1);
        }
        return this.isIdentifierToken(type);
    }

    @Override
    public boolean tryParseTypeParameterList() {
        boolean result2 = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            PsiBuilder.Marker typeParameterList = this.builder.mark();
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                    typeParameterList.drop();
                    return false;
                }
                if (!first && this.builder.getTokenType() == JSTokenTypes.GT) break;
                boolean typeParameterParsed = this.parseTypeParameter();
                result2 &= typeParameterParsed;
                if (!typeParameterParsed) {
                    this.builder.advanceLexer();
                }
                first = false;
            }
            this.builder.advanceLexer();
            typeParameterList.done(TypeScriptElementTypes.TYPE_PARAMETER_LIST);
        }
        return result2;
    }

    protected boolean parseTypeParameter() {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            return false;
        }
        PsiBuilder.Marker typeParameter = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            this.builder.advanceLexer();
            PsiBuilder.Marker constraint = this.builder.mark();
            this.parseType();
            constraint.done((IElementType)TypeScriptElementTypes.TYPE_PARAMETER_CONSTRAINT);
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            PsiBuilder.Marker defaultType = this.builder.mark();
            this.parseType();
            defaultType.done((IElementType)TypeScriptElementTypes.TYPE_PARAMETER_DEFAULT);
        }
        typeParameter.done(TypeScriptElementTypes.TYPE_PARAMETER);
        return true;
    }

    public boolean parseOptionalTypeArgumentList() {
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            IElementType tokenType;
            PsiBuilder.Marker marker = this.builder.mark();
            if (((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseTypeArgumentList(true) && this.isAcceptableTokenTypeAfterTypeArguments(tokenType = this.builder.getTokenType())) {
                marker.drop();
                return true;
            }
            marker.rollbackTo();
        }
        return false;
    }

    protected boolean isAcceptableTokenTypeAfterTypeArguments(IElementType tokenType) {
        return tokenType == JSTokenTypes.LPAR || tokenType == JSTokenTypes.BACKQUOTE;
    }

    @Override
    public boolean tryParseTypeArgumentList(boolean revert, boolean allowNewLine) {
        boolean result2 = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT && (allowNewLine || !TypeScriptPsiTypeParser.hasSemanticLinefeedBefore(this.builder))) {
            PsiBuilder.Marker typeArgumentList = this.builder.mark();
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first) {
                    if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                        if (revert) {
                            typeArgumentList.rollbackTo();
                        } else {
                            typeArgumentList.drop();
                        }
                        return false;
                    }
                    if (this.builder.getTokenType() == JSTokenTypes.GT) break;
                }
                if (!(result2 &= this.parseTypeInGenericArgument()) && revert) {
                    typeArgumentList.rollbackTo();
                    return false;
                }
                first = false;
            }
            this.builder.advanceLexer();
            typeArgumentList.done(TypeScriptElementTypes.TYPE_ARGUMENT_LIST);
        }
        return result2;
    }

    public boolean parseTypeInGenericArgument() {
        PsiBuilder.Marker outer = null;
        if (this.isIdentifierToken(this.builder.getTokenType()) && this.builder.lookAhead(1) == JSTokenTypes.EQ) {
            outer = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
        }
        boolean result2 = ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).parseType();
        if (outer != null) {
            outer.done(TypeScriptElementTypes.NAMED_GENERIC_ARGUMENT_TYPE);
        }
        return result2;
    }

    @Override
    public boolean parseTypeAliasType() {
        if (this.builder.getTokenType() != JSTokenTypes.EQ) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.equal", (Object[])new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        return this.parseType();
    }

    @Override
    @NotNull
    protected String getTypeNameExpectedMessage() {
        String string = JSBundle.message((String)"javascript.parser.message.expected.typename", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMarker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBraceType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameExpectedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayTypeSuffix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseSingleTokenLiteralType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseObjectType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeMember";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

