/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugStrategy;
import com.jetbrains.php.debug.common.PhpEditMappingsHyperlink;
import com.jetbrains.php.debug.common.PhpEditServersHyperlink;
import com.jetbrains.php.debug.ui.PhpMappingAdvancedResolveDialog;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteServerDebugStrategy
extends PhpDebugStrategy {
    private final Project myProject;
    private final String myServerName;

    public PhpRemoteServerDebugStrategy(@NotNull Project project, @NotNull String serverName) {
        if (project == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(0);
        }
        if (serverName == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myServerName = serverName;
    }

    @Override
    public PhpPathMapper getPathMapper() {
        PhpServer server = this.getServer();
        if (server != null) {
            return PhpPathMapper.create(server);
        }
        return null;
    }

    @Nullable
    public final PhpServer getServer() {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return PhpProjectConfigurationFacade.getInstance(this.myProject).findServer(this.myServerName);
    }

    @Override
    public void onCannotFindPathMapper(@NotNull XCompositeNode node, @NotNull Runnable reloader) {
        if (node == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(2);
        }
        if (reloader == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(3);
        }
        node.setErrorMessage(PhpBundle.message("debug.process.cannot.find.server.name", this.myServerName) + "\n", (XDebuggerTreeNodeHyperlink)new PhpEditServersHyperlink(this.myProject, reloader));
    }

    @Override
    public void onCannotFindLocalPath(@NotNull XCompositeNode node, @NotNull String remoteFilePath, Runnable reloader) {
        if (node == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(4);
        }
        if (remoteFilePath == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(5);
        }
        node.setErrorMessage(PhpBundle.message("debug.process.cannot.find.path.mapping", remoteFilePath) + "\n", (XDebuggerTreeNodeHyperlink)new PhpEditMappingsHyperlink(this.myProject, this.myServerName, remoteFilePath, reloader));
    }

    @Override
    public void onCannotFindLocalFile(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull String localPath, Runnable reloader) {
        if (node == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(6);
        }
        if (remoteFilePath == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(7);
        }
        if (localPath == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(8);
        }
        node.setErrorMessage(PhpBundle.message("debug.process.cannot.find.local.file", remoteFilePath, localPath) + "\n", (XDebuggerTreeNodeHyperlink)new PhpEditMappingsHyperlink(this.myProject, this.myServerName, remoteFilePath, reloader));
    }

    @Override
    public void onScriptOutsideProject(@NotNull XCompositeNode node, @NotNull String remoteFilePath, @NotNull VirtualFile localFile, @NotNull Runnable reloader) {
        if (node == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(9);
        }
        if (remoteFilePath == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(10);
        }
        if (localFile == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(11);
        }
        if (reloader == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(12);
        }
        node.setMessage(PhpBundle.message("debug.process.script.outside.project", remoteFilePath), UIUtil.getBalloonWarningIcon(), SimpleTextAttributes.REGULAR_ATTRIBUTES, (XDebuggerTreeNodeHyperlink)new PhpEditMappingsHyperlink(this.myProject, this.myServerName, remoteFilePath, reloader));
    }

    @Override
    public List<? extends AnAction> getAdditionalBreakpointPopupMenuActions(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        String remoteFilePath;
        PhpPathMapper pathMapper;
        XSourcePosition sourcePosition;
        if (breakpoint == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(13);
        }
        if ((sourcePosition = breakpoint.getSourcePosition()) != null && (pathMapper = this.getPathMapper()) != null && (remoteFilePath = pathMapper.getRemoteFilePath(sourcePosition.getFile())) == null) {
            return Collections.singletonList(new MyEditPathMappingsAction(sourcePosition.getFile()));
        }
        return super.getAdditionalBreakpointPopupMenuActions(breakpoint);
    }

    @Override
    public void registerPathMappingsChangedCallback(final @NotNull PhpDebugProcess.PathMappingsChangedCallback callback) {
        if (callback == null) {
            PhpRemoteServerDebugStrategy.$$$reportNull$$$0(14);
        }
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(PhpProjectConfigurationFacade.StateChangedListener.TOPIC, (Object)new PhpProjectConfigurationFacade.StateChangedListener(){

            @Override
            public void stateChanged() {
                callback.pathMappingsChanged();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloader";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpRemoteServerDebugStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onCannotFindPathMapper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "onCannotFindLocalPath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "onCannotFindLocalFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "onScriptOutsideProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalBreakpointPopupMenuActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "registerPathMappingsChangedCallback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyEditPathMappingsAction
    extends AnAction {
        @NotNull
        private final VirtualFile myLocalFile;

        private MyEditPathMappingsAction(VirtualFile localFile) {
            if (localFile == null) {
                MyEditPathMappingsAction.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("debug.edit.path.mappings", new Object[0]));
            this.myLocalFile = localFile;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PhpServer server;
            if (e == null) {
                MyEditPathMappingsAction.$$$reportNull$$$0(1);
            }
            if ((server = PhpRemoteServerDebugStrategy.this.getServer()) != null) {
                PhpUiUtil.show(new PhpMappingAdvancedResolveDialog(PhpRemoteServerDebugStrategy.this.myProject, this.myLocalFile.getPath(), "", server, false));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/debug/common/PhpRemoteServerDebugStrategy$MyEditPathMappingsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

