/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.util.XmlTagUtilBase;
import com.jetbrains.php.lang.documentation.PhpDefaultDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLinkTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNamedElementDocSource
extends PhpDefaultDocSource {
    protected PhpNamedElement myElement;

    public PhpNamedElementDocSource(PhpNamedElement element) {
        super((PhpPsiElement)element);
        this.myElement = element;
        this.myDocComment = this.myElement.getDocComment();
    }

    @Override
    @NotNull
    public String getTitle() {
        String title = XmlTagUtilBase.escapeString((String)this.myElement.getText(), (boolean)false);
        String string = title == null ? "" : title;
        if (string == null) {
            PhpNamedElementDocSource.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String[] description = new String[]{""};
        this.myElement.processDocs(comment -> {
            String superDesc = PhpDocUtil.getDescription(comment);
            if (!superDesc.isEmpty()) {
                description[0] = description[0].isEmpty() ? superDesc : StringUtil.replace((String)description[0], (String)"@inheritdoc", (String)superDesc);
                return false;
            }
            return true;
        });
        StringBuilder descBuilder = new StringBuilder();
        this.appendTagDescriptions("@var", descBuilder);
        this.appendTagDescriptions("@xglobal", descBuilder);
        descBuilder.append(description[0]);
        String string = descBuilder.toString();
        if (string == null) {
            PhpNamedElementDocSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void appendTagDescriptions(String tagName, StringBuilder descBuilder) {
        PhpDocTag[] tags;
        if (this.myDocComment == null) {
            return;
        }
        for (PhpDocTag tag : tags = this.myDocComment.getTagElementsByName(tagName)) {
            String tagDesc = PhpDocUtil.getTagValue((PsiElement)tag);
            descBuilder.append(tagDesc).append('\n');
        }
    }

    @Override
    public String getReturnType() {
        return PhpNamedElementDocSource.getReturnType(this.myElement);
    }

    protected static String getReturnType(PhpNamedElement element) {
        StringBuilder buffer = new StringBuilder();
        PhpType type = element.getType();
        Project project = element.getProject();
        PhpNamedElementDocSource.appendType(buffer, type, element.getNamespaceName(), project);
        return buffer.toString();
    }

    public static void appendType(StringBuilder buffer, PhpType type, @Nullable String ns, Project project) {
        if (!type.isEmpty()) {
            type = DumbService.getInstance((Project)project).isDumb() ? type : type.global(project);
            for (String s : type.getTypesSorted()) {
                if (StringUtil.startsWithChar((CharSequence)s, (char)'?')) continue;
                if (PhpType.isPrimitiveType((String)s) || PhpType.isPluralPrimitiveType((String)s)) {
                    buffer.append(PhpType.toString((String)s));
                    buffer.append("|");
                    continue;
                }
                PhpNamedElementDocSource.appendLink(buffer, s, ns);
                buffer.append("|");
            }
            int bufferLength = buffer.length();
            if (bufferLength > 0 && buffer.charAt(bufferLength - 1) == '|') {
                buffer.setLength(bufferLength - 1);
            }
        }
    }

    @Override
    public String getReturnDescription() {
        return null;
    }

    @Override
    public String getSince() {
        if (this.myDocComment == null) {
            return null;
        }
        PhpDocTag[] sinceTags = this.myDocComment.getTagElementsByName("@since");
        if (sinceTags.length == 0) {
            return null;
        }
        return PhpDocUtil.getTagValue((PsiElement)sinceTags[0]);
    }

    @Override
    public String getUses() {
        return this.getSeeItemsInternal("@uses");
    }

    @Override
    public String getLinks() {
        if (this.myDocComment == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        PhpDocLinkTag[] linkTags = this.myDocComment.getLinkTags();
        if (linkTags == null) {
            return null;
        }
        for (PhpDocLinkTag linkTag : linkTags) {
            if (linkTag.getText().contains("}")) continue;
            String url = linkTag.getURL();
            String value = linkTag.getTagValue();
            if (StringUtil.isEmpty((String)value)) {
                value = url;
            }
            if (buf.length() > 0) {
                buf.append("<br>");
            }
            buf.append("<a href='").append(linkTag.getURL()).append("'>").append(value).append("</a>");
        }
        return buf.toString();
    }

    @Override
    public String getSeeItems() {
        return this.getSeeItemsInternal("@see");
    }

    private String getSeeItemsInternal(String name) {
        PhpDocTag[] seeTags;
        if (this.myDocComment == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (PhpDocTag seeTag : seeTags = this.myDocComment.getTagElementsByName(name)) {
            List<PsiElement> types = PhpPsiUtil.getChildren((PsiElement)seeTag, (Condition<? super PsiElement>)((Condition)element -> PhpPsiUtil.isOfType(element, (IElementType)PhpDocElementTypes.phpDocRef)));
            if (!types.isEmpty()) {
                for (PsiElement child : types) {
                    PhpNamedElementDocSource.appendLink(buf, child.getText(), null);
                    buf.append(", ");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.append(" ").append(seeTag.getTagValue());
            } else {
                PsiElement url;
                PsiElement value = PhpPsiUtil.getChildOfType((PsiElement)seeTag, (IElementType)PhpDocElementTypes.phpDocTagValue);
                if (value != null && (url = PhpPsiUtil.getChildOfType(value, PhpDocTokenTypes.DOC_URL)) != null) {
                    String urlText = url.getText();
                    buf.append("<a href='").append(urlText).append("'>");
                    String valueText = value.getText().substring(urlText.length()).trim();
                    if (valueText.isEmpty()) {
                        valueText = url.getText();
                    }
                    buf.append(valueText).append("</a>");
                }
            }
            buf.append("<br>");
        }
        if (seeTags.length > 0) {
            buf.delete(buf.length() - 4, buf.length());
        }
        return buf.toString();
    }

    public static void appendLink(StringBuilder buf, String link, @Nullable String ns) {
        if (link != null && link.trim().length() != 0) {
            link = link.trim();
            buf.append("<a href='").append(PhpNamedElementDocSource.getLinkUrl(link)).append("'>");
            String name = ns != null && link.startsWith(ns) ? link.substring(ns.length()) : link.substring(1);
            buf.append(StringUtil.startsWithChar((CharSequence)link, (char)'\\') ? name : link);
            buf.append("</a>");
        }
    }

    private static String getLinkUrl(String link) {
        String linkPrefix = "";
        if (!link.startsWith("http://")) {
            linkPrefix = "psi_element://";
        }
        return linkPrefix + link.trim();
    }

    @Override
    public String getVersion() {
        if (this.myDocComment == null) {
            return null;
        }
        PhpDocTag[] verTags = this.myDocComment.getTagElementsByName("@version");
        if (verTags.length == 0) {
            return null;
        }
        return PhpDocUtil.getTagValue((PsiElement)verTags[0]);
    }

    @Override
    public String getNamespace() {
        return this.myElement.getNamespaceName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/documentation/PhpNamedElementDocSource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

