/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.inplace;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import java.util.Collection;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInplaceVariableIntroducer
extends InplaceVariableIntroducer<PsiElement> {
    public PhpInplaceVariableIntroducer(PsiNamedElement element, PhpIntroduceContext context, String title) {
        super(element, context.getEditor(), context.getProject(), title, context.getOccurrences(), null);
    }

    public PhpInplaceVariableIntroducer(PsiNamedElement element, PhpIntroduceContext context) {
        this(element, context, "Introduce Variable");
    }

    protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
        PsiElement elementToSelect = this.findElementToSelect(refs);
        this.adjustCaret(elementToSelect);
        return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
    }

    protected void adjustCaret(PsiElement elementToSelect) {
        PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(this.myEditor, elementToSelect, new TextRange(0, elementToSelect.getTextLength()));
    }

    @NotNull
    private PsiElement findElementToSelect(@NotNull Collection<PsiReference> occurrences) {
        if (occurrences == null) {
            PhpInplaceVariableIntroducer.$$$reportNull$$$0(0);
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        Optional elementAtCaret = StreamEx.of(occurrences).map(PsiReference::getElement).findAny(occurrence -> occurrence.getTextRange().contains(offset));
        if (elementAtCaret.isPresent()) {
            PsiElement psiElement = (PsiElement)elementAtCaret.get();
            if (psiElement == null) {
                PhpInplaceVariableIntroducer.$$$reportNull$$$0(1);
            }
            return psiElement;
        }
        int line = this.myEditor.getDocument().getLineNumber(offset);
        PsiElement psiElement = (PsiElement)StreamEx.of(occurrences).map(PsiReference::getElement).findAny(occurrence -> this.myEditor.getDocument().getLineNumber(occurrence.getTextRange().getStartOffset()) == line).orElse(this.myElementToRename);
        if (psiElement == null) {
            PhpInplaceVariableIntroducer.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpInplaceVariableIntroducer.$$$reportNull$$$0(3);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpInplaceVariableIntroducer.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpInplaceVariableIntroducer.$$$reportNull$$$0(5);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), reference.getElement());
        if (textRange == null) {
            PhpInplaceVariableIntroducer.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        return this.myElementToRename.getContainingFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/inplace/PhpInplaceVariableIntroducer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/inplace/PhpInplaceVariableIntroducer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementToSelect";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementToSelect";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

