/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.PicoPluginExtensionInitializationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ExtensionComponentAdapter
implements LoadingOrder.Orderable,
AssignableToComponentAdapter {
    public static final ExtensionComponentAdapter[] EMPTY_ARRAY = new ExtensionComponentAdapter[0];
    private Object myComponentInstance;
    @Nullable
    private final Element myExtensionElement;
    private final PicoContainer myContainer;
    private final PluginDescriptor myPluginDescriptor;
    @NotNull
    private Object myImplementationClassOrName;
    private boolean myNotificationSent;
    private final String myOrderId;
    private final LoadingOrder myOrder;

    public ExtensionComponentAdapter(@NotNull String implementationClassName, @Nullable PicoContainer container, @Nullable PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement) {
        if (implementationClassName == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(0);
        }
        if (order == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(1);
        }
        this.myImplementationClassOrName = implementationClassName;
        this.myContainer = container;
        this.myPluginDescriptor = pluginDescriptor;
        this.myExtensionElement = extensionElement;
        this.myOrderId = orderId;
        this.myOrder = order;
    }

    public ExtensionComponentAdapter(@NotNull String implementationClassName, @Nullable Element extensionElement, PicoContainer container, PluginDescriptor pluginDescriptor) {
        if (implementationClassName == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(2);
        }
        this(implementationClassName, container, pluginDescriptor, null, LoadingOrder.ANY, extensionElement);
    }

    public Object getComponentKey() {
        return this;
    }

    public Class getComponentImplementation() {
        return this.loadImplementationClass();
    }

    public Object getComponentInstance(PicoContainer container) throws PicoException, ProcessCanceledException {
        if (this.myComponentInstance == null) {
            try {
                Class impl = this.loadImplementationClass();
                Object componentInstance = new CachingConstructorInjectionComponentAdapter(this.getComponentKey(), impl, null, true).getComponentInstance(container);
                if (this.myExtensionElement != null) {
                    try {
                        XmlSerializer.deserializeInto((Object)componentInstance, (Element)this.myExtensionElement);
                    }
                    catch (Exception e) {
                        throw new PicoInitializationException((Throwable)e);
                    }
                }
                this.myComponentInstance = componentInstance;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                PluginId pluginId = this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginId() : null;
                throw new PicoPluginExtensionInitializationException(t.getMessage(), t, pluginId);
            }
            if (this.myComponentInstance instanceof PluginAware) {
                PluginAware pluginAware = (PluginAware)this.myComponentInstance;
                pluginAware.setPluginDescriptor(this.myPluginDescriptor);
            }
        }
        return this.myComponentInstance;
    }

    public void verify(PicoContainer container) throws PicoIntrospectionException {
        throw new UnsupportedOperationException("Method verify is not supported in " + this.getClass());
    }

    public void accept(PicoVisitor visitor) {
        throw new UnsupportedOperationException("Method accept is not supported in " + this.getClass());
    }

    public Object getExtension() {
        return this.getComponentInstance(this.myContainer);
    }

    @Override
    public LoadingOrder getOrder() {
        return this.myOrder;
    }

    @Override
    public final String getOrderId() {
        return this.myOrderId;
    }

    public PluginId getPluginName() {
        return this.myPluginDescriptor.getPluginId();
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @NotNull
    private Class loadImplementationClass() {
        Class<?> implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            try {
                ClassLoader classLoader;
                ClassLoader classLoader2 = classLoader = this.myPluginDescriptor == null ? this.getClass().getClassLoader() : this.myPluginDescriptor.getPluginClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.myImplementationClassOrName = implementationClassOrName = Class.forName((String)((Object)implementationClassOrName), false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Class clazz = implementationClassOrName;
        if (clazz == null) {
            ExtensionComponentAdapter.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    @Override
    public String getAssignableToClassName() {
        Object implementationClassOrName = this.myImplementationClassOrName;
        if (implementationClassOrName instanceof String) {
            return (String)implementationClassOrName;
        }
        return ((Class)implementationClassOrName).getName();
    }

    boolean isNotificationSent() {
        return this.myNotificationSent;
    }

    void setNotificationSent(boolean notificationSent) {
        this.myNotificationSent = notificationSent;
    }

    public String toString() {
        return "ExtensionComponentAdapter[" + this.getAssignableToClassName() + "]: plugin=" + this.myPluginDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionComponentAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionComponentAdapter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadImplementationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

