/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach.osHandlers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.osHandlers.AttachOSHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;

public abstract class UnixAttachOSHandler
extends AttachOSHandler {
    private static final String PTRACE_SCOPE_PATH = "/proc/sys/kernel/yama/ptrace_scope";
    private static final String GET_PROCESS_USER = "ps -a -x -o user,pid | grep %d | awk '{print $1}'";
    private static final Logger LOGGER = Logger.getInstance(UnixAttachOSHandler.class);

    public UnixAttachOSHandler(@NotNull EnvironmentAwareHost host, @NotNull AttachOSHandler.OSType osType) {
        if (host == null) {
            UnixAttachOSHandler.$$$reportNull$$$0(0);
        }
        if (osType == null) {
            UnixAttachOSHandler.$$$reportNull$$$0(1);
        }
        super(host, osType);
    }

    public int getUid() {
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine(Arrays.asList("id", "-u"));
            String uid = this.myHost.getProcessOutput(commandLine).getStdout().trim();
            try {
                return Integer.valueOf(uid);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Error while parsing user id from " + uid, (Throwable)e);
                return -1;
            }
        }
        catch (ExecutionException ex) {
            LOGGER.warn("Error while getting user id", (Throwable)ex);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPtraceScope() {
        try {
            InputStream fileStream = this.myHost.getFileContent(PTRACE_SCOPE_PATH);
            if (fileStream == null) return 1;
            if (!this.myHost.canReadFile(PTRACE_SCOPE_PATH)) {
                LOGGER.warn("/proc/sys/kernel/yama/ptrace_scope file exists but you don't have permissions to read it.");
                return 3;
            }
            BufferedReader buf = new BufferedReader(new InputStreamReader(fileStream));
            String fileContent = buf.readLine();
            try (Scanner scanner = new Scanner(fileContent);){
                int n = scanner.nextInt();
                return n;
            }
            catch (Exception ex) {
                LOGGER.warn("Could not read security level from /proc/sys/kernel/yama/ptrace_scope", (Throwable)ex);
                return 3;
            }
        }
        catch (ExecutionException | IOException e) {
            LOGGER.warn("Error while uploading file:/proc/sys/kernel/yama/ptrace_scope", e);
            return 1;
        }
    }

    public boolean isOurProcess(int pid) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/sh");
        commands.add("-c");
        commands.add(String.format(GET_PROCESS_USER, pid));
        try {
            return this.myHost.getProcessOutput(new GeneralCommandLine(commands)).getStdout().trim().equals(this.getenv("USER"));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to compare users", (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "host";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "osType";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/attach/osHandlers/UnixAttachOSHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

