/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaReportingEvent
extends IdeaLoggingEvent {
    private final String myStacktrace;
    private final Throwable myThrowable;
    private final IdeaPluginDescriptor myPlugin;

    public IdeaReportingEvent(@NotNull AbstractMessage messageObject, String message, @NotNull String stacktrace, IdeaPluginDescriptor plugin) {
        if (messageObject == null) {
            IdeaReportingEvent.$$$reportNull$$$0(0);
        }
        if (stacktrace == null) {
            IdeaReportingEvent.$$$reportNull$$$0(1);
        }
        super(message, null, (Object)messageObject);
        this.myStacktrace = stacktrace;
        this.myThrowable = new TextBasedThrowable(stacktrace);
        this.myPlugin = plugin;
    }

    @Nullable
    public String getOriginalMessage() {
        return this.getData().getMessage();
    }

    @NotNull
    public String getOriginalThrowableText() {
        String string = this.getData().getThrowableText();
        if (string == null) {
            IdeaReportingEvent.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public IdeaPluginDescriptor getPlugin() {
        return this.myPlugin;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public String getThrowableText() {
        return this.myStacktrace;
    }

    @NotNull
    public AbstractMessage getData() {
        AbstractMessage abstractMessage = (AbstractMessage)super.getData();
        if (abstractMessage == null) {
            IdeaReportingEvent.$$$reportNull$$$0(3);
        }
        return abstractMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/IdeaReportingEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/IdeaReportingEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalThrowableText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TextBasedThrowable
    extends Throwable {
        private final String myStacktrace;

        TextBasedThrowable(String stacktrace) {
            this.myStacktrace = stacktrace;
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            s.print(this.myStacktrace);
        }

        @Override
        public void printStackTrace(PrintStream s) {
            s.print(this.myStacktrace);
        }
    }
}

