/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterConfigFileUtil {
    @Nullable
    public static VirtualFile findFile(@NotNull Project project, @NotNull VirtualFile initialDir, @NotNull String basename) {
        if (project == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(0);
        }
        if (initialDir == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(1);
        }
        if (basename == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(2);
        }
        return (VirtualFile)ReadAction.compute(() -> {
            if (project == null) {
                JSLinterConfigFileUtil.$$$reportNull$$$0(33);
            }
            if (initialDir == null) {
                JSLinterConfigFileUtil.$$$reportNull$$$0(34);
            }
            if (basename == null) {
                JSLinterConfigFileUtil.$$$reportNull$$$0(35);
            }
            if (project.isDisposed()) {
                return null;
            }
            for (VirtualFile dir = initialDir; dir != null; dir = dir.getParent()) {
                VirtualFile file2 = dir.findChild(basename);
                if (file2 == null || !file2.isValid() || file2.isDirectory() || ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file2, false) == null) continue;
                return file2;
            }
            return null;
        });
    }

    @Nullable
    public static VirtualFile lookupFileByName(@NotNull VirtualFile initialDir, @NotNull String basename) {
        if (initialDir == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(3);
        }
        if (basename == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(4);
        }
        return JSLinterConfigFileUtil.lookupFileByName(initialDir, new String[]{basename});
    }

    @Nullable
    public static VirtualFile lookupFileByName(@NotNull VirtualFile initialDir, @NotNull String[] fileNames) {
        if (initialDir == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(5);
        }
        if (fileNames == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(6);
        }
        return JSLinterConfigFileUtil.lookupFileByName(initialDir, fileNames, null);
    }

    @Nullable
    public static VirtualFile lookupFileByName(@NotNull VirtualFile initialDir, @NotNull String[] fileNames, @Nullable VirtualFile stopAt) {
        if (initialDir == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(7);
        }
        if (fileNames == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(8);
        }
        for (VirtualFile dir = initialDir; dir != null; dir = dir.getParent()) {
            for (String name : fileNames) {
                VirtualFile file2 = dir.findChild(name);
                if (file2 == null || !file2.isValid() || file2.isDirectory()) continue;
                return file2;
            }
            if (!dir.equals(stopAt)) continue;
            return null;
        }
        return null;
    }

    @NotNull
    public static String loadActualText(@NotNull VirtualFile file2) throws IOException {
        Document document;
        if (file2 == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(9);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file2)) != null) {
            String string = document.getText();
            if (string == null) {
                JSLinterConfigFileUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = VfsUtilCore.loadText((VirtualFile)file2);
        if (string == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static VirtualFile findLocalFileByPath(@NotNull String path) {
        if (path == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    @Nullable
    public static JsonProperty getProperty(@NotNull PsiElement position) {
        JsonObject objectLiteralExpression;
        JsonProperty property;
        if (position == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(13);
        }
        if ((property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)position, JsonProperty.class, (boolean)false)) != null && (objectLiteralExpression = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            return property;
        }
        return null;
    }

    @Nullable
    public static PsiElement getFirstChildAsStringLiteral(@NotNull JsonProperty property) {
        PsiElement firstElement;
        if (property == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(14);
        }
        if ((firstElement = property.getFirstChild()) != null && JSLinterConfigFileUtil.isStringLiteral(firstElement)) {
            return firstElement;
        }
        return null;
    }

    public static boolean isStringLiteral(@NotNull PsiElement element) {
        if (element == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(15);
        }
        return element instanceof JsonStringLiteral;
    }

    public static boolean isArray(@NotNull PsiElement element) {
        if (element == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(16);
        }
        return element instanceof JsonArray;
    }

    public static void skipOtherCompletionContributors(CompletionParameters parameters, CompletionResultSet result2) {
        result2.runRemainingContributors(parameters, result1 -> {}, true);
    }

    public static boolean projectHasConfigFiles(@NotNull Project project, @NotNull FileType type) {
        if (project == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(17);
        }
        if (type == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(18);
        }
        return FileTypeIndex.containsFileOfType((FileType)type, (GlobalSearchScope)JSLibraryUtil.getContentScopeWithoutLibraries(project));
    }

    @Nullable
    public static VirtualFile findDistinctConfigInContentRoots(@NotNull Project project, @NotNull Collection<String> names) {
        if (project == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(19);
        }
        if (names == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(20);
        }
        return JSLinterConfigFileUtil.findDistinctConfigInContentRoots(project, names, (Condition<? super VirtualFile>)Conditions.alwaysTrue());
    }

    @Nullable
    public static VirtualFile findDistinctConfigInContentRoots(@NotNull Project project, @NotNull Collection<String> names, @NotNull Condition<? super VirtualFile> filter) {
        if (project == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(21);
        }
        if (names == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(22);
        }
        if (filter == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(23);
        }
        VirtualFile[] stopDirs = ProjectRootManager.getInstance((Project)project).getContentRoots();
        List configs = ContainerUtil.newSmartList();
        for (VirtualFile dir : stopDirs) {
            configs.addAll(names.stream().map(el -> dir.findChild(el)).filter(el -> {
                if (filter == null) {
                    JSLinterConfigFileUtil.$$$reportNull$$$0(32);
                }
                return el != null && filter.value(el);
            }).collect(Collectors.toList()));
        }
        return configs.size() == 1 ? (VirtualFile)ContainerUtil.getFirstItem((List)configs) : null;
    }

    @NotNull
    public static List<VirtualFile> findAllConfigs(@NotNull Project project, @NotNull String[] filenames) {
        if (project == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(24);
        }
        if (filenames == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(25);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        JSLinterConfigFileUtil.configFilesSearch(project, (Processor<VirtualFile>)((Processor)file2 -> {
            result2.add(file2);
            return true;
        }), filenames);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    public static boolean hasConfigFiles(@NotNull Project project, @NotNull String[] filenames) {
        if (project == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(27);
        }
        if (filenames == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(28);
        }
        Ref ref = new Ref((Object)false);
        JSLinterConfigFileUtil.configFilesSearch(project, (Processor<VirtualFile>)((Processor)file2 -> {
            ref.set((Object)true);
            return false;
        }), filenames);
        return Boolean.TRUE.equals(ref.get());
    }

    private static void configFilesSearch(@NotNull Project project, @NotNull Processor<VirtualFile> processor, String[] filenames) {
        if (project == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            JSLinterConfigFileUtil.$$$reportNull$$$0(30);
        }
        GlobalSearchScope scope = JSLibraryUtil.getContentScopeWithoutLibraries(project);
        for (String name : filenames) {
            FilenameIndex.processFilesByName((String)name, (boolean)false, file2 -> {
                if (processor == null) {
                    JSLinterConfigFileUtil.$$$reportNull$$$0(31);
                }
                return file2.isValid() && !file2.isDirectory() && processor.process((Object)file2.getVirtualFile());
            }, (GlobalSearchScope)scope, (Project)project, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialDir";
                break;
            }
            case 2: 
            case 4: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basename";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filenames";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterConfigFileUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadActualText";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lookupFileByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadActualText";
                break;
            }
            case 10: 
            case 11: 
            case 26: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findLocalFileByPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildAsStringLiteral";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isArray";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "projectHasConfigFiles";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findDistinctConfigInContentRoots";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigs";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFiles";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "configFilesSearch";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configFilesSearch$6";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDistinctConfigInContentRoots$3";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

