/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSVariableStubBaseImpl<T extends JSVariable>
extends JSQualifiedObjectStubBase<T>
implements JSVariableStubBase<T> {
    private static final BooleanStructureElement IS_CONST_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_BLOCK_SCOPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement TYPE_STRICT_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INITIALIZER_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_OWN_INITIALIZER_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_INITIALIZER_TEXT_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement KEEPS_INITIALIZER_STUB_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, IS_CONST_FLAG, HAS_BLOCK_SCOPE_FLAG, TYPE_STRICT_FLAG, HAS_INITIALIZER_FLAG, HAS_OWN_INITIALIZER_FLAG, HAS_INITIALIZER_TEXT_FLAG, KEEPS_INITIALIZER_STUB_FLAG, HAS_TYPE_FLAG);
    private final StringRef myTypeString;
    private final StringRef myInitializerText;

    public JSVariableStubBaseImpl(T var, StubElement parent, @NotNull JSStubElementType<?, T> elementType) {
        if (elementType == null) {
            JSVariableStubBaseImpl.$$$reportNull$$$0(0);
        }
        super(var, parent, elementType);
        JSType type = var.getType();
        this.myTypeString = this.getTypeTextToSerialize(var, type);
        this.writeFlag(TYPE_STRICT_FLAG, type != null && type.getSource().isStrict());
        this.myInitializerText = StringRef.fromString((String)var.getLiteralOrReferenceInitializerText());
        this.writeFlag(IS_CONST_FLAG, var.isConst());
        this.writeFlag(HAS_BLOCK_SCOPE_FLAG, var.hasBlockScope());
        this.writeFlag(HAS_INITIALIZER_FLAG, var.hasInitializer());
        this.writeFlag(HAS_OWN_INITIALIZER_FLAG, var.hasOwnInitializer());
        this.writeFlag(KEEPS_INITIALIZER_STUB_FLAG, JSStubIndexingUtils.keepsInitializerStub(var));
        this.writeFlag(HAS_INITIALIZER_TEXT_FLAG, this.myInitializerText != null);
        this.writeFlag(HAS_TYPE_FLAG, this.myTypeString != null);
    }

    @Nullable
    public StringRef getTypeTextToSerialize(T var, JSType type) {
        return JSStubIndexingUtils.needSerializeType(type, var.getTypeElement()) ? StringRef.fromString((String)JSTypeUtils.serializeType(type)) : null;
    }

    public JSVariableStubBaseImpl(StubInputStream dataStream, StubElement parentStub, @NotNull IStubElementType elementType) throws IOException {
        if (elementType == null) {
            JSVariableStubBaseImpl.$$$reportNull$$$0(1);
        }
        super(dataStream, parentStub, elementType);
        this.myTypeString = this.readFlag(HAS_TYPE_FLAG) != false ? dataStream.readName() : null;
        this.myInitializerText = this.readFlag(HAS_INITIALIZER_TEXT_FLAG) != false ? dataStream.readName() : null;
    }

    public JSVariableStubBaseImpl(String name, boolean isConst, String type, String initial, String qName, StubElement parentStub, @NotNull JSContext jsContext, @NotNull JSAttributeList.AccessType accessType, @NotNull IStubElementType elementType) {
        if (jsContext == null) {
            JSVariableStubBaseImpl.$$$reportNull$$$0(2);
        }
        if (accessType == null) {
            JSVariableStubBaseImpl.$$$reportNull$$$0(3);
        }
        if (elementType == null) {
            JSVariableStubBaseImpl.$$$reportNull$$$0(4);
        }
        super(name, qName, parentStub, jsContext, accessType, elementType);
        this.myTypeString = StringRef.fromString((String)type);
        this.myInitializerText = StringRef.fromString((String)initial);
        this.writeFlag(IS_CONST_FLAG, isConst);
        this.writeFlag(HAS_BLOCK_SCOPE_FLAG, false);
        this.writeFlag(HAS_INITIALIZER_FLAG, this.myInitializerText != null);
        this.writeFlag(TYPE_STRICT_FLAG, false);
        this.writeFlag(HAS_INITIALIZER_TEXT_FLAG, this.myInitializerText != null);
        this.writeFlag(HAS_TYPE_FLAG, this.myTypeString != null);
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            JSVariableStubBaseImpl.writeString(this.myTypeString, dataStream);
        }
        if (this.readFlag(HAS_INITIALIZER_TEXT_FLAG).booleanValue()) {
            JSVariableStubBaseImpl.writeString(this.myInitializerText, dataStream);
        }
    }

    public String getTypeString() {
        return this.myTypeString != null ? this.myTypeString.getString() : null;
    }

    public boolean isTypeStrict() {
        return this.readFlag(TYPE_STRICT_FLAG);
    }

    public boolean isConst() {
        return this.readFlag(IS_CONST_FLAG);
    }

    public boolean hasInitializer() {
        return this.readFlag(HAS_INITIALIZER_FLAG);
    }

    public boolean hasOwnInitializer() {
        return this.readFlag(HAS_OWN_INITIALIZER_FLAG);
    }

    public boolean keepsInitializerStub() {
        return this.readFlag(KEEPS_INITIALIZER_STUB_FLAG);
    }

    public String getLiteralOrReferenceInitializerText() {
        return this.myInitializerText != null ? this.myInitializerText.getString() : null;
    }

    public boolean hasBlockScope() {
        return this.readFlag(HAS_BLOCK_SCOPE_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSVariableStubBaseImpl.$$$reportNull$$$0(5);
        }
        return flagsStructure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSVariableStubBaseImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSVariableStubBaseImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

