/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SingletonSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentIntObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.EmptyIterable;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.IntKeyWeakValueHashMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.ObjectIntMap;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakHashSet;
import com.intellij.util.containers.WeakKeyIntValueHashMap;
import com.intellij.util.containers.WeakKeySoftValueHashMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    private static final int INSERTION_SORT_THRESHOLD = 10;

    @NotNull
    @Contract(pure=true)
    public static <T> T[] ar(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(1);
        }
        return elements;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = ContainerUtilRt.newHashMap();
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(3);
        }
        HashMap<? extends K, ? extends V> hashMap = ContainerUtilRt.newHashMap(map);
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(5);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(6);
        }
        Map<? extends K, ? extends V> map = ContainerUtilRt.newHashMap(first, entries);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newHashMap(@NotNull List<? extends K> keys, @NotNull List<? extends V> values) {
        if (keys == null) {
            ContainerUtil.$$$reportNull$$$0(8);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(9);
        }
        Map<? extends K, ? extends V> map = ContainerUtilRt.newHashMap(keys, values);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = ContainerUtilRt.newTreeMap();
        if (treeMap == null) {
            ContainerUtil.$$$reportNull$$$0(11);
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(12);
        }
        TreeMap<? extends K, ? extends V> treeMap = ContainerUtilRt.newTreeMap(map);
        if (treeMap == null) {
            ContainerUtil.$$$reportNull$$$0(13);
        }
        return treeMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap();
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int capacity) {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap(capacity);
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(15);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(16);
        }
        LinkedHashMap<? extends K, ? extends V> linkedHashMap = ContainerUtilRt.newLinkedHashMap(map);
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(@NotNull Pair<? extends K, ? extends V> first, Pair<? extends K, ? extends V> ... entries) {
        if (first == null) {
            ContainerUtil.$$$reportNull$$$0(18);
        }
        if (entries == null) {
            ContainerUtil.$$$reportNull$$$0(19);
        }
        LinkedHashMap<? extends K, ? extends V> linkedHashMap = ContainerUtilRt.newLinkedHashMap(first, entries);
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(20);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(21);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        THashMap tHashMap = new THashMap(strategy);
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(@NotNull Class<K> keyType) {
        if (keyType == null) {
            ContainerUtil.$$$reportNull$$$0(24);
        }
        EnumMap enumMap = new EnumMap(keyType);
        if (enumMap == null) {
            ContainerUtil.$$$reportNull$$$0(25);
        }
        return enumMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(26);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(27);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        if (identityHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(28);
        }
        return identityHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = ContainerUtilRt.newLinkedList();
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(29);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(30);
        }
        LinkedList<T> linkedList = ContainerUtilRt.newLinkedList(elements);
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(31);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(32);
        }
        LinkedList<? extends T> linkedList = ContainerUtilRt.newLinkedList(elements);
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(33);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(35);
        }
        ArrayList<E> arrayList = ContainerUtilRt.newArrayList(array);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithCapacity(size);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(40);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        AbstractList abstractList = new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newUnmodifiableList(List<? extends T> originalList) {
        int size = originalList.size();
        if (size == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(42);
            }
            return list;
        }
        if (size == 1) {
            List<T> list = Collections.singletonList(originalList.get(0));
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(43);
            }
            return list;
        }
        List<? extends T> list = Collections.unmodifiableList(ContainerUtil.newArrayList(originalList));
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> unmodifiableOrEmptyCollection(@NotNull Collection<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(45);
        }
        if ((size = original.size()) == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(46);
            }
            return list;
        }
        if (size == 1) {
            List<T> list = Collections.singletonList(original.iterator().next());
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(47);
            }
            return list;
        }
        Collection<? extends T> collection = Collections.unmodifiableCollection(original);
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(48);
        }
        return collection;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> unmodifiableOrEmptyList(@NotNull List<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(49);
        }
        if ((size = original.size()) == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(50);
            }
            return list;
        }
        if (size == 1) {
            List<T> list = Collections.singletonList(original.iterator().next());
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(51);
            }
            return list;
        }
        List<? extends T> list = Collections.unmodifiableList(original);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> unmodifiableOrEmptySet(@NotNull Set<? extends T> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(53);
        }
        if ((size = original.size()) == 0) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(54);
            }
            return set;
        }
        if (size == 1) {
            Set<T> set = Collections.singleton(original.iterator().next());
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(55);
            }
            return set;
        }
        Set<? extends T> set = Collections.unmodifiableSet(original);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(56);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> unmodifiableOrEmptyMap(@NotNull Map<? extends K, ? extends V> original) {
        int size;
        if (original == null) {
            ContainerUtil.$$$reportNull$$$0(57);
        }
        if ((size = original.size()) == 0) {
            Map map = Collections.emptyMap();
            if (map == null) {
                ContainerUtil.$$$reportNull$$$0(58);
            }
            return map;
        }
        if (size == 1) {
            Map.Entry<K, V> entry = original.entrySet().iterator().next();
            Map<K, V> map = Collections.singletonMap(entry.getKey(), entry.getValue());
            if (map == null) {
                ContainerUtil.$$$reportNull$$$0(59);
            }
            return map;
        }
        Map<? extends K, ? extends V> map = Collections.unmodifiableMap(original);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(60);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(61);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T element) {
        SmartList<T> smartList = new SmartList<T>(element);
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(62);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(63);
        }
        SmartList<T> smartList = new SmartList<T>(elements);
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(64);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = ContainerUtilRt.newHashSet();
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        HashSet hashSet = ContainerUtilRt.newHashSet(initialCapacity);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(66);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        HashSet<T> hashSet = ContainerUtilRt.newHashSet(elements);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(69);
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterable);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(70);
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(71);
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterator);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(72);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        Set<Object> set = empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = ContainerUtilRt.newLinkedHashSet();
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(74);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(75);
        }
        LinkedHashSet<? extends T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(76);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(77);
        }
        LinkedHashSet<T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(78);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        THashSet tHashSet = new THashSet(strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(81);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(82);
        }
        THashSet<T> tHashSet = ContainerUtil.newTroveSet(Arrays.asList(elements));
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(83);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(84);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(85);
        }
        THashSet tHashSet = new THashSet(Arrays.asList(elements), strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(86);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, @NotNull Collection<? extends T> elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(87);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(88);
        }
        THashSet tHashSet = new THashSet(elements, strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(89);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(90);
        }
        THashSet tHashSet = new THashSet(elements);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(91);
        }
        return tHashSet;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(int initialCapacity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet(@NotNull Collection<? extends K> collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet() {
        TreeSet treeSet = ContainerUtilRt.newTreeSet();
        if (treeSet == null) {
            ContainerUtil.$$$reportNull$$$0(97);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(98);
        }
        TreeSet<? extends T> treeSet = ContainerUtilRt.newTreeSet(elements);
        if (treeSet == null) {
            ContainerUtil.$$$reportNull$$$0(99);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(100);
        }
        TreeSet<T> treeSet = ContainerUtilRt.newTreeSet(elements);
        if (treeSet == null) {
            ContainerUtil.$$$reportNull$$$0(101);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TreeSet<T> newTreeSet(@Nullable Comparator<? super T> comparator) {
        TreeSet<? super T> treeSet = ContainerUtilRt.newTreeSet(comparator);
        if (treeSet == null) {
            ContainerUtil.$$$reportNull$$$0(102);
        }
        return treeSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        Set set = Collections.newSetFromMap(ContainerUtil.newConcurrentMap());
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        if (concurrentHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        return concurrentHashMap;
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        if (elements.isEmpty()) {
            List list = ContainerUtilRt.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(106);
            }
            return list;
        }
        AbstractList abstractList = new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(107);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> union(@NotNull Map<? extends K, ? extends V> map, @NotNull Map<? extends K, ? extends V> map2) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(108);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(109);
        }
        THashMap result = new THashMap(map.size() + map2.size());
        result.putAll(map);
        result.putAll(map2);
        THashMap tHashMap = result;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(110);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Set<? extends T> set, @NotNull Set<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(111);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(112);
        }
        Set<? extends T> set3 = ContainerUtil.union(set, set2);
        if (set3 == null) {
            ContainerUtil.$$$reportNull$$$0(113);
        }
        return set3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> union(@NotNull Collection<? extends T> set, @NotNull Collection<? extends T> set2) {
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(114);
        }
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(115);
        }
        THashSet result = new THashSet(set.size() + set2.size());
        result.addAll(set);
        result.addAll(set2);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(116);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(117);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(118);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(119);
                }
                return set;
            }
        }
        Set set = Collections.unmodifiableSet(new THashSet(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(120);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(121);
        }
        ImmutableListBackedByArray immutableListBackedByArray = new ImmutableListBackedByArray(array);
        if (immutableListBackedByArray == null) {
            ContainerUtil.$$$reportNull$$$0(122);
        }
        return immutableListBackedByArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableSingletonList(E element) {
        ImmutableList<E> immutableList = ImmutableList.singleton(element);
        if (immutableList == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        return immutableList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(@NotNull List<? extends E> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(124);
        }
        ImmutableListBackedByList immutableListBackedByList = new ImmutableListBackedByList(list);
        if (immutableListBackedByList == null) {
            ContainerUtil.$$$reportNull$$$0(125);
        }
        return immutableListBackedByList;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        ImmutableMapBuilder immutableMapBuilder = new ImmutableMapBuilder();
        if (immutableMapBuilder == null) {
            ContainerUtil.$$$reportNull$$$0(126);
        }
        return immutableMapBuilder;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> MultiMap<K, V> groupBy(@NotNull Iterable<? extends V> collection, @NotNull NullableFunction<? super V, ? extends K> grouper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(127);
        }
        if (grouper == null) {
            ContainerUtil.$$$reportNull$$$0(128);
        }
        MultiMap<K, V> result = MultiMap.createLinked();
        for (V data : collection) {
            K key = grouper.fun(data);
            if (key == null) continue;
            result.putValue(key, data);
        }
        if (!result.isEmpty() && result.keySet().iterator().next() instanceof Comparable) {
            KeyOrderedMultiMap keyOrderedMultiMap = new KeyOrderedMultiMap(result);
            if (keyOrderedMultiMap == null) {
                ContainerUtil.$$$reportNull$$$0(129);
            }
            return keyOrderedMultiMap;
        }
        MultiMap<K, V> multiMap = result;
        if (multiMap == null) {
            ContainerUtil.$$$reportNull$$$0(130);
        }
        return multiMap;
    }

    @Contract(pure=true)
    public static <T> T getOrElse(@NotNull List<? extends T> elements, int i, T defaultValue) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(131);
        }
        return elements.size() > i ? elements.get(i) : defaultValue;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> intersection(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(132);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(133);
        }
        HashMap res = ContainerUtil.newHashMap();
        HashSet<K> keys = ContainerUtil.newHashSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 != (v2 = map2.get(k)) && (v1 == null || !v1.equals(v2))) continue;
            res.put(k, v1);
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(134);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, Couple<V>> diff(@NotNull Map<? extends K, ? extends V> map1, @NotNull Map<? extends K, ? extends V> map2) {
        if (map1 == null) {
            ContainerUtil.$$$reportNull$$$0(135);
        }
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(136);
        }
        HashMap res = ContainerUtil.newHashMap();
        HashSet<K> keys = ContainerUtil.newHashSet();
        keys.addAll(map1.keySet());
        keys.addAll(map2.keySet());
        for (Object k : keys) {
            V v2;
            V v1 = map1.get(k);
            if (v1 == (v2 = map2.get(k)) || v1 != null && v1.equals(v2)) continue;
            res.put(k, Couple.of(v1, v2));
        }
        HashMap hashMap = res;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(137);
        }
        return hashMap;
    }

    public static <T> void processSortedListsInOrder(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems, @NotNull Consumer<? super T> processor) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(138);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(139);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(140);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(141);
        }
        int index1 = 0;
        int index2 = 0;
        while (index1 < list1.size() || index2 < list2.size()) {
            T e;
            if (index1 >= list1.size()) {
                e = list2.get(index2++);
            } else if (index2 >= list2.size()) {
                e = list1.get(index1++);
            } else {
                T element2;
                T element1 = list1.get(index1);
                int c = comparator.compare(element1, element2 = list2.get(index2));
                if (c == 0) {
                    ++index1;
                    ++index2;
                    if (mergeEqualItems) {
                        e = element1;
                    } else {
                        processor.consume(element1);
                        e = element2;
                    }
                } else if (c < 0) {
                    e = element1;
                    ++index1;
                } else {
                    e = element2;
                    ++index2;
                }
            }
            processor.consume(e);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> mergeSortedLists(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator, boolean mergeEqualItems) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(142);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(143);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(144);
        }
        final ArrayList result = new ArrayList(list1.size() + list2.size());
        ContainerUtil.processSortedListsInOrder(list1, list2, comparator, mergeEqualItems, new Consumer<T>(){

            @Override
            public void consume(T t) {
                result.add(t);
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(145);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> subList(@NotNull List<T> list, int from) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(146);
        }
        List<T> list2 = list.subList(from, list.size());
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(147);
        }
        return list2;
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(148);
        }
        if (appendix == null) {
            ContainerUtil.$$$reportNull$$$0(149);
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(150);
        }
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(151);
        }
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(152);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(153);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(154);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(155);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(156);
        }
        if (!iterator.hasNext()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(157);
            }
            return list;
        }
        ArrayList list = new ArrayList();
        ContainerUtil.addAll(list, iterator);
        ArrayList arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(158);
        }
        return arrayList;
    }

    @NotNull
    public static <T> Set<T> collectSet(@NotNull Iterator<? extends T> iterator) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(159);
        }
        if (!iterator.hasNext()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(160);
            }
            return set;
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet();
        ContainerUtil.addAll(hashSet, iterator);
        HashSet<T> hashSet2 = hashSet;
        if (hashSet2 == null) {
            ContainerUtil.$$$reportNull$$$0(161);
        }
        return hashSet2;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newMapFromKeys(@NotNull Iterator<? extends K> keys, @NotNull Convertor<? super K, ? extends V> valueConvertor) {
        if (keys == null) {
            ContainerUtil.$$$reportNull$$$0(162);
        }
        if (valueConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(163);
        }
        HashMap<K, V> map = ContainerUtil.newHashMap();
        while (keys.hasNext()) {
            K key = keys.next();
            map.put(key, valueConvertor.convert(key));
        }
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(164);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> newMapFromValues(@NotNull Iterator<? extends V> values, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(165);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(166);
        }
        HashMap<K, V> map = ContainerUtil.newHashMap();
        ContainerUtil.fillMapWithValues(map, values, keyConvertor);
        HashMap<K, V> hashMap = map;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(167);
        }
        return hashMap;
    }

    public static <K, V> void fillMapWithValues(@NotNull Map<? super K, ? super V> map, @NotNull Iterator<? extends V> values, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(168);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(169);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(170);
        }
        while (values.hasNext()) {
            V value = values.next();
            map.put(keyConvertor.convert(value), value);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, Set<V>> classify(@NotNull Iterator<? extends V> iterator, @NotNull Convertor<? super V, ? extends K> keyConvertor) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(171);
        }
        if (keyConvertor == null) {
            ContainerUtil.$$$reportNull$$$0(172);
        }
        LinkedHashMap<K, LinkedHashSet<V>> hashMap = new LinkedHashMap<K, LinkedHashSet<V>>();
        while (iterator.hasNext()) {
            V value = iterator.next();
            K key = keyConvertor.convert(value);
            LinkedHashSet<V> set = (LinkedHashSet<V>)hashMap.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                hashMap.put(key, set);
            }
            set.add(value);
        }
        LinkedHashMap<K, LinkedHashSet<V>> linkedHashMap = hashMap;
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(173);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> emptyIterator() {
        EmptyIterator emptyIterator = EmptyIterator.getInstance();
        if (emptyIterator == null) {
            ContainerUtil.$$$reportNull$$$0(174);
        }
        return emptyIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> emptyIterable() {
        EmptyIterable emptyIterable = EmptyIterable.getInstance();
        if (emptyIterable == null) {
            ContainerUtil.$$$reportNull$$$0(175);
        }
        return emptyIterable;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(179);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list, @NotNull Processor<? super T> processor) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(180);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(181);
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T t = list.get(i);
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(183);
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull Iterator<? extends T> iterator, @NotNull Processor<? super T> processor) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(184);
        }
        if (processor == null) {
            ContainerUtil.$$$reportNull$$$0(185);
        }
        while (iterator.hasNext()) {
            if (processor.process(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<? extends V> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        return ContainerUtilRt.find(iterable, condition);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, final @NotNull T equalTo) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(188);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(189);
        }
        return (T)ContainerUtil.find(iterable, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull Iterator<? extends T> iterator, final @NotNull T equalTo) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(190);
        }
        if (equalTo == null) {
            ContainerUtil.$$$reportNull$$$0(191);
        }
        return ContainerUtil.find(iterator, new Condition<T>(){

            @Override
            public boolean value(T object) {
                return equalTo == object || equalTo.equals(object);
            }
        });
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<? extends V> iterator, @NotNull Condition<? super T> condition) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(192);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(193);
        }
        return ContainerUtilRt.find(iterator, condition);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V findLast(@NotNull List<? extends V> list, @NotNull Condition<? super T> condition) {
        int index;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(194);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(195);
        }
        if ((index = ContainerUtil.lastIndexOf(list, condition)) < 0) {
            return null;
        }
        return list.get(index);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2Map(@NotNull T[] collection, @NotNull Function<? super T, ? extends Pair<K, V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(196);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(197);
        }
        Map<K, V> map = ContainerUtil.map2Map(Arrays.asList(collection), mapper);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(198);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2Map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<K, V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(199);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(200);
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<K, V> pair = mapper.fun(t);
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(201);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull T[] collection, @NotNull Function<? super T, ? extends Pair<K, V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(202);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(203);
        }
        Map<K, V> map = ContainerUtil.map2MapNotNull(Arrays.asList(collection), mapper);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(204);
        }
        return map;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, K, V> Map<K, V> map2MapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends Pair<K, V>> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(205);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(206);
        }
        THashMap set = new THashMap(collection.size());
        for (T t : collection) {
            Pair<K, V> pair = mapper.fun(t);
            if (pair == null) continue;
            set.put(pair.first, pair.second);
        }
        THashMap tHashMap = set;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(207);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> map2Map(@NotNull Collection<? extends Pair<K, V>> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(208);
        }
        THashMap result = new THashMap(collection.size());
        for (Pair<K, V> pair : collection) {
            result.put(pair.first, pair.second);
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(209);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Object[] map2Array(@NotNull T[] array, @NotNull Function<? super T, Object> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(210);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(211);
        }
        Object[] objectArray = ContainerUtil.map2Array(array, Object.class, mapper);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(212);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Object[] map2Array(@NotNull Collection<? extends T> array, @NotNull Function<? super T, Object> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(213);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(214);
        }
        Object[] objectArray = ContainerUtil.map2Array(array, Object.class, mapper);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(215);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? super V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(218);
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? super V> aClass, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(220);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(221);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(222);
        }
        List<V> list = ContainerUtil.map2List(collection, mapper);
        Object[] array = (Object[])Array.newInstance(aClass, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(223);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull V[] to, @NotNull Function<? super T, V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(224);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(225);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(226);
        }
        V[] VArray = ContainerUtil.map2List(collection, mapper).toArray(to);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(227);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(228);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] filter(@NotNull int[] collection, @NotNull TIntProcedure condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(231);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(232);
        }
        TIntArrayList result = new TIntArrayList();
        for (int t : collection) {
            if (!condition.execute(t)) continue;
            result.add(t);
        }
        int[] nArray = result.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : result.toNativeArray();
        if (nArray == null) {
            ContainerUtil.$$$reportNull$$$0(233);
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(234);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(235);
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(236);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(237);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(238);
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> filter(@NotNull Map<? extends K, ? extends V> map, @NotNull Condition<? super K> keyFilter) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(240);
        }
        if (keyFilter == null) {
            ContainerUtil.$$$reportNull$$$0(241);
        }
        HashMap<K, V> result = ContainerUtil.newHashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!keyFilter.value(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> hashMap = result;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(242);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(243);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        if (collection.isEmpty()) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(245);
            }
            return list;
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(247);
        }
        List<Object> list = ContainerUtil.findAll(collection, Condition.NOT_NULL);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(248);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> findAll(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(249);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(250);
        }
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(251);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] findAllAsArray(@NotNull T[] collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(252);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(253);
        }
        List<V> list = ContainerUtil.findAll(Arrays.asList(collection), instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(254);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] findAllAsArray(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(255);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(256);
        }
        List<V> list = ContainerUtil.findAll(collection, instanceOf);
        Object[] array = (Object[])Array.newInstance(instanceOf, list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(257);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        List<Object> list;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        if ((list = ContainerUtil.findAll(collection, instanceOf)).size() == collection.length) {
            if (collection == null) {
                ContainerUtil.$$$reportNull$$$0(260);
            }
            return collection;
        }
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list.size());
        Object[] objectArray = list.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> findAll(@NotNull Collection<? extends T> collection, @NotNull Class<V> instanceOf) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(262);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(263);
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!instanceOf.isInstance(t)) continue;
            T v = t;
            result.add(v);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(264);
        }
        return smartList;
    }

    public static <T> boolean all(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(265);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(266);
        }
        for (T t : collection) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> void removeDuplicates(@NotNull Collection<T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(267);
        }
        HashSet<T> collected = ContainerUtil.newHashSet();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!collected.contains(t)) {
                collected.add(t);
                continue;
            }
            iterator.remove();
        }
    }

    @NotNull
    @Contract(pure=true)
    public static Map<String, String> stringMap(String ... keyValues) {
        if (keyValues == null) {
            ContainerUtil.$$$reportNull$$$0(268);
        }
        HashMap<String, String> result = ContainerUtil.newHashMap();
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            result.put(keyValues[i], keyValues[i + 1]);
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(269);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> iterate(@NotNull T[] array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(270);
        }
        Iterator iterator = array.length == 0 ? EmptyIterator.getInstance() : Arrays.asList(array).iterator();
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(271);
        }
        return iterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> iterate(final @NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(272);
        }
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(273);
        }
        return iterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        if (arrays == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        Iterable<? super T> iterable = ContainerUtil.iterate(Arrays.asList(arrays), condition);
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        if (collection.isEmpty()) {
            Iterable<T> iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(279);
            }
            return iterable;
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = new Iterator<T>(){
                    private final Iterator<? extends T> impl;
                    private T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result = this.next;
                        this.next = this.findNext();
                        return result;
                    }

                    @Nullable
                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    7.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$7", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterateBackward(final @NotNull List<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(281);
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator = new Iterator<T>(){
                    private final ListIterator<? extends T> it;
                    {
                        this.it = list.listIterator(list.size());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasPrevious();
                    }

                    @Override
                    public T next() {
                        return this.it.previous();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
                if (iterator == null) {
                    8.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$8", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(282);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, E> Iterable<Pair<T, E>> zip(final @NotNull Iterable<? extends T> iterable1, final @NotNull Iterable<? extends E> iterable2) {
        if (iterable1 == null) {
            ContainerUtil.$$$reportNull$$$0(283);
        }
        if (iterable2 == null) {
            ContainerUtil.$$$reportNull$$$0(284);
        }
        Iterable iterable = new Iterable<Pair<T, E>>(){

            @Override
            @NotNull
            public Iterator<Pair<T, E>> iterator() {
                Iterator iterator = new Iterator<Pair<T, E>>(){
                    private final Iterator<? extends T> i1;
                    private final Iterator<? extends E> i2;
                    {
                        this.i1 = iterable1.iterator();
                        this.i2 = iterable2.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i1.hasNext() && this.i2.hasNext();
                    }

                    @Override
                    public Pair<T, E> next() {
                        return Pair.create(this.i1.next(), this.i2.next());
                    }

                    @Override
                    public void remove() {
                        this.i1.remove();
                        this.i2.remove();
                    }
                };
                if (iterator == null) {
                    9.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$9", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(285);
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list, int index1, int index2) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<?> iterator, @NotNull FilteringIterator.InstanceOf<T> instanceOf) {
        List list;
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(287);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(288);
        }
        List list2 = list = ContainerUtil.collect(FilteringIterator.create(iterator, instanceOf));
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(289);
        }
        return list2;
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Enumeration<? extends T> enumeration) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(290);
        }
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(291);
        }
        while (enumeration.hasMoreElements()) {
            T element = enumeration.nextElement();
            collection.add(element);
        }
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(292);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(293);
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(294);
        }
        return c;
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, A ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(295);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(296);
        }
        for (A element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(297);
        }
        return c;
    }

    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(298);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(299);
        }
        boolean modified = false;
        for (T element : elements) {
            modified |= collection.remove(element);
        }
        return modified;
    }

    public static <T> boolean retainAll(@NotNull Collection<T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(300);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(301);
        }
        boolean modified = false;
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (condition.value(next)) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator, @NotNull Class<? extends U> aClass) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(304);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(305);
        }
        return (U)ContainerUtil.find(iterator, FilteringIterator.instanceOf(aClass));
    }

    @Nullable
    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull T[] array, @NotNull Class<? extends U> aClass) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(306);
        }
        if (aClass == null) {
            ContainerUtil.$$$reportNull$$$0(307);
        }
        return ContainerUtil.findInstance(Arrays.asList(array), aClass);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<? super V, ? extends Collection<? extends T>> fun) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(309);
        }
        List<T> list = ContainerUtil.concat(Arrays.asList(array), fun);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(310);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(@NotNull Iterable<? extends Collection<? extends T>> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(311);
        }
        ArrayList result = new ArrayList();
        for (Collection<T> collection : list) {
            result.addAll(collection);
        }
        List list2 = result.isEmpty() ? Collections.emptyList() : result;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(312);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> append(@NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(313);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(314);
        }
        List<? extends T> list2 = ContainerUtil.concat(list, ContainerUtil.list(values));
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(315);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> prepend(@NotNull List<? extends T> list, T ... values) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(316);
        }
        if (values == null) {
            ContainerUtil.$$$reportNull$$$0(317);
        }
        List<? extends T> list2 = ContainerUtil.concat(ContainerUtil.list(values), list);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(318);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(319);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(320);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(321);
            }
            return list;
        }
        if (list1.isEmpty()) {
            List<T> list = list2;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(322);
            }
            return list;
        }
        if (list2.isEmpty()) {
            List<T> list = list1;
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(323);
            }
            return list;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(324);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(325);
        }
        if (iterables.length == 0) {
            Iterable<T> iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(326);
            }
            return iterable;
        }
        if (iterables.length == 1) {
            Iterable<? extends T> iterable = iterables[0];
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(327);
            }
            return iterable;
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i = 0; i < iterables.length; ++i) {
                    Iterable iterable = iterables[i];
                    iterators[i] = iterable.iterator();
                }
                Iterator iterator = ContainerUtil.concatIterators(iterators);
                if (iterator == null) {
                    11.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$11", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(328);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(Iterator<T> ... iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(329);
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(iterators);
        if (sequenceIterator == null) {
            ContainerUtil.$$$reportNull$$$0(330);
        }
        return sequenceIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> concatIterators(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        if (iterators == null) {
            ContainerUtil.$$$reportNull$$$0(331);
        }
        SequenceIterator sequenceIterator = new SequenceIterator(iterators);
        if (sequenceIterator == null) {
            ContainerUtil.$$$reportNull$$$0(332);
        }
        return sequenceIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> concat(final T[] ... iterables) {
        if (iterables == null) {
            ContainerUtil.$$$reportNull$$$0(333);
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator i;
                Iterator[] iterators = new Iterator[iterables.length];
                for (int i2 = 0; i2 < iterables.length; ++i2) {
                    Object[] iterable = iterables[i2];
                    iterators[i2] = ContainerUtil.iterate(iterable);
                }
                Iterator iterator = i = ContainerUtil.concatIterators(iterators);
                if (iterator == null) {
                    12.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ContainerUtil$12", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(334);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final List<? extends T> ... lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(335);
        }
        int size = 0;
        for (List<T> list : lists) {
            size += list.size();
        }
        if (size == 0) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(336);
            }
            return list;
        }
        final int finalSize = size;
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index >= 0 && index < finalSize) {
                    int from = 0;
                    for (List each : lists) {
                        if (from <= index && index < from + each.size()) {
                            return each.get(index - from);
                        }
                        from += each.size();
                    }
                    if (from != finalSize) {
                        throw new ConcurrentModificationException("The list has changed. Its size was " + finalSize + "; now it's " + from);
                    }
                }
                throw new IndexOutOfBoundsException("index: " + index + "; size: " + this.size());
            }

            @Override
            public int size() {
                return finalSize;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(337);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(@NotNull List<List<? extends T>> lists) {
        if (lists == null) {
            ContainerUtil.$$$reportNull$$$0(338);
        }
        List[] array = lists.toArray(new List[0]);
        List<T> list = ContainerUtil.concat(array);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(339);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull Iterable<? extends V> list, @NotNull Function<? super V, ? extends Collection<? extends T>> listGenerator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(340);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (V v : list) {
            result.addAll(listGenerator.fun(v));
        }
        List<T> list2 = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(342);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(343);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(345);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(346);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result.add(t);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(347);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <E extends Enum<E>> EnumSet<E> intersection(@NotNull EnumSet<E> collection1, @NotNull EnumSet<E> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(348);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(349);
        }
        EnumSet<E> result = EnumSet.copyOf(collection1);
        result.retainAll(collection2);
        EnumSet<E> enumSet = result;
        if (enumSet == null) {
            ContainerUtil.$$$reportNull$$$0(350);
        }
        return enumSet;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getOnlyItem(items, null);
    }

    @Contract(pure=true)
    public static <T> T getOnlyItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.size() != 1 ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> getFirstItems(@NotNull List<T> items, int maxItems) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(351);
        }
        List<T> list = items.subList(0, Math.min(maxItems, items.size()));
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(352);
        }
        return list;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T iterateAndGetLastItem(@NotNull Iterable<? extends T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(353);
        }
        Iterator<T> itr = items.iterator();
        T res = null;
        while (itr.hasNext()) {
            res = itr.next();
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator, final @NotNull Function<? super T, ? extends U> mapper) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(354);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        Iterator iterator2 = new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        return iterator2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> filterIterator(final @NotNull Iterator<? extends T> iterator, final @NotNull Condition<? super T> filter) {
        if (iterator == null) {
            ContainerUtil.$$$reportNull$$$0(357);
        }
        if (filter == null) {
            ContainerUtil.$$$reportNull$$$0(358);
        }
        Iterator iterator2 = new Iterator<T>(){
            T next;
            boolean hasNext;
            {
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            private void findNext() {
                this.hasNext = false;
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    if (!filter.value(t)) continue;
                    this.next = t;
                    this.hasNext = true;
                    break;
                }
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.findNext();
                return result;
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(359);
        }
        return iterator2;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list, @Nullable T def) {
        return ContainerUtilRt.getLastItem(list, def);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, L extends List<T>> T getLastItem(@Nullable L list) {
        return ContainerUtilRt.getLastItem(list);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> subtract(@NotNull Collection<? extends T> from, @NotNull Collection<? extends T> what) {
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(360);
        }
        if (what == null) {
            ContainerUtil.$$$reportNull$$$0(361);
        }
        HashSet<T> set = ContainerUtil.newHashSet(from);
        set.removeAll(what);
        Collection<T> collection = set.isEmpty() ? ContainerUtil.emptyList() : set;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(362);
        }
        return collection;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        T[] TArray = c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(365);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(366);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(367);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(368);
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeCollectionsToArray(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<? extends T> factory) {
        if (c1 == null) {
            ContainerUtil.$$$reportNull$$$0(369);
        }
        if (c2 == null) {
            ContainerUtil.$$$reportNull$$$0(370);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(371);
        }
        T[] TArray = ArrayUtil.mergeCollections(c1, c2, factory);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(372);
        }
        return TArray;
    }

    public static <T extends Comparable<T>> void sort(@NotNull List<T> list) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(373);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            Comparable t1;
            Comparable t0 = (Comparable)list.get(0);
            if (t0.compareTo(t1 = (Comparable)list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    Comparable tj;
                    Comparable ti = (Comparable)list.get(i);
                    if (ti.compareTo(tj = (Comparable)list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list);
        }
    }

    public static <T> void sort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(374);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(375);
        }
        if ((size = list.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list.get(0);
            if (comparator.compare(t0, t1 = list.get(1)) > 0) {
                list.set(0, t1);
                list.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list.get(i);
                    if (comparator.compare(ti, tj = list.get(j)) >= 0) continue;
                    list.set(i, tj);
                    list.set(j, ti);
                }
            }
        } else {
            Collections.sort(list, comparator);
        }
    }

    public static <T extends Comparable<T>> void sort(@NotNull T[] a) {
        int size;
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(376);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (t0.compareTo(t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (ti.compareTo(tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Collection<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(377);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(378);
        }
        List<? super T> list2 = ContainerUtil.sorted(list, comparator);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(379);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> sorted(@NotNull Iterable<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(380);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(381);
        }
        ArrayList<? extends T> sorted = ContainerUtil.newArrayList(list);
        ContainerUtil.sort(sorted, comparator);
        ArrayList<? extends T> arrayList = sorted;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(382);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T extends Comparable<? super T>> List<T> sorted(@NotNull Collection<? extends T> list) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(383);
        }
        List<? extends T> list2 = ContainerUtil.sorted(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        });
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(384);
        }
        return list2;
    }

    public static <T> void sort(@NotNull T[] a, @NotNull Comparator<? super T> comparator) {
        int size;
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(385);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(386);
        }
        if ((size = a.length) < 2) {
            return;
        }
        if (size == 2) {
            T t0 = a[0];
            T t1 = a[1];
            if (comparator.compare(t0, t1) > 0) {
                a[0] = t1;
                a[1] = t0;
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T ti = a[i];
                    T tj = a[j];
                    if (comparator.compare(ti, tj) >= 0) continue;
                    a[i] = tj;
                    a[j] = ti;
                }
            }
        } else {
            Arrays.sort(a, comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(387);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(388);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        List<? extends V> list = ContainerUtilRt.map2List(collection, mapping);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(392);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(393);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(394);
        }
        List<? extends V> list = ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(395);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] mapNotNull(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping, @NotNull V[] emptyArray) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(396);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(397);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(398);
        }
        ArrayList<V> result = new ArrayList<V>(array.length);
        for (T t : array) {
            V v = mapping.fun(t);
            if (v == null) continue;
            result.add(v);
        }
        if (result.isEmpty()) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(399);
            }
            return emptyArray;
        }
        V[] VArray = result.toArray(emptyArray);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(400);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(401);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(402);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(403);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(404);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(405);
        }
        List<? extends V> list = ContainerUtilRt.mapNotNull(collection, mapping);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(406);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> packNullables(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(407);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T element : elements) {
            ContainerUtil.addIfNotNull(list, element);
        }
        List<T> list2 = list.isEmpty() ? ContainerUtil.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(408);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(409);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(410);
        }
        ArrayList<T> result = new ArrayList<T>(array.length);
        for (T t : array) {
            result.add(mapping.fun(t));
        }
        List<T> list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(411);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map(@NotNull T[] arr, @NotNull Function<? super T, ? extends V> mapping, @NotNull V[] emptyArray) {
        if (arr == null) {
            ContainerUtil.$$$reportNull$$$0(412);
        }
        if (mapping == null) {
            ContainerUtil.$$$reportNull$$$0(413);
        }
        if (emptyArray == null) {
            ContainerUtil.$$$reportNull$$$0(414);
        }
        if (arr.length == 0) {
            assert (emptyArray.length == 0) : "You must pass an empty array";
            if (emptyArray == null) {
                ContainerUtil.$$$reportNull$$$0(415);
            }
            return emptyArray;
        }
        V[] result = emptyArray.length < arr.length ? Arrays.copyOf(emptyArray, arr.length) : emptyArray;
        for (int i = 0; i < arr.length; ++i) {
            result[i] = mapping.fun(arr[i]);
        }
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(416);
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet(items);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        return hashSet;
    }

    public static <K, V> void putIfAbsent(K key, @Nullable V value, @NotNull Map<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(419);
        }
        if (!result.containsKey(key)) {
            result.put(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull Map<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(420);
        }
        if (value != null) {
            result.put(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable Collection<? extends V> value, @NotNull MultiMap<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(421);
        }
        if (value != null) {
            result.putValues(key, value);
        }
    }

    public static <K, V> void putIfNotNull(K key, @Nullable V value, @NotNull MultiMap<? super K, ? super V> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(422);
        }
        if (value != null) {
            result.putValue(key, value);
        }
    }

    public static <T> void add(final T element, final @NotNull Collection<? super T> result, @NotNull Disposable parentDisposable) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(423);
        }
        if (parentDisposable == null) {
            ContainerUtil.$$$reportNull$$$0(424);
        }
        if (result.add(element)) {
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    result.remove(element);
                }
            });
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(425);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> createMaybeSingletonSet(@Nullable T element) {
        Set set = element == null ? Collections.emptySet() : Collections.singleton(element);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(426);
        }
        return set;
    }

    @NotNull
    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull V defaultValue) {
        V value;
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(427);
        }
        if (defaultValue == null) {
            ContainerUtil.$$$reportNull$$$0(428);
        }
        if ((value = result.get(key)) == null) {
            value = defaultValue;
            result.put(key, value);
        }
        V v = value;
        if (v == null) {
            ContainerUtil.$$$reportNull$$$0(429);
        }
        return v;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull Factory<? extends V> factory) {
        V value;
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(430);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(431);
        }
        if ((value = result.get(key)) == null) {
            value = factory.create();
            result.put(key, value);
        }
        return value;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V getOrElse(@NotNull Map<T, V> result, T key, @NotNull V defValue) {
        V value;
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(432);
        }
        if (defValue == null) {
            ContainerUtil.$$$reportNull$$$0(433);
        }
        V v = (value = result.get(key)) == null ? defValue : value;
        if (v == null) {
            ContainerUtil.$$$reportNull$$$0(434);
        }
        return v;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(435);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(436);
        }
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(438);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(439);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(441);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(442);
        }
        return ContainerUtil.or(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(443);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(444);
        }
        return ContainerUtil.exists(iterable, condition);
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(445);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(446);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int count(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(447);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(448);
        }
        int count = 0;
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> unfold(@Nullable T t, @NotNull NullableFunction<? super T, ? extends T> next) {
        if (next == null) {
            ContainerUtil.$$$reportNull$$$0(449);
        }
        if (t == null) {
            List<T> list = ContainerUtil.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(450);
            }
            return list;
        }
        ArrayList<T> list = new ArrayList<T>();
        while (t != null) {
            list.add(t);
            t = next.fun(t);
        }
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(451);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> dropTail(@NotNull List<T> items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(452);
        }
        List<T> list = items.subList(0, items.size() - 1);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(453);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> list(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(454);
        }
        List<T> list = Arrays.asList(items);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(455);
        }
        return list;
    }

    public static <T> void quickSort(@NotNull List<? extends T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(456);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(457);
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(458);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(459);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(460);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> singleton(T o, @NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(461);
        }
        Set<T> set = strategy == TObjectHashingStrategy.CANONICAL ? new SingletonSet<T>(o) : SingletonSet.withCustomStrategy(o, strategy);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(462);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Collection<E>[] collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(463);
        }
        List<E> list = ContainerUtil.flatten(Arrays.asList(collections));
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(464);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> removeDuplicatesFromSorted(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(465);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(466);
        }
        Object prev = null;
        ArrayList<T> result = null;
        for (int i = 0; i < list.size(); ++i) {
            int cmp;
            T t = list.get(i);
            if (t == null) {
                throw new IllegalArgumentException("get(" + i + ") = null");
            }
            int n = cmp = prev == null ? -1 : comparator.compare(prev, t);
            if (cmp < 0) {
                if (result != null) {
                    result.add(t);
                }
            } else if (cmp == 0) {
                if (result == null) {
                    result = new ArrayList<T>(list.size());
                    result.addAll(list.subList(0, i));
                }
            } else {
                throw new IllegalArgumentException("List must be sorted but get(" + (i - 1) + ")=" + list.get(i - 1) + " > get(" + i + ")=" + t);
            }
            prev = t;
        }
        List<T> list2 = result == null ? list : result;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(467);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(468);
        }
        ArrayList result = new ArrayList();
        for (Collection<E> collection : collections) {
            result.addAll(collection);
        }
        List list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(469);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flattenIterables(@NotNull Iterable<? extends Iterable<E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(470);
        }
        ArrayList result = new ArrayList();
        for (Iterable<E> list : collections) {
            for (E e : list) {
                result.add(e);
            }
        }
        List list = result.isEmpty() ? ContainerUtil.emptyList() : result;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(471);
        }
        return list;
    }

    @NotNull
    public static <K, V> V[] convert(@NotNull K[] from, @NotNull V[] to, @NotNull Function<? super K, ? extends V> fun) {
        if (from == null) {
            ContainerUtil.$$$reportNull$$$0(472);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(473);
        }
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(474);
        }
        if (to.length < from.length) {
            Object[] array = (Object[])Array.newInstance(to.getClass().getComponentType(), from.length);
            to = array;
        }
        for (int i = 0; i < from.length; ++i) {
            to[i] = fun.fun(from[i]);
        }
        if (to == null) {
            ContainerUtil.$$$reportNull$$$0(475);
        }
        return to;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<? extends T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(476);
        }
        for (T t : list) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> int indexOfIdentity(@NotNull List<? extends T> list, T element) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(477);
        }
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            if (list.get(i) != element) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> boolean equalsIdentity(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(478);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(479);
        }
        int listSize = list1.size();
        if (list2.size() != listSize) {
            return false;
        }
        for (int i = 0; i < listSize; ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(480);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(481);
        }
        return ContainerUtilRt.indexOf(list, condition);
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(482);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(483);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            T t = list.get(i);
            if (!condition.value(t)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, U extends T> U findLastInstance(@NotNull List<? extends T> list, final @NotNull Class<? extends U> clazz) {
        int i;
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(484);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(485);
        }
        return (i = ContainerUtil.lastIndexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        })) < 0 ? null : (U)list.get(i);
    }

    @Contract(pure=true)
    public static <T, U extends T> int lastIndexOfInstance(@NotNull List<? extends T> list, final @NotNull Class<U> clazz) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(486);
        }
        if (clazz == null) {
            ContainerUtil.$$$reportNull$$$0(487);
        }
        return ContainerUtil.lastIndexOf(list, new Condition<T>(){

            @Override
            public boolean value(T t) {
                return clazz.isInstance(t);
            }
        });
    }

    @NotNull
    @Contract(pure=true)
    public static <A, B> Map<B, A> reverseMap(@NotNull Map<A, B> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(488);
        }
        HashMap<B, A> result = ContainerUtil.newHashMap();
        for (Map.Entry<A, B> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        HashMap<B, A> hashMap = result;
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(489);
        }
        return hashMap;
    }

    @Contract(value="null -> null; !null -> !null")
    public static <T> List<T> trimToSize(@Nullable List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = ContainerUtilRt.newStack();
        if (stack == null) {
            ContainerUtil.$$$reportNull$$$0(490);
        }
        return stack;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> Stack<T> newStack(@NotNull Collection<? extends T> initial) {
        if (initial == null) {
            ContainerUtil.$$$reportNull$$$0(491);
        }
        Stack<? extends T> stack = ContainerUtilRt.newStack(initial);
        if (stack == null) {
            ContainerUtil.$$$reportNull$$$0(492);
        }
        return stack;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> Stack<T> newStack(T ... initial) {
        if (initial == null) {
            ContainerUtil.$$$reportNull$$$0(493);
        }
        Stack<T> stack = ContainerUtilRt.newStack(initial);
        if (stack == null) {
            ContainerUtil.$$$reportNull$$$0(494);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(495);
        }
        return list;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList(ContainerUtilRt.emptyList());
        if (copyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(496);
        }
        return copyOnWriteArrayList;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        ConcurrentList<T> concurrentList = ContainerUtil.createConcurrentList();
        if (concurrentList == null) {
            ContainerUtil.$$$reportNull$$$0(497);
        }
        return concurrentList;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList(@NotNull Collection<? extends T> c) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(498);
        }
        LockFreeCopyOnWriteArrayList<? extends T> lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList<T>(c);
        if (lockFreeCopyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(499);
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap();
        if (concurrentIntObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(500);
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(value="_,_,_ -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap(initialCapacity, loadFactor, concurrencyLevel);
        if (concurrentIntObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(501);
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectSoftValueMap() {
        ConcurrentIntKeySoftValueHashMap concurrentIntKeySoftValueHashMap = new ConcurrentIntKeySoftValueHashMap();
        if (concurrentIntKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(502);
        }
        return concurrentIntKeySoftValueHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap();
        if (concurrentLongObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(503);
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap(int initialCapacity) {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap(initialCapacity);
        if (concurrentLongObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(504);
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        ConcurrentWeakValueHashMap concurrentWeakValueHashMap = new ConcurrentWeakValueHashMap();
        if (concurrentWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(505);
        }
        return concurrentWeakValueHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        ConcurrentIntKeyWeakValueHashMap concurrentIntKeyWeakValueHashMap = new ConcurrentIntKeyWeakValueHashMap();
        if (concurrentIntKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(506);
        }
        return concurrentIntKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(507);
        }
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(508);
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(509);
        }
        ConcurrentSoftKeySoftValueHashMap concurrentSoftKeySoftValueHashMap = new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentSoftKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(510);
        }
        return concurrentSoftKeySoftValueHashMap;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(513);
        }
        ConcurrentWeakKeyWeakValueHashMap concurrentWeakKeyWeakValueHashMap = new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
        if (concurrentWeakKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(514);
        }
        return concurrentWeakKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentSoftValueHashMap concurrentSoftValueHashMap = new ConcurrentSoftValueHashMap();
        if (concurrentSoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(515);
        }
        return concurrentSoftValueHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        ConcurrentSoftHashMap concurrentSoftHashMap = new ConcurrentSoftHashMap();
        if (concurrentSoftHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(516);
        }
        return concurrentSoftHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap(0.75f);
        if (concurrentWeakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(517);
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(518);
        }
        ConcurrentSoftHashMap concurrentSoftHashMap = new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentSoftHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(519);
        }
        return concurrentSoftHashMap;
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(520);
        }
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(521);
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(@NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(522);
        }
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap(hashingStrategy);
        if (concurrentWeakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(523);
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(524);
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ConcurrentList<T> createConcurrentList(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(525);
        }
        LockFreeCopyOnWriteArrayList<? extends T> lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList<T>(collection);
        if (lockFreeCopyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(526);
        }
        return lockFreeCopyOnWriteArrayList;
    }

    @Deprecated
    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<? super T> result) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(527);
        }
        ContainerUtil.addIfNotNull(result, element);
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result, @Nullable T element) {
        if (result == null) {
            ContainerUtil.$$$reportNull$$$0(528);
        }
        ContainerUtilRt.addIfNotNull(result, element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(529);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(530);
        }
        List<? extends V> list = ContainerUtilRt.map2List(array, mapper);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(531);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(532);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(533);
        }
        List<? extends V> list = ContainerUtilRt.map2List(collection, mapper);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(534);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> List<Pair<K, V>> map2List(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(535);
        }
        List<Pair<K, V>> list = ContainerUtilRt.map2List(map);
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(536);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(537);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(538);
        }
        Set<? extends V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(539);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(540);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(541);
        }
        Set<? extends V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(542);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2LinkedSet(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(543);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(544);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(545);
            }
            return set;
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(collection.size());
        for (T t : collection) {
            set.add(mapper.fun(t));
        }
        LinkedHashSet<V> linkedHashSet = set;
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(546);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(547);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(548);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(549);
            }
            return set;
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value = mapper.fun(t);
            if (value == null) continue;
            set.add(value);
        }
        Set set2 = set.isEmpty() ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(550);
        }
        return set2;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull List<T> collection, @NotNull T[] array) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(551);
        }
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(552);
        }
        T[] TArray = collection.toArray(array);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(553);
        }
        return TArray;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@NotNull Collection<? extends T> c, @NotNull T[] sample) {
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(554);
        }
        if (sample == null) {
            ContainerUtil.$$$reportNull$$$0(555);
        }
        T[] TArray = c.toArray(sample);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(556);
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory, boolean clear) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(557);
        }
        if (factory == null) {
            ContainerUtil.$$$reportNull$$$0(558);
        }
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(559);
        }
        return a;
    }

    @Contract(value="null -> null")
    public static <T> List<T> copyList(@Nullable List<? extends T> list) {
        if (list == null) {
            return null;
        }
        if (list == Collections.emptyList()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return new SmartList<T>(list.get(0));
        }
        if (list.isEmpty()) {
            return new SmartList();
        }
        return new ArrayList<T>(list);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> toCollection(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(560);
        }
        ArrayList<? extends T> arrayList = iterable instanceof Collection ? (ArrayList<? extends T>)iterable : ContainerUtil.newArrayList(iterable);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(561);
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> toList(@NotNull Enumeration<? extends T> enumeration) {
        if (enumeration == null) {
            ContainerUtil.$$$reportNull$$$0(562);
        }
        if (!enumeration.hasMoreElements()) {
            List list = Collections.emptyList();
            if (list == null) {
                ContainerUtil.$$$reportNull$$$0(563);
            }
            return list;
        }
        SmartList<T> result = new SmartList<T>();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(564);
        }
        return smartList;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return ContainerUtilRt.isEmpty(collection);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable Map map) {
        return map == null || map.isEmpty();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> notNullize(@Nullable List<T> list) {
        List list2 = list == null ? ContainerUtilRt.emptyList() : list;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(565);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(566);
        }
        return set2;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> Map<K, V> notNullize(@Nullable Map<K, V> map) {
        Map map2 = map == null ? Collections.emptyMap() : map;
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(567);
        }
        return map2;
    }

    @Contract(pure=true)
    public static <T> boolean startsWith(@NotNull List<? extends T> list, @NotNull List<? extends T> prefix) {
        if (list == null) {
            ContainerUtil.$$$reportNull$$$0(568);
        }
        if (prefix == null) {
            ContainerUtil.$$$reportNull$$$0(569);
        }
        return list.size() >= prefix.size() && list.subList(0, prefix.size()).equals(prefix);
    }

    @Nullable
    @Contract(pure=true)
    public static <T, C extends Collection<T>> C nullize(@Nullable C collection) {
        return ContainerUtil.isEmpty(collection) ? null : (C)collection;
    }

    @Contract(pure=true)
    public static <T extends Comparable<T>> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(570);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(571);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    @Contract(pure=true)
    public static <T> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2, @NotNull Comparator<? super T> comparator) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(572);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(573);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(574);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result = comparator.compare(o1.get(i), o2.get(i));
            if (result == 0) continue;
            return result;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String toString(@NotNull Map<?, ?> map) {
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(575);
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            sb.append(entry.getKey()).append('=').append(entry.getValue());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            ContainerUtil.$$$reportNull$$$0(576);
        }
        return string;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeySoftValueMap() {
        WeakKeySoftValueHashMap weakKeySoftValueHashMap = new WeakKeySoftValueHashMap();
        if (weakKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(577);
        }
        return weakKeySoftValueHashMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeyWeakValueMap() {
        WeakKeyWeakValueHashMap weakKeyWeakValueHashMap = new WeakKeyWeakValueHashMap(true);
        if (weakKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(578);
        }
        return weakKeyWeakValueHashMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftKeySoftValueMap() {
        SoftKeySoftValueHashMap softKeySoftValueHashMap = new SoftKeySoftValueHashMap(true);
        if (softKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(579);
        }
        return softKeySoftValueHashMap;
    }

    /*
     * Exception decompiling
     */
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakValueMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        SoftHashMap softHashMap = new SoftHashMap(4);
        if (softHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(582);
        }
        return softHashMap;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap(@NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(583);
        }
        SoftHashMap softHashMap = new SoftHashMap(strategy);
        if (softHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(584);
        }
        return softHashMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        Map<K, V> map = ContainerUtil.createWeakMap(4);
        if (map == null) {
            ContainerUtil.$$$reportNull$$$0(585);
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(587);
        }
        WeakHashMap weakHashMap = new WeakHashMap(initialCapacity, loadFactor, strategy);
        if (weakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(588);
        }
        return weakHashMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> Set<T> createWeakSet() {
        WeakHashSet weakHashSet = new WeakHashSet();
        if (weakHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(589);
        }
        return weakHashSet;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> IntObjectMap<T> createIntKeyWeakValueMap() {
        IntKeyWeakValueHashMap intKeyWeakValueHashMap = new IntKeyWeakValueHashMap();
        if (intKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(590);
        }
        return intKeyWeakValueHashMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T> ObjectIntMap<T> createWeakKeyIntValueMap() {
        WeakKeyIntValueHashMap weakKeyIntValueHashMap = new WeakKeyIntValueHashMap();
        if (weakKeyIntValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(591);
        }
        return weakKeyIntValueHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 3: 
            case 12: 
            case 16: 
            case 108: 
            case 168: 
            case 240: 
            case 488: 
            case 535: 
            case 575: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 8: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 9: 
            case 165: 
            case 169: 
            case 314: 
            case 317: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 22: 
            case 80: 
            case 84: 
            case 87: 
            case 461: 
            case 513: 
            case 583: 
            case 587: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 35: 
            case 121: 
            case 176: 
            case 210: 
            case 213: 
            case 216: 
            case 270: 
            case 306: 
            case 308: 
            case 393: 
            case 396: 
            case 409: 
            case 439: 
            case 529: 
            case 552: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 37: 
            case 69: 
            case 178: 
            case 182: 
            case 186: 
            case 188: 
            case 302: 
            case 387: 
            case 401: 
            case 435: 
            case 437: 
            case 441: 
            case 443: 
            case 445: 
            case 447: 
            case 560: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 45: 
            case 49: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 71: 
            case 151: 
            case 156: 
            case 159: 
            case 171: 
            case 184: 
            case 190: 
            case 192: 
            case 287: 
            case 304: 
            case 354: 
            case 357: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 94: 
            case 127: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 208: 
            case 220: 
            case 224: 
            case 228: 
            case 231: 
            case 234: 
            case 237: 
            case 243: 
            case 247: 
            case 249: 
            case 252: 
            case 255: 
            case 258: 
            case 262: 
            case 265: 
            case 267: 
            case 277: 
            case 290: 
            case 292: 
            case 295: 
            case 298: 
            case 300: 
            case 390: 
            case 404: 
            case 525: 
            case 532: 
            case 537: 
            case 540: 
            case 543: 
            case 547: 
            case 551: 
            case 557: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 109: 
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 111: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 124: 
            case 146: 
            case 180: 
            case 194: 
            case 281: 
            case 286: 
            case 311: 
            case 313: 
            case 316: 
            case 340: 
            case 373: 
            case 374: 
            case 377: 
            case 380: 
            case 383: 
            case 456: 
            case 465: 
            case 476: 
            case 477: 
            case 480: 
            case 482: 
            case 484: 
            case 486: 
            case 568: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 132: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 138: 
            case 142: 
            case 319: 
            case 478: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 139: 
            case 143: 
            case 320: 
            case 479: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 140: 
            case 144: 
            case 375: 
            case 378: 
            case 381: 
            case 386: 
            case 457: 
            case 459: 
            case 466: 
            case 574: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 141: 
            case 179: 
            case 181: 
            case 183: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 166: 
            case 170: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 177: 
            case 187: 
            case 193: 
            case 195: 
            case 229: 
            case 232: 
            case 235: 
            case 238: 
            case 244: 
            case 266: 
            case 275: 
            case 278: 
            case 301: 
            case 436: 
            case 438: 
            case 440: 
            case 442: 
            case 444: 
            case 446: 
            case 448: 
            case 481: 
            case 483: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 189: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 197: 
            case 200: 
            case 203: 
            case 206: 
            case 211: 
            case 214: 
            case 218: 
            case 222: 
            case 226: 
            case 355: 
            case 530: 
            case 533: 
            case 538: 
            case 541: 
            case 544: 
            case 548: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 217: 
            case 221: 
            case 303: 
            case 305: 
            case 307: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 225: 
            case 473: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 250: 
            case 253: 
            case 256: 
            case 259: 
            case 263: 
            case 288: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 272: 
            case 291: 
            case 562: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrays";
                break;
            }
            case 283: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 309: 
            case 474: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 325: 
            case 333: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 329: 
            case 331: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 335: 
            case 338: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 341: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 343: 
            case 345: 
            case 348: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 344: 
            case 346: 
            case 349: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 351: 
            case 353: 
            case 417: 
            case 452: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 358: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 360: 
            case 472: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 361: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 363: 
            case 367: 
            case 371: 
            case 431: 
            case 558: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 365: 
            case 369: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 366: 
            case 370: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 376: 
            case 385: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 388: 
            case 391: 
            case 394: 
            case 397: 
            case 402: 
            case 405: 
            case 410: 
            case 413: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 398: 
            case 414: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 412: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 419: 
            case 420: 
            case 421: 
            case 422: 
            case 423: 
            case 427: 
            case 430: 
            case 432: 
            case 527: 
            case 528: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 424: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 428: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 433: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 449: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 458: 
            case 460: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 463: 
            case 468: 
            case 470: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 485: 
            case 487: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 491: 
            case 493: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 498: 
            case 554: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 507: 
            case 509: 
            case 518: 
            case 520: 
            case 522: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 555: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 569: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 570: 
            case 572: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 571: 
            case 573: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeMap";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newTroveMap";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "newEnumMap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalStrategy";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "identityStrategy";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityHashMap";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayListWithCapacity";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 61: 
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "newSmartList";
                break;
            }
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 74: 
            case 76: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "newTroveSet";
                break;
            }
            case 92: 
            case 93: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityTroveSet";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityTroveMap";
                break;
            }
            case 97: 
            case 99: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeSet";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentMap";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "reverse";
                break;
            }
            case 110: 
            case 113: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 122: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableList";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableMapBuilder";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 134: 
            case 347: 
            case 350: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 157: 
            case 158: 
            case 289: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSet";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterator";
                break;
            }
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterable";
                break;
            }
            case 198: 
            case 201: 
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 204: 
            case 207: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 230: 
            case 233: 
            case 239: 
            case 242: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 236: 
            case 245: 
            case 246: 
            case 251: 
            case 264: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 248: {
                objectArray = objectArray2;
                objectArray2[1] = "skipNulls";
                break;
            }
            case 254: 
            case 257: 
            case 260: 
            case 261: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 269: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 282: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 285: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 294: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 297: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 310: 
            case 312: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 315: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 318: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 330: 
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "concatIterators";
                break;
            }
            case 352: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 356: {
                objectArray = objectArray2;
                objectArray2[1] = "mapIterator";
                break;
            }
            case 359: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIterator";
                break;
            }
            case 362: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 364: 
            case 368: 
            case 553: 
            case 556: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 372: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionsToArray";
                break;
            }
            case 379: 
            case 382: 
            case 384: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 389: 
            case 392: 
            case 411: 
            case 415: 
            case 416: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 418: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 425: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 426: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 429: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 434: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 450: 
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "unfold";
                break;
            }
            case 453: {
                objectArray = objectArray2;
                objectArray2[1] = "dropTail";
                break;
            }
            case 455: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 462: {
                objectArray = objectArray2;
                objectArray2[1] = "singleton";
                break;
            }
            case 464: 
            case 469: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 467: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 471: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIterables";
                break;
            }
            case 475: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 489: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 490: 
            case 492: 
            case 494: {
                objectArray = objectArray2;
                objectArray2[1] = "newStack";
                break;
            }
            case 495: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 496: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCOWList";
                break;
            }
            case 497: 
            case 499: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 500: 
            case 501: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectMap";
                break;
            }
            case 502: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectSoftValueMap";
                break;
            }
            case 503: 
            case 504: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentLongObjectMap";
                break;
            }
            case 505: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 506: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectWeakValueMap";
                break;
            }
            case 508: 
            case 511: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 510: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 512: 
            case 514: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 515: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 516: 
            case 519: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftMap";
                break;
            }
            case 517: 
            case 521: 
            case 523: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 524: 
            case 526: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentList";
                break;
            }
            case 531: 
            case 534: 
            case 536: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 539: 
            case 542: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 545: 
            case 546: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 549: 
            case 550: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 559: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 561: {
                objectArray = objectArray2;
                objectArray2[1] = "toCollection";
                break;
            }
            case 563: 
            case 564: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 565: 
            case 566: 
            case 567: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 576: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 577: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeySoftValueMap";
                break;
            }
            case 578: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyWeakValueMap";
                break;
            }
            case 579: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftKeySoftValueMap";
                break;
            }
            case 580: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftValueMap";
                break;
            }
            case 581: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakValueMap";
                break;
            }
            case 582: 
            case 584: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftMap";
                break;
            }
            case 585: 
            case 586: 
            case 588: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
            case 589: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakSet";
                break;
            }
            case 590: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntKeyWeakValueMap";
                break;
            }
            case 591: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyIntValueMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newTroveMap";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newEnumMap";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 35: 
            case 37: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "newSmartList";
                break;
            }
            case 67: 
            case 69: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 75: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 80: 
            case 82: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "newTroveSet";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "newIdentityTroveSet";
                break;
            }
            case 98: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "newTreeSet";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 121: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 131: 
            case 432: 
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 132: 
            case 133: 
            case 345: 
            case 346: 
            case 348: 
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 290: 
            case 291: 
            case 292: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 295: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 156: 
            case 287: 
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "collectSet";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 176: 
            case 177: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 202: 
            case 203: 
            case 205: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 210: 
            case 211: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 218: 
            case 220: 
            case 221: 
            case 222: 
            case 224: 
            case 225: 
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 228: 
            case 229: 
            case 231: 
            case 232: 
            case 237: 
            case 238: 
            case 240: 
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 234: 
            case 235: 
            case 243: 
            case 244: 
            case 249: 
            case 250: 
            case 262: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 252: 
            case 253: 
            case 255: 
            case 256: 
            case 258: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 265: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 270: 
            case 272: 
            case 274: 
            case 275: 
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 281: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 283: 
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 298: 
            case 299: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 300: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 308: 
            case 309: 
            case 311: 
            case 319: 
            case 320: 
            case 325: 
            case 333: 
            case 335: 
            case 338: 
            case 340: 
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 313: 
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 316: 
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 329: 
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 343: 
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 351: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 353: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 354: 
            case 355: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 357: 
            case 358: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 360: 
            case 361: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 363: 
            case 365: 
            case 366: 
            case 367: 
            case 551: 
            case 552: 
            case 554: 
            case 555: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 369: 
            case 370: 
            case 371: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionsToArray";
                break;
            }
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 385: 
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 377: 
            case 378: 
            case 380: 
            case 381: 
            case 383: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 387: 
            case 388: 
            case 390: 
            case 391: 
            case 409: 
            case 410: 
            case 412: 
            case 413: 
            case 414: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 393: 
            case 394: 
            case 396: 
            case 397: 
            case 398: 
            case 401: 
            case 402: 
            case 404: 
            case 405: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 417: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 420: 
            case 421: 
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 423: 
            case 424: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 427: 
            case 428: 
            case 430: 
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 435: 
            case 436: 
            case 437: 
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 439: 
            case 440: 
            case 441: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 443: 
            case 444: 
            case 445: 
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 447: 
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 449: {
                objectArray = objectArray;
                objectArray[2] = "unfold";
                break;
            }
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "dropTail";
                break;
            }
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 460: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 463: 
            case 468: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 465: 
            case 466: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 470: {
                objectArray = objectArray;
                objectArray[2] = "flattenIterables";
                break;
            }
            case 472: 
            case 473: 
            case 474: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 476: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 477: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 478: 
            case 479: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 480: 
            case 481: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 482: 
            case 483: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 484: 
            case 485: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 486: 
            case 487: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfInstance";
                break;
            }
            case 488: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 491: 
            case 493: {
                objectArray = objectArray;
                objectArray[2] = "newStack";
                break;
            }
            case 498: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 507: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 509: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 513: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 518: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftMap";
                break;
            }
            case 520: 
            case 522: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakMap";
                break;
            }
            case 525: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 527: 
            case 528: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 529: 
            case 530: 
            case 532: 
            case 533: 
            case 535: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 537: 
            case 538: 
            case 540: 
            case 541: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 543: 
            case 544: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 547: 
            case 548: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 557: 
            case 558: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 560: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 562: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 568: 
            case 569: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 575: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 583: {
                objectArray = objectArray;
                objectArray[2] = "createSoftMap";
                break;
            }
            case 587: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class KeyOrderedMultiMap<K, V>
    extends MultiMap<K, V> {
        public KeyOrderedMultiMap() {
        }

        public KeyOrderedMultiMap(@NotNull MultiMap<? extends K, ? extends V> toCopy) {
            if (toCopy == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(0);
            }
            super(toCopy);
        }

        @Override
        @NotNull
        protected Map<K, Collection<V>> createMap() {
            TreeMap treeMap = new TreeMap();
            if (treeMap == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(1);
            }
            return treeMap;
        }

        @Override
        @NotNull
        protected Map<K, Collection<V>> createMap(int initialCapacity, float loadFactor) {
            TreeMap treeMap = new TreeMap();
            if (treeMap == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(2);
            }
            return treeMap;
        }

        @NotNull
        public NavigableSet<K> navigableKeySet() {
            NavigableSet navigableSet = ((TreeMap)this.myMap).navigableKeySet();
            if (navigableSet == null) {
                KeyOrderedMultiMap.$$$reportNull$$$0(3);
            }
            return navigableSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toCopy";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ContainerUtil$KeyOrderedMultiMap";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMap";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "navigableKeySet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(@NotNull E[] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index) {
            return this.myStore[index];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray", "<init>"));
        }
    }

    private static class ImmutableListBackedByList<E>
    extends ImmutableList<E> {
        private final List<? extends E> myStore;

        private ImmutableListBackedByList(@NotNull List<? extends E> list) {
            if (list == null) {
                ImmutableListBackedByList.$$$reportNull$$$0(0);
            }
            this.myStore = list;
        }

        @Override
        public E get(int index) {
            return this.myStore.get(index);
        }

        @Override
        public int size() {
            return this.myStore.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/containers/ContainerUtil$ImmutableListBackedByList", "<init>"));
        }
    }

    public static class ImmutableMapBuilder<K, V> {
        private final Map<K, V> myMap = new THashMap();

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            this.myMap.put(key, value);
            return this;
        }

        @Contract(pure=true)
        public Map<K, V> build() {
            return Collections.unmodifiableMap(this.myMap);
        }
    }
}

