/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions;

import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public interface PopupCallback
extends Runnable {
    public PsiFile[] getAffectedFiles();

    public String getActionName();

    @Nullable
    public String getGroupName();

    public static class Adapter
    implements PopupCallback {
        private final Runnable myCallback;
        private final String myActionName;
        private final PsiFile[] myFiles;

        public Adapter(Runnable callback, String actionName) {
            this(callback, actionName, PsiFile.EMPTY_ARRAY);
        }

        public Adapter(Runnable callback, String actionName, PsiFile ... files) {
            this.myCallback = callback;
            this.myActionName = actionName;
            this.myFiles = files;
        }

        @Override
        public PsiFile[] getAffectedFiles() {
            return this.myFiles;
        }

        @Override
        public String getActionName() {
            return this.myActionName;
        }

        @Override
        public String getGroupName() {
            return null;
        }

        @Override
        public void run() {
            this.myCallback.run();
        }
    }
}

