/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.launch;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.launch.EquinoxFWClassLoader;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.launch.Framework;

public class Equinox
implements Framework {
    private static final String implName = "org.eclipse.osgi.framework.internal.core.EquinoxLauncher";
    private Framework impl;
    private final boolean useSeparateCL;
    private final Map configuration;
    static /* synthetic */ Class class$0;

    public Equinox(Map configuration) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        this.useSeparateCL = FrameworkProperties.inUse();
        this.configuration = configuration;
    }

    private Framework createImpl() {
        if (System.getSecurityManager() == null) {
            return this.createImpl0();
        }
        return (Framework)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Equinox.this.createImpl0();
            }
        });
    }

    Framework createImpl0() {
        try {
            Class implClazz = this.getImplClass();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor constructor = implClazz.getConstructor(classArray);
            return (Framework)constructor.newInstance(this.configuration);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(implName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Class getImplClass() throws ClassNotFoundException {
        ClassLoader thisCL = this.getClass().getClassLoader();
        if (!this.useSeparateCL || !(thisCL instanceof URLClassLoader)) {
            return Class.forName(implName);
        }
        URL[] cp = ((URLClassLoader)thisCL).getURLs();
        EquinoxFWClassLoader fwCL = new EquinoxFWClassLoader(cp, thisCL);
        return fwCL.loadClass(implName);
    }

    private synchronized Framework getImpl() {
        if (this.impl == null) {
            this.impl = this.createImpl();
        }
        return this.impl;
    }

    public void init() throws BundleException {
        this.getImpl().init();
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        return this.getImpl().waitForStop(timeout);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return this.getImpl().findEntries(path, filePattern, recurse);
    }

    public BundleContext getBundleContext() {
        return this.getImpl().getBundleContext();
    }

    public long getBundleId() {
        return this.getImpl().getBundleId();
    }

    public URL getEntry(String path) {
        return this.getImpl().getEntry(path);
    }

    public Enumeration getEntryPaths(String path) {
        return this.getImpl().getEntryPaths(path);
    }

    public Dictionary getHeaders() {
        return this.getImpl().getHeaders();
    }

    public Dictionary getHeaders(String locale) {
        return this.getImpl().getHeaders(locale);
    }

    public long getLastModified() {
        return this.getImpl().getLastModified();
    }

    public String getLocation() {
        return this.getImpl().getLocation();
    }

    public ServiceReference[] getRegisteredServices() {
        return this.getImpl().getRegisteredServices();
    }

    public URL getResource(String name) {
        return this.getImpl().getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return this.getImpl().getResources(name);
    }

    public ServiceReference[] getServicesInUse() {
        return this.getImpl().getServicesInUse();
    }

    public int getState() {
        return this.getImpl().getState();
    }

    public String getSymbolicName() {
        return this.getImpl().getSymbolicName();
    }

    public boolean hasPermission(Object permission) {
        return this.getImpl().hasPermission(permission);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.getImpl().loadClass(name);
    }

    public void start(int options) throws BundleException {
        this.getImpl().start(options);
    }

    public void start() throws BundleException {
        this.getImpl().start();
    }

    public void stop(int options) throws BundleException {
        this.getImpl().stop(options);
    }

    public void stop() throws BundleException {
        this.getImpl().stop();
    }

    public void uninstall() throws BundleException {
        this.getImpl().uninstall();
    }

    public void update() throws BundleException {
        this.getImpl().update();
    }

    public void update(InputStream in) throws BundleException {
        this.getImpl().update(in);
    }

    public Map getSignerCertificates(int signersType) {
        return this.getImpl().getSignerCertificates(signersType);
    }

    public Version getVersion() {
        return this.getImpl().getVersion();
    }
}

