/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

class VsnetUtils {
    static final Color DARK_GREEN = new Color(0, 128, 0);
    static final Color DARK_MAGENTA = new Color(128, 0, 128);
    private static double RATIO1 = 0.8;
    private static double RATIO2 = 0.92f;
    private static double RATIO3 = 0.86f;

    VsnetUtils() {
    }

    static Color getLighterColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, 0.93f);
    }

    static Color getMenuSelectionColor(Color color) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, 0.8555f);
    }

    static Color getMenuBackgroundColor(Color color) {
        return VsnetUtils.getLighterColor(color);
    }

    static Color getToolBarBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, 0.645f);
    }

    static Color getGripperForegroundColor(Color color) {
        int r = VsnetUtils.getGripperValue(color.getRed());
        int g = VsnetUtils.getGripperValue(color.getGreen());
        int b = VsnetUtils.getGripperValue(color.getBlue());
        if (r >= 255) {
            r = 255;
        }
        if (g >= 255) {
            g = 255;
        }
        if (b >= 255) {
            b = 255;
        }
        return new ColorUIResource(r, g, b);
    }

    static int getGripperValue(int x) {
        if (x == 255) {
            return 0;
        }
        if (x >= 0 && x <= 64) {
            return x * 33 / 64 + 123;
        }
        return (x - 65) * 157 / 189 + 33;
    }

    static Color getDefaultBackgroundColor(Color color) {
        ColorUIResource backIDE;
        if (color.getRed() == 212 && color.getGreen() == 208 && color.getBlue() == 200) {
            backIDE = new ColorUIResource(247, 243, 233);
        } else if (color.getRed() == 236 && color.getGreen() == 233 && color.getBlue() == 216) {
            backIDE = new ColorUIResource(255, 251, 233);
        } else {
            int r = color.getRed() + 35;
            int g = color.getGreen() + 35;
            int b = color.getBlue() + 35;
            if (r >= 255) {
                r = 255;
            }
            if (g >= 255) {
                g = 255;
            }
            if (b >= 255) {
                b = 255;
            }
            backIDE = new ColorUIResource(r, g, b);
        }
        return backIDE;
    }

    public static void setColorRatios(double selectedAndFocused, double rollover, double selected) {
        RATIO1 = selectedAndFocused;
        RATIO2 = rollover;
        RATIO3 = selected;
    }

    static int getLightColor(int x, double ratio) {
        return (int)((double)(255 - x) * ratio + (double)x);
    }

    static Color getLighterColor(Color color, float ratio) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, ratio);
    }

    static Color getSelectedAndRolloverButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO1);
    }

    static Color getRolloverButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO2);
    }

    static Color getSelectedButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO3);
    }

    static Color getButtonBorderColor(Color color) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return new ColorUIResource(Color.WHITE);
        }
        return color;
    }
}

