/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.Iterator;
import javax.swing.LookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.laf.AbstractPlasticController;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPlugin;
import net.sourceforge.squirrel_sql.plugins.laf.LAFPreferences;
import net.sourceforge.squirrel_sql.plugins.laf.LAFRegister;

class PlasticLookAndFeelController
extends AbstractPlasticController {
    private static ILogger s_log = LoggerController.createLogger(PlasticLookAndFeelController.class);
    static final String[] LAF_CLASS_NAMES = new String[]{"com.jgoodies.looks.plastic.PlasticLookAndFeel", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel"};
    public static final String DEFAULT_LOOK_AND_FEEL_CLASS_NAME = LAF_CLASS_NAMES[1];
    private static final String THEME_BASE_CLASS = "com.jgoodies.looks.plastic.PlasticTheme";
    private PlasticThemePreferences _prefs;

    PlasticLookAndFeelController(LAFPlugin plugin, LAFRegister lafRegister) {
        super(plugin, lafRegister);
        try {
            XMLObjectCache<LAFPreferences> cache = plugin.getSettingsCache();
            Iterator it = cache.getAllForClass(PlasticThemePreferences.class);
            if (it.hasNext()) {
                this._prefs = (PlasticThemePreferences)it.next();
            } else {
                this._prefs = new PlasticThemePreferences();
                ClassLoader cl = this.getLAFRegister().getLookAndFeelClassLoader();
                Class<?> clazz = Class.forName(AbstractPlasticController.DEFAULT_PLASTIC_THEME_CLASS_NAME, false, cl);
                MetalTheme theme = (MetalTheme)clazz.newInstance();
                this._prefs.setThemeName(theme.getName());
                try {
                    cache.add((IHasIdentifier)this._prefs);
                }
                catch (DuplicateObjectException ex) {
                    s_log.error((Object)"PlasticThemePreferences object already in XMLObjectCache", (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    String getCurrentThemeName() {
        return this._prefs.getThemeName();
    }

    @Override
    void setCurrentThemeName(String name) {
        this._prefs.setThemeName(name);
    }

    @Override
    void installCurrentTheme(LookAndFeel laf, MetalTheme theme) throws BaseException {
        try {
            Class<?> themeBaseClass;
            ClassLoader cl = this.getLAFRegister().getLookAndFeelClassLoader();
            try {
                themeBaseClass = Class.forName(THEME_BASE_CLASS, false, cl);
            }
            catch (Throwable th) {
                s_log.error((Object)"Error loading theme base class com.jgoodies.looks.plastic.PlasticTheme", th);
                throw new BaseException(th);
            }
            if (!themeBaseClass.isAssignableFrom(theme.getClass())) {
                throw new BaseException("NonPlastic Theme passed in");
            }
            MetalLookAndFeel.setCurrentTheme(theme);
        }
        catch (Throwable th) {
            throw new BaseException(th);
        }
    }

    public static final class PlasticThemePreferences
    extends AbstractPlasticController.ThemePreferences {
    }
}

