/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SubstanceLafData {
    private static ILogger s_log = LoggerController.createLogger(SubstanceLafData.class);
    private HashMap<String, Class<?>> lafMap = new HashMap();
    private ClassLoader cl = null;

    public SubstanceLafData(ClassLoader cl) {
        this.cl = cl;
        this.initLafMap();
    }

    private void initLafMap() {
        this.putClass("Autumn", "org.jvnet.substance.skin.SubstanceAutumnLookAndFeel");
        this.putClass("BusinessBlackSteel", "org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel");
        this.putClass("BusinessBlueSteelSkin", "org.jvnet.substance.skin.SubstanceBusinessBlueSteelLookAndFeel");
        this.putClass("BusinessSkin", "org.jvnet.substance.skin.SubstanceBusinessLookAndFeel");
        this.putClass("ChallengerDeepSkin", "org.jvnet.substance.skin.SubstanceChallengerDeepLookAndFeel");
        this.putClass("CremeCoffeeSkin", "org.jvnet.substance.skin.SubstanceCremeCoffeeLookAndFeel");
        this.putClass("CremeSkin", "org.jvnet.substance.skin.SubstanceCremeLookAndFeel");
        this.putClass("DustCoffeeSkin", "org.jvnet.substance.skin.SubstanceDustCoffeeLookAndFeel");
        this.putClass("DustSkin", "org.jvnet.substance.skin.SubstanceDustLookAndFeel");
        this.putClass("EmeraldDuskSkin", "org.jvnet.substance.skin.SubstanceEmeraldDuskLookAndFeel");
        this.putClass("MagmaSkin", "org.jvnet.substance.skin.SubstanceMagmaLookAndFeel");
        this.putClass("MistAquaSkin", "org.jvnet.substance.skin.SubstanceMistAquaLookAndFeel");
        this.putClass("MistSilverSkin", "org.jvnet.substance.skin.SubstanceMistSilverLookAndFeel");
        this.putClass("ModerateSkin", "org.jvnet.substance.skin.SubstanceModerateLookAndFeel");
        this.putClass("NebulaBrickWallSkin", "org.jvnet.substance.skin.SubstanceNebulaBrickWallLookAndFeel");
        this.putClass("NebulaSkin", "org.jvnet.substance.skin.SubstanceNebulaLookAndFeel");
        this.putClass("OfficeBlue2007Skin", "org.jvnet.substance.skin.SubstanceOfficeBlue2007LookAndFeel");
        this.putClass("OfficeSilver2007Skin", "org.jvnet.substance.skin.SubstanceOfficeSilver2007LookAndFeel");
        this.putClass("RavenGraphiteGlassSkin", "org.jvnet.substance.skin.SubstanceRavenGraphiteGlassLookAndFeel");
        this.putClass("RavenGraphiteSkin", "org.jvnet.substance.skin.SubstanceRavenGraphiteLookAndFeel");
        this.putClass("RavenSkin", "org.jvnet.substance.skin.SubstanceRavenLookAndFeel");
        this.putClass("SaharaSkin", "org.jvnet.substance.skin.SubstanceSaharaLookAndFeel");
        this.putClass("TwilightSkin", "org.jvnet.substance.skin.SubstanceTwilightLookAndFeel");
    }

    public Class<?> getSkinClassForName(String skinName) {
        return this.lafMap.get(skinName);
    }

    public Set<String> getSubstanceSkins() {
        TreeSet<String> result = new TreeSet<String>(this.lafMap.keySet());
        return result;
    }

    private void putClass(String skinName, String className) {
        try {
            Class<?> skinClass = Class.forName(className, true, this.cl);
            this.lafMap.put(skinName, skinClass);
        }
        catch (ClassNotFoundException e) {
            s_log.error((Object)("Unable to load LAF class (" + className + "):" + e.getMessage()), (Throwable)e);
        }
    }
}

