/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersBaseManager;
import com.jetbrains.php.config.interpreters.PhpInterpretersManager;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersStateListener;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpretersManagerImpl
implements PhpInterpretersManager {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"PHP Interpreters");
    private final PhpApplicationInterpretersManager myApplicationManager = (PhpApplicationInterpretersManager)ServiceManager.getService(PhpApplicationInterpretersManager.class);
    private final PhpProjectInterpretersManager myProjectManager;

    public static PhpInterpretersManagerImpl getInstance(@Nullable Project project) {
        Project targetProject = project == null ? ProjectManager.getInstance().getDefaultProject() : project;
        return (PhpInterpretersManagerImpl)ServiceManager.getService((Project)targetProject, PhpInterpretersManagerImpl.class);
    }

    public PhpInterpretersManagerImpl(@Nullable Project project) {
        if (project != null && !project.isDefault()) {
            this.myProjectManager = (PhpProjectInterpretersManager)ServiceManager.getService((Project)project, PhpProjectInterpretersManager.class);
            this.addListener(project, () -> this.resolvePossibleCollisions(project));
            Arrays.asList(PhpInterpretersStateListener.EP_NAME.getExtensions((AreaInstance)project)).forEach(interpretersStateListener -> this.addListener(project, (PhpInterpretersStateListener)interpretersStateListener));
            this.resolvePossibleCollisions(project);
        } else {
            this.myProjectManager = null;
        }
    }

    private void resolvePossibleCollisions(@NotNull Project project) {
        if (project == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(0);
        }
        if (this.myProjectManager == null) {
            return;
        }
        String selected = PhpProjectConfigurationFacade.getInstance(project).getProjectConfiguration().getInterpreterName();
        List<PhpInterpreter> interpreters = this.getInterpreters();
        HashSet appInterpretersNames = new HashSet();
        HashSet appInterpretersIds = new HashSet();
        HashSet projectInterpretersNames = new HashSet();
        for (PhpInterpreter interpreter : interpreters) {
            if (!interpreter.isProjectLevel()) {
                appInterpretersIds.add(interpreter.getId());
                appInterpretersNames.add(interpreter.getName());
                continue;
            }
            projectInterpretersNames.add(interpreter.getName());
        }
        Condition isOccupied = arg_0 -> PhpInterpretersManagerImpl.lambda$resolvePossibleCollisions$2((Set)appInterpretersNames, (Set)projectInterpretersNames, arg_0);
        HashSet previousProjectInterpretersIds = new HashSet();
        HashMap oldToNewId = new HashMap();
        HashMap oldToNewName = new HashMap();
        for (PhpInterpreter interpreter : interpreters) {
            String oldName = interpreter.getName();
            if (interpreter.isProjectLevel() && (appInterpretersNames.contains(oldName) || appInterpretersIds.contains(interpreter.getId()))) {
                PhpInterpreter oldInterpreter = interpreter.clone();
                if (appInterpretersNames.contains(oldName)) {
                    interpreter.setName(PhpNameUtil.unique(oldName + " (project level)", " (", ")", (Condition<? super String>)isOccupied));
                    if (StringUtil.isNotEmpty((String)selected) && oldName.equals(selected)) {
                        PhpProjectConfigurationFacade.getInstance(project).updateSelectedInterpreterName(oldName, interpreter.getName());
                    }
                }
                while (appInterpretersIds.contains(interpreter.getId()) || previousProjectInterpretersIds.contains(interpreter.getId())) {
                    interpreter.setId(PhpInterpreter.getNextId());
                }
                oldToNewName.put(oldName, interpreter.getName());
                if (!StringUtil.equals((CharSequence)oldInterpreter.getId(), (CharSequence)interpreter.getId())) {
                    oldToNewId.put(oldInterpreter.getId(), interpreter.getId());
                }
                projectInterpretersNames.add(oldName);
            }
            previousProjectInterpretersIds.add(interpreter.getId());
        }
        if (!oldToNewName.isEmpty()) {
            this.setInterpreters(interpreters);
            PhpInterpretersPhpInfoCacheImpl.getInstance(project).resolveConflicts((Map<String, String>)oldToNewName);
            if (!oldToNewId.isEmpty()) {
                ((PhpInterpreterConflictResolveListener)project.getMessageBus().syncPublisher(PhpInterpreterConflictResolveListener.TOPIC)).resolveInterpreterConflict((Map<String, String>)oldToNewId);
            }
            PhpInterpretersManagerImpl.showWarning(project, (Map<String, String>)oldToNewName);
        }
    }

    private static void showWarning(@NotNull Project project, @NotNull Map<String, String> oldToNewName) {
        if (project == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(1);
        }
        if (oldToNewName == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(2);
        }
        StringBuilder builder = new StringBuilder(PhpBundle.message("PhpInterpreter.php.interpreter.name.conflict", new Object[0]));
        for (Map.Entry<String, String> entry : oldToNewName.entrySet()) {
            builder.append("<br/><b>'").append(entry.getKey()).append("'</b> -> <b>'").append(entry.getValue()).append("'</b>");
        }
        String title = PhpBundle.message("PhpInterpreter.php.interpreter.name.conflict.title", new Object[0]);
        NOTIFICATION_GROUP.createNotification(title, builder.toString(), NotificationType.WARNING, null).notify(project);
    }

    @Override
    @NotNull
    public List<PhpInterpreter> getInterpreters() {
        ArrayList<PhpInterpreter> result = new ArrayList<PhpInterpreter>(this.myApplicationManager.getInterpreters());
        if (this.myProjectManager != null) {
            result.addAll(this.myProjectManager.getInterpreters());
        }
        ArrayList<PhpInterpreter> arrayList = result;
        if (arrayList == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    public void setInterpreters(@NotNull List<PhpInterpreter> interpreters) {
        if (interpreters == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(4);
        }
        if (this.myProjectManager == null) {
            this.myApplicationManager.setInterpreters(interpreters);
            return;
        }
        ArrayList<PhpInterpreter> applicationLevel = new ArrayList<PhpInterpreter>();
        ArrayList<PhpInterpreter> projectLevel = new ArrayList<PhpInterpreter>();
        for (PhpInterpreter interpreter : interpreters) {
            if (interpreter.isProjectLevel()) {
                projectLevel.add(interpreter);
                continue;
            }
            applicationLevel.add(interpreter);
        }
        this.myProjectManager.setInterpreters(projectLevel);
        this.myApplicationManager.setInterpreters(applicationLevel);
        this.myProjectManager.onInterpretersUpdate();
    }

    @Override
    public void addInterpreter(@NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(5);
        }
        if (interpreter.isProjectLevel()) {
            if (this.myProjectManager != null) {
                this.myProjectManager.addInterpreter(interpreter);
            }
        } else {
            this.myApplicationManager.addInterpreter(interpreter);
        }
    }

    @Override
    @Nullable
    public PhpInterpreter findInterpreter(@Nullable String interpreterName) {
        PhpInterpreter interpreter = this.myApplicationManager.findInterpreter(interpreterName);
        if (interpreter == null && this.myProjectManager != null) {
            interpreter = this.myProjectManager.findInterpreter(interpreterName);
        }
        return interpreter;
    }

    @Override
    @Nullable
    public PhpInterpreter findInterpreterById(@Nullable String interpreterId) {
        PhpInterpreter interpreter = this.myApplicationManager.findInterpreterById(interpreterId);
        if (interpreter == null && this.myProjectManager != null) {
            interpreter = this.myProjectManager.findInterpreterById(interpreterId);
        }
        return interpreter;
    }

    @Override
    @Nullable
    public PhpSdkAdditionalData findInterpreterDataById(@Nullable String interpreterId) {
        PhpSdkAdditionalData data = this.myApplicationManager.findInterpreterDataById(interpreterId);
        if (data == null && this.myProjectManager != null) {
            data = this.myProjectManager.findInterpreterDataById(interpreterId);
        }
        return data;
    }

    @Override
    @Nullable
    public String findInterpreterId(@Nullable String interpreterName) {
        String interpreterId = this.myApplicationManager.findInterpreterId(interpreterName);
        if (interpreterId == null && this.myProjectManager != null) {
            interpreterId = this.myProjectManager.findInterpreterId(interpreterName);
        }
        return interpreterId;
    }

    @Override
    @Nullable
    public String findInterpreterName(@Nullable String interpreterId) {
        String interpreterName = this.myApplicationManager.findInterpreterName(interpreterId);
        if (interpreterName == null && this.myProjectManager != null) {
            interpreterName = this.myProjectManager.findInterpreterName(interpreterId);
        }
        return interpreterName;
    }

    @Override
    public void addListener(@NotNull Project project, @NotNull PhpInterpretersStateListener listener) {
        if (project == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(6);
        }
        if (listener == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(7);
        }
        this.myApplicationManager.addListener(project, listener);
        if (this.myProjectManager != null) {
            this.myProjectManager.addListener(project, listener);
        }
    }

    public boolean isProjectLevel(@Nullable String interpreterId) {
        return this.myProjectManager != null && this.myProjectManager.findInterpreterById(interpreterId) != null;
    }

    @NotNull
    public String getUniqueName(@NotNull String newName) {
        if (newName == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(8);
        }
        HashSet interpreterNames = new HashSet();
        for (PhpInterpreter interpreter : this.getInterpreters()) {
            interpreterNames.add(interpreter.getName());
        }
        if (!interpreterNames.contains(newName)) {
            String string = newName;
            if (string == null) {
                PhpInterpretersManagerImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String name = newName;
        int counter = 1;
        while (interpreterNames.contains(name)) {
            name = newName + " (" + counter++ + ")";
        }
        String string = name;
        if (string == null) {
            PhpInterpretersManagerImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$resolvePossibleCollisions$2(Set appInterpretersNames, Set projectInterpretersNames, String name) {
        return appInterpretersNames.contains(name) || projectInterpretersNames.contains(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewName";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleCollisions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addInterpreter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="PhpInterpreters", storages={@Storage(value="php.xml")})
    public static class PhpProjectInterpretersManager
    extends PhpInterpretersBaseManager {
        public static PhpProjectInterpretersManager getInstance(@NotNull Project project) {
            if (project == null) {
                PhpProjectInterpretersManager.$$$reportNull$$$0(0);
            }
            return (PhpProjectInterpretersManager)ServiceManager.getService((Project)project, PhpProjectInterpretersManager.class);
        }

        @Override
        public void finishInitialization(@NotNull PhpInterpreter interpreter) {
            if (interpreter == null) {
                PhpProjectInterpretersManager.$$$reportNull$$$0(1);
            }
            interpreter.setIsProjectLevel(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl$PhpProjectInterpretersManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finishInitialization";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @State(name="PhpInterpreters", storages={@Storage(value="php.xml")})
    public static class PhpApplicationInterpretersManager
    extends PhpInterpretersBaseManager {
        public static PhpApplicationInterpretersManager getInstance() {
            return (PhpApplicationInterpretersManager)ServiceManager.getService(PhpApplicationInterpretersManager.class);
        }

        @Override
        public void finishInitialization(@NotNull PhpInterpreter interpreter) {
            if (interpreter == null) {
                PhpApplicationInterpretersManager.$$$reportNull$$$0(0);
            }
            interpreter.setIsProjectLevel(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/php/config/interpreters/PhpInterpretersManagerImpl$PhpApplicationInterpretersManager", "finishInitialization"));
        }
    }

    public static interface PhpInterpreterConflictResolveListener {
        public static final Topic<PhpInterpreterConflictResolveListener> TOPIC = Topic.create((String)"resolveInterpreterConflict", PhpInterpreterConflictResolveListener.class);

        public void resolveInterpreterConflict(@NotNull Map<String, String> var1);
    }
}

