/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStatementHasEmptyBodyInspection
extends PhpInspection {
    public boolean myCommentsCountAsContent = false;
    public boolean myIgnoreWhileWithoutBody = false;
    public boolean myIgnoreForWithoutBody = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpIf(If ifStatement) {
                Else elseBranch = ifStatement.getElseBranch();
                if (elseBranch != null) {
                    this.processStatement((PsiElement)elseBranch, (PsiElement)elseBranch.getStatement());
                    return;
                }
                ElseIf lastElseIf = (ElseIf)ArrayUtil.getLastElement((Object[])ifStatement.getElseIfBranches());
                if (lastElseIf != null) {
                    this.processStatement((PsiElement)lastElseIf, (PsiElement)lastElseIf.getStatement());
                    return;
                }
                this.processStatement((PsiElement)ifStatement, (PsiElement)ifStatement.getStatement());
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                this.processStatement((PsiElement)foreach, (PsiElement)foreach.getStatement());
            }

            public void visitPhpFor(For forStatement) {
                Statement statement = forStatement.getStatement();
                if (PhpStatementHasEmptyBodyInspection.this.myIgnoreForWithoutBody && statement != null && PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.opSEMICOLON)) {
                    return;
                }
                this.processStatement((PsiElement)forStatement, (PsiElement)statement);
            }

            public void visitPhpWhile(While whileStatement) {
                Statement statement = whileStatement.getStatement();
                if (PhpStatementHasEmptyBodyInspection.this.myIgnoreWhileWithoutBody && statement != null && PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.opSEMICOLON)) {
                    return;
                }
                this.processStatement((PsiElement)whileStatement, (PsiElement)statement);
            }

            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                this.processStatement((PsiElement)doWhileStatement, (PsiElement)doWhileStatement.getStatement());
            }

            public void visitPhpSwitch(PhpSwitch switchStatement) {
                this.processStatement((PsiElement)switchStatement, (PsiElement)switchStatement);
            }

            public void visitPhpTry(Try tryStatement2) {
                this.processStatement((PsiElement)tryStatement2, (PsiElement)tryStatement2.getStatement());
            }

            public void visitPhpFinally(Finally element) {
                this.processStatement((PsiElement)element, (PsiElement)element.getStatement());
            }

            private void processStatement(@NotNull PsiElement parent, @Nullable PsiElement statement) {
                PsiElement firstChild;
                if (parent == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpStatementHasEmptyBodyInspection.this.isEmpty(statement) && (firstChild = parent.getFirstChild()) != null) {
                    holder.registerProblem(firstChild, "Statement has empty body", new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$1", "processStatement"));
            }
        };
        if (phpElementVisitor == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @Contract(value="null -> false")
    private boolean isEmpty(@Nullable PsiElement element) {
        if (element instanceof PhpSwitch) {
            return ((PhpSwitch)element).getAllCases().length == 0;
        }
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiComment) {
            return !this.myCommentsCountAsContent;
        }
        if (element instanceof Statement) {
            PsiElement firstChild = element.getFirstChild();
            if (PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.opSEMICOLON)) {
                return !this.myCommentsCountAsContent || !(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true) instanceof PsiComment);
            }
            if (element instanceof GroupStatement) {
                return this.isEmpty((GroupStatement)element);
            }
        }
        return false;
    }

    private boolean isEmpty(@NotNull GroupStatement statement) {
        if (statement == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(2);
        }
        for (PsiElement s = statement.getFirstChild(); s != null; s = s.getNextSibling()) {
            if (PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE) || this.isEmpty(s)) continue;
            return false;
        }
        return !this.myCommentsCountAsContent || !(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)statement, true) instanceof PsiComment) && !(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)statement, true) instanceof PsiComment);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(PhpBundle.message("inspection.statement.has.empty.body.comments.count.as.content", new Object[0]), "myCommentsCountAsContent");
        optionsPanel.addCheckbox(PhpBundle.message("inspection.statement.has.empty.body.ignore.empty.while", new Object[0]), "myIgnoreWhileWithoutBody");
        optionsPanel.addCheckbox(PhpBundle.message("inspection.statement.has.empty.body.ignore.empty.for", new Object[0]), "myIgnoreForWithoutBody");
        return optionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

