/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug.missingParentCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class PhpMissingParentConstructorInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingParentConstructorInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                Method superClassConstructor;
                super.visitPhpClass(clazz);
                Method constructor = clazz.getOwnConstructor();
                final PhpClass superClass = clazz.getSuperClass();
                final Ref answer = new Ref((Object)false);
                if (constructor != null && superClass != null && (superClassConstructor = superClass.getConstructor()) != null && !superClassConstructor.isAbstract() && !(superClassConstructor instanceof PhpDocMethod)) {
                    PsiElement nameIdentifier;
                    PhpControlFlowUtil.processFlow(constructor.getControlFlow(), new PhpInstructionProcessor(){

                        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                            if (PhpMissingParentConstructorInspection.isParentConstructorCall(instruction, superClass)) {
                                answer.set((Object)true);
                                return false;
                            }
                            return true;
                        }
                    });
                    if (!((Boolean)answer.get()).booleanValue() && (nameIdentifier = constructor.getNameIdentifier()) != null && nameIdentifier.getContainingFile() == holder.getFile()) {
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.missing.parent.constructor.call.message", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpMissingParentConstructorInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean isParentConstructorCall(PhpCallInstruction instruction, @NotNull PhpClass parent) {
        FunctionReference functionReference;
        if (parent == null) {
            PhpMissingParentConstructorInspection.$$$reportNull$$$0(2);
        }
        if ((functionReference = instruction.getFunctionReference()) instanceof MethodReference) {
            ResolveResult[] results;
            MethodReference mReference = (MethodReference)functionReference;
            for (ResolveResult it : results = mReference.multiResolve(false)) {
                Method parentConstructor;
                PsiElement resolve = it.getElement();
                if (!(resolve instanceof Method) || (parentConstructor = parent.getConstructor()) == null || !PhpRefactoringUtil.isConstructor((Method)resolve) || !parentConstructor.equals(resolve)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/missingParentCall/PhpMissingParentConstructorInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/missingParentCall/PhpMissingParentConstructorInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isParentConstructorCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

