/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.surroundWith.PhpStatementSurrounder;

public class PhpForSurrounder
extends PhpStatementSurrounder<For> {
    @Override
    protected String getStatementTemplate(Project project, PsiElement[] elements) {
        return "for($a=0;$a<1;$a++){}";
    }

    @Override
    protected PsiElement getInsertInto(For statement) {
        return statement.getStatement();
    }

    @Override
    protected TextRange getSurroundSelectionRange(For statement) {
        PhpPsiElement initialExpression = statement.getInitialExpressions()[0];
        PhpPsiElement conditionalExpression = statement.getConditionalExpressions()[0];
        PhpPsiElement repeatedExpression = statement.getRepeatedExpressions()[0];
        int offset = initialExpression.getTextOffset();
        initialExpression.delete();
        conditionalExpression.delete();
        repeatedExpression.delete();
        return TextRange.from((int)offset, (int)0);
    }

    public String getTemplateDescription() {
        return "for";
    }
}

