/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight.attributes;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.BasicXmlAttributeDescriptor;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import icons.AngularJSIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.angular2.codeInsight.Angular2Processor;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptorsProvider;
import org.angular2.codeInsight.attributes.Angular2EventHandlerDescriptor;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveProperty;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.psi.Angular2HtmlEvent;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2AttributeDescriptor
extends BasicXmlAttributeDescriptor
implements XmlAttributeDescriptorEx,
PsiPresentableMetaData {
    private static final JSType STRING_TYPE = new JSStringType(true, JSTypeSource.EXPLICITLY_DECLARED, JSTypeContext.INSTANCE);
    @NotNull
    private final AttributePriority myPriority;
    @NotNull
    private final PsiElement[] myElements;
    @NotNull
    private final String myAttributeName;
    @NotNull
    private final Angular2AttributeNameParser.AttributeInfo myInfo;

    @Nullable
    public static Angular2AttributeDescriptor create(@NotNull String attributeName) {
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(0);
        }
        return Angular2AttributeDescriptor.create(attributeName, Collections.emptyList());
    }

    @Nullable
    public static Angular2AttributeDescriptor create(@NotNull String attributeName, @NotNull PsiElement element) {
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(2);
        }
        return Angular2AttributeDescriptor.create(attributeName, Collections.singletonList(element));
    }

    @Nullable
    public static Angular2AttributeDescriptor create(@NotNull String attributeName, @NotNull List<PsiElement> elements) {
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(4);
        }
        if (Angular2AttributeDescriptorsProvider.getCustomNgAttrs().contains(attributeName)) {
            return new Angular2AttributeDescriptor(attributeName, false, elements);
        }
        Angular2AttributeNameParser.AttributeInfo info = Angular2AttributeNameParser.parse(attributeName, true);
        if (elements.isEmpty() && (info.type == Angular2AttributeType.REGULAR || info.type == Angular2AttributeType.TEMPLATE_BINDINGS || info instanceof Angular2AttributeNameParser.EventInfo && ((Angular2AttributeNameParser.EventInfo)info).eventType == Angular2HtmlEvent.EventType.REGULAR && !info.name.contains(":") || info instanceof Angular2AttributeNameParser.PropertyBindingInfo && ((Angular2AttributeNameParser.PropertyBindingInfo)info).bindingType == PropertyBindingType.PROPERTY)) {
            return null;
        }
        if (info.type == Angular2AttributeType.EVENT) {
            return new Angular2EventHandlerDescriptor(attributeName, info, elements);
        }
        return new Angular2AttributeDescriptor(attributeName, info, elements);
    }

    @NotNull
    public static List<XmlAttributeDescriptor> getDirectiveDescriptors(@NotNull Angular2Directive directive, boolean isTemplateTagContext) {
        if (directive == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(5);
        }
        if (directive.isTemplate() && !isTemplateTagContext) {
            List<XmlAttributeDescriptor> list = Collections.emptyList();
            if (list == null) {
                Angular2AttributeDescriptor.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<XmlAttributeDescriptor> result = new ArrayList<XmlAttributeDescriptor>();
        Angular2AttributeDescriptor.addDirectiveDescriptors(directive.getInOuts(), Angular2AttributeDescriptor::createBananaBoxBinding, result);
        Angular2AttributeDescriptor.addDirectiveDescriptors(directive.getInputs(), Angular2AttributeDescriptor::createBinding, result);
        Angular2AttributeDescriptor.addDirectiveDescriptors(directive.getOutputs(), Angular2AttributeDescriptor::createEventHandler, result);
        Angular2AttributeDescriptor.addDirectiveDescriptors(directive.getInputs(), Angular2AttributeDescriptor::createOneTimeBinding, result);
        ArrayList<XmlAttributeDescriptor> arrayList = result;
        if (arrayList == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected Angular2AttributeDescriptor(@NotNull String attributeName, boolean isInTemplateTag, @NotNull Collection<PsiElement> elements) {
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(9);
        }
        this(attributeName, Angular2AttributeNameParser.parse(attributeName, isInTemplateTag), AttributePriority.NORMAL, elements);
    }

    protected Angular2AttributeDescriptor(@NotNull String attributeName, @NotNull Angular2AttributeNameParser.AttributeInfo info, @NotNull Collection<PsiElement> elements) {
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(10);
        }
        if (info == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(11);
        }
        if (elements == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(12);
        }
        this(attributeName, info, AttributePriority.NORMAL, elements);
    }

    protected Angular2AttributeDescriptor(@NotNull String attributeName, boolean isInTemplateTag, @NotNull AttributePriority priority, @NotNull Collection<PsiElement> elements) {
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(13);
        }
        if (priority == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(15);
        }
        this(attributeName, Angular2AttributeNameParser.parse(attributeName, isInTemplateTag), priority, elements);
    }

    protected Angular2AttributeDescriptor(@NotNull String attributeName, @NotNull Angular2AttributeNameParser.AttributeInfo info, @NotNull AttributePriority priority, @NotNull Collection<PsiElement> elements) {
        if (attributeName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(16);
        }
        if (info == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(17);
        }
        if (priority == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(18);
        }
        if (elements == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(19);
        }
        this.myAttributeName = attributeName;
        this.myElements = elements.toArray(PsiElement.EMPTY_ARRAY);
        this.myInfo = info;
        this.myPriority = priority;
    }

    public String getName() {
        return this.myAttributeName;
    }

    public void init(PsiElement element) {
    }

    public boolean isRequired() {
        return false;
    }

    public boolean hasIdType() {
        return "id".equals(this.myAttributeName);
    }

    public boolean hasIdRefType() {
        return false;
    }

    public boolean isEnumerated() {
        return this.getEnumeratedValues().length > 0;
    }

    public boolean isFixed() {
        return false;
    }

    public String getDefaultValue() {
        return null;
    }

    @NotNull
    public String[] getEnumeratedValues() {
        JSType type = this.getJSType();
        if (type != null && this.myInfo.type == Angular2AttributeType.REGULAR) {
            ArrayList values = new ArrayList();
            if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)type)) instanceof JSBooleanType) {
                String[] stringArray = new String[]{this.myAttributeName};
                if (stringArray == null) {
                    Angular2AttributeDescriptor.$$$reportNull$$$0(20);
                }
                return stringArray;
            }
            JSTypeUtils.processExpandedType(subType -> {
                if (subType instanceof JSStringLiteralTypeImpl) {
                    values.add(((JSStringLiteralTypeImpl)subType).getLiteral());
                }
                return true;
            }, (JSType)type);
            if (!values.isEmpty()) {
                String[] stringArray = ArrayUtil.toStringArray(values);
                if (stringArray == null) {
                    Angular2AttributeDescriptor.$$$reportNull$$$0(21);
                }
                return stringArray;
            }
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(22);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected PsiElement getEnumeratedValueDeclaration(XmlElement xmlElement, String value) {
        return xmlElement;
    }

    public PsiElement getDeclaration() {
        return (PsiElement)ArrayUtil.getFirstElement((Object[])this.myElements);
    }

    @Nullable
    public String handleTargetRename(@NotNull @NonNls String newTargetName) {
        if (newTargetName == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(23);
        }
        if (this.myInfo.type != Angular2AttributeType.REGULAR) {
            int start = this.myAttributeName.lastIndexOf(this.myInfo.name);
            return this.myAttributeName.substring(0, start) + newTargetName + this.myAttributeName.substring(start + this.myInfo.name.length());
        }
        return newTargetName;
    }

    public String getTypeName() {
        JSType type = this.getJSType();
        if (type != null) {
            if (this.myInfo instanceof Angular2AttributeNameParser.PropertyBindingInfo && ((Angular2AttributeNameParser.PropertyBindingInfo)this.myInfo).bindingType == PropertyBindingType.PROPERTY || type instanceof JSPrimitiveType || this.isEnumerated()) {
                return StringUtil.shortenTextWithEllipsis((String)type.getTypeText(), (int)25, (int)0, (boolean)true);
            }
            if (this.myInfo instanceof Angular2AttributeNameParser.EventInfo && ((Angular2AttributeNameParser.EventInfo)this.myInfo).eventType == Angular2HtmlEvent.EventType.REGULAR && (type = Angular2Processor.getEventVariableType(type)) != null) {
                return type.getTypeText();
            }
        }
        return null;
    }

    public LookupElement getLookupElement() {
        LookupElementBuilder element = LookupElementBuilder.create((String)this.getName()).withCaseSensitivity(this.myInfo.type != Angular2AttributeType.REGULAR || this.myElements.length > 0 && !(this.myElements[0] instanceof JSPsiElementBase)).withIcon(this.getIcon()).withBoldness(this.myPriority == AttributePriority.HIGH);
        String typeName = this.getTypeName();
        if (!StringUtil.isEmptyOrSpaces((String)typeName)) {
            element = element.withTypeText(typeName);
        }
        if (this.shouldCompleteValue()) {
            element = element.withInsertHandler((InsertHandler)XmlAttributeInsertHandler.INSTANCE);
        }
        return PrioritizedLookupElement.withPriority((LookupElement)element, (double)this.myPriority.getValue());
    }

    private boolean shouldCompleteValue() {
        JSType type = this.getJSType();
        return this.myInfo.type != Angular2AttributeType.REGULAR || type != null && !(type instanceof JSBooleanType);
    }

    @NotNull
    public Angular2AttributeNameParser.AttributeInfo getInfo() {
        Angular2AttributeNameParser.AttributeInfo attributeInfo = this.myInfo;
        if (attributeInfo == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(24);
        }
        return attributeInfo;
    }

    @Nullable
    public Icon getIcon() {
        return AngularJSIcons.Angular2;
    }

    @Nullable
    private JSType getJSType() {
        List types = ContainerUtil.mapNotNull((Object[])this.myElements, element -> {
            if (element instanceof JSFunction) {
                JSParameterListElement[] params = ((JSFunction)element).getParameters();
                if (((JSFunction)element).isSetProperty() && params.length == 1) {
                    return params[0].getDeclaredType();
                }
            }
            return JSTypeUtils.getTypeOfElement((PsiElement)element);
        });
        if (types.size() == 1) {
            return (JSType)types.get(0);
        }
        if (types.size() > 1) {
            if (this.myInfo.type == Angular2AttributeType.BANANA_BOX_BINDING) {
                return (JSType)types.get(0);
            }
            return JSCompositeTypeImpl.getCommonType((Collection)types, (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)this.myElements[0], (boolean)false), (boolean)false);
        }
        return null;
    }

    static boolean isOneTimeBindingProperty(@NotNull Angular2DirectiveProperty property) {
        if (property == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(25);
        }
        return property.isVirtual() || property.getType() != null && Angular2AttributeDescriptor.expandStringLiteralTypes(property.getType()).isDirectlyAssignableType(STRING_TYPE, null);
    }

    private static <T> void addDirectiveDescriptors(@NotNull Collection<T> list, @NotNull Function<T, ? extends XmlAttributeDescriptor> factory, @NotNull List<XmlAttributeDescriptor> result) {
        if (list == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(26);
        }
        if (factory == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(27);
        }
        if (result == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(28);
        }
        list.forEach(el -> {
            if (factory == null) {
                Angular2AttributeDescriptor.$$$reportNull$$$0(36);
            }
            if (result == null) {
                Angular2AttributeDescriptor.$$$reportNull$$$0(37);
            }
            Boolean cfr_ignored_0 = (Boolean)ObjectUtils.doIfNotNull(factory.apply(el), result::add);
        });
    }

    @NotNull
    private static Angular2AttributeDescriptor createBinding(@NotNull Angular2DirectiveProperty info) {
        if (info == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(29);
        }
        Angular2AttributeDescriptor angular2AttributeDescriptor = new Angular2AttributeDescriptor(Angular2AttributeType.PROPERTY_BINDING.buildName(info.getName()), false, AttributePriority.HIGH, Collections.singletonList(info.getNavigableElement()));
        if (angular2AttributeDescriptor == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(30);
        }
        return angular2AttributeDescriptor;
    }

    @NotNull
    private static Angular2AttributeDescriptor createBananaBoxBinding(@NotNull Pair<Angular2DirectiveProperty, Angular2DirectiveProperty> info) {
        if (info == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(31);
        }
        Angular2AttributeDescriptor angular2AttributeDescriptor = new Angular2AttributeDescriptor(Angular2AttributeType.BANANA_BOX_BINDING.buildName(((Angular2DirectiveProperty)info.first).getName()), false, AttributePriority.HIGH, (Collection<PsiElement>)ContainerUtil.newArrayList((Object[])new PsiElement[]{((Angular2DirectiveProperty)info.first).getNavigableElement(), ((Angular2DirectiveProperty)info.second).getNavigableElement()}));
        if (angular2AttributeDescriptor == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(32);
        }
        return angular2AttributeDescriptor;
    }

    @Nullable
    private static Angular2AttributeDescriptor createOneTimeBinding(@NotNull Angular2DirectiveProperty info) {
        if (info == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(33);
        }
        return Angular2AttributeDescriptor.isOneTimeBindingProperty(info) ? new Angular2AttributeDescriptor(info.getName(), false, AttributePriority.HIGH, Collections.singletonList(info.getNavigableElement())) : null;
    }

    @NotNull
    private static Angular2EventHandlerDescriptor createEventHandler(@NotNull Angular2DirectiveProperty info) {
        if (info == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(34);
        }
        Angular2EventHandlerDescriptor angular2EventHandlerDescriptor = new Angular2EventHandlerDescriptor(Angular2AttributeType.EVENT.buildName(info.getName()), false, AttributePriority.HIGH, Collections.singletonList(info.getNavigableElement()));
        if (angular2EventHandlerDescriptor == null) {
            Angular2AttributeDescriptor.$$$reportNull$$$0(35);
        }
        return angular2EventHandlerDescriptor;
    }

    @Contract(value="null->null")
    private static JSType expandStringLiteralTypes(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive((JSType)type);
        return type.transformTypeHierarchy(toApply -> toApply instanceof JSPrimitiveType ? STRING_TYPE : toApply);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/codeInsight/attributes/Angular2AttributeDescriptor";
                break;
            }
            case 11: 
            case 17: 
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTargetName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/codeInsight/attributes/Angular2AttributeDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectiveDescriptors";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumeratedValues";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinding";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createBananaBoxBinding";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectiveDescriptors";
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 35: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetRename";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isOneTimeBindingProperty";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addDirectiveDescriptors";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createBinding";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createBananaBoxBinding";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createOneTimeBinding";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createEventHandler";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addDirectiveDescriptors$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 30: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AttributePriority {
        LOW(25.0),
        NORMAL(50.0),
        HIGH(100.0);

        private final double myValue;

        private AttributePriority(double value) {
            this.myValue = value;
        }

        public double getValue() {
            return this.myValue;
        }
    }
}

