/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.Family;
import com.intellij.database.util.StringFun;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\f\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u001c\u0010\u0011\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u0003*\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u001a \u0010\u0011\u001a\u00020\u0005*\u00020\u000e2\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"eoln", "", "indentStep", "", "describeTreeRecursively", "", "service", "Lcom/intellij/database/model/DescriptionService;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "e", "Lcom/intellij/database/model/basic/BasicElement;", "describeForest", "", "Lcom/intellij/database/model/basic/BasicNode;", "withSurrogates", "", "describeTree", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.database.impl"})
@JvmName(name="ModelDescribing")
public final class ModelDescribing {
    private static final String indentStep = "    ";
    private static final char eoln = '\n';

    @JvmOverloads
    @NotNull
    public static final String describeForest(@NotNull Iterable<? extends BasicNode> $receiver, boolean withSurrogates) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        StringBuilder b2 = new StringBuilder();
        Iterable<? extends BasicNode> $receiver$iv = $receiver;
        Iterator<? extends BasicNode> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicNode element$iv;
            BasicNode it = element$iv = iterator.next();
            ModelDescribing.describeTree(it, b2, withSurrogates);
        }
        String string = StringUtil.convertLineSeparators((String)b2.toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.convertLineSeparators(b.toString())");
        return string;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String describeForest$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ModelDescribing.describeForest(iterable, bl);
    }

    @JvmOverloads
    @NotNull
    public static final String describeForest(@NotNull Iterable<? extends BasicNode> $receiver) {
        return ModelDescribing.describeForest$default($receiver, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public static final String describeTree(@NotNull BasicNode $receiver, boolean withSurrogates) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        StringBuilder b2 = new StringBuilder();
        ModelDescribing.describeTree($receiver, b2, withSurrogates);
        String string = StringUtil.convertLineSeparators((String)b2.toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.convertLineSeparators(b.toString())");
        return string;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String describeTree$default(BasicNode basicNode, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ModelDescribing.describeTree(basicNode, bl);
    }

    @JvmOverloads
    @NotNull
    public static final String describeTree(@NotNull BasicNode $receiver) {
        return ModelDescribing.describeTree$default($receiver, false, 1, null);
    }

    private static final void describeTree(@NotNull BasicNode $receiver, StringBuilder b2, boolean withSurrogates) {
        BasicModel basicModel = $receiver.getModel();
        if (basicModel == null || (basicModel = basicModel.getDbms()) == null) {
            basicModel = Dbms.UNKNOWN;
        }
        ModelFacade modelFacade = ModelFacade.forDbms((Dbms)basicModel);
        Intrinsics.checkExpressionValueIsNotNull((Object)modelFacade, (String)"ModelFacade.forDbms(model?.dbms ?: Dbms.UNKNOWN)");
        DescriptionService descriptionService = modelFacade.getDescriptionService();
        Intrinsics.checkExpressionValueIsNotNull((Object)descriptionService, (String)"ModelFacade.forDbms(mode\u2026KNOWN).descriptionService");
        DescriptionService service = descriptionService;
        DescriptionService.Context context = new DescriptionService.Context();
        context.setWithSurrogates(withSurrogates);
        context.setOut(b2);
        context.setIndent("");
        ModelDescribing.describeTree($receiver, service, context);
    }

    private static final void describeTree(@NotNull BasicNode $receiver, DescriptionService service, DescriptionService.Context context) {
        BasicNode basicNode = $receiver;
        if (basicNode instanceof BasicElement) {
            ModelDescribing.describeTreeRecursively(service, context, (BasicElement)$receiver);
        } else if (basicNode instanceof Family) {
            Iterable $receiver$iv = (Iterable)((Object)$receiver);
            for (Object element$iv : $receiver$iv) {
                BasicElement it;
                BasicElement basicElement = it = (BasicElement)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                ModelDescribing.describeTree((BasicNode)basicElement, service, context);
            }
        } else {
            context.getOut().append($receiver.toString());
        }
    }

    private static final void describeTreeRecursively(DescriptionService service, DescriptionService.Context context, BasicElement e) {
        CharSequence charSequence;
        StringBuilder b2 = context.getOut();
        String indent = context.getIndent();
        String name = e.getParent() instanceof BasicView && Intrinsics.areEqual((Object)e.getKind(), (Object)ObjectKind.COLUMN) && e instanceof BasicNamedElement && ((BasicNamedElement)e).isNameSurrogate() && ((BasicNamedElement)e).isNameScripted() ? ((BasicNamedElement)e).getRealName() : e.identity(context.getWithSurrogates());
        b2.append(indent).append(name).append(":");
        CharSequence charSequence2 = service.content(e, context);
        String string = charSequence2;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String content = ((Object)StringsKt.trim((CharSequence)string)).toString();
        charSequence2 = content;
        if (!(charSequence2.length() == 0)) {
            b2.append(" ").append(content);
        }
        b2.append(service.options(e, context));
        while (true) {
            Character c2 = StringFun.getLastChar(b2);
            if (c2 == null || c2.charValue() != '\n') break;
            b2.setLength(b2.length() - 1);
        }
        b2.append('\n');
        String comment = e.getComment();
        if (comment != null && !((charSequence = (CharSequence)comment).length() == 0)) {
            StringBuilder stringBuilder = StringUtil.escapeStringCharacters((int)comment.length(), (String)comment, null, (boolean)false, (boolean)false, (StringBuilder)new StringBuilder(comment.length()));
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"StringUtil.escapeStringC\u2026gBuilder(comment.length))");
            StringBuilder escapedComment = stringBuilder;
            b2.append(indent).append(indentStep).append("--  ").append((CharSequence)escapedComment).append('\n');
        }
        b2.append(service.suffix(e, context));
        List<ObjectKind> list = e.getFamilyKinds();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"e.familyKinds");
        List<ObjectKind> kinds = list;
        Collection collection = kinds;
        if (!collection.isEmpty()) {
            String indent1 = indent + indentStep;
            String indent2 = indent1 + indentStep;
            for (ObjectKind kind : kinds) {
                Family<? extends BasicElement> children2 = e.familyOf(kind);
                if (children2 == null || children2.isEmpty()) continue;
                boolean first = true;
                Iterator iterator = children2.iterator();
                while (iterator.hasNext()) {
                    BasicElement child;
                    BasicElement basicElement = child = (BasicElement)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                    if (basicElement.isElementSurrogate()) continue;
                    if (first) {
                        b2.append(indent1).append('+').append(' ').append(StringUtil.pluralize((String)kind.code())).append('\n');
                        first = false;
                    }
                    context.setIndent(indent2);
                    ModelDescribing.describeTreeRecursively(service, context, child);
                    context.setIndent(indent);
                }
            }
        }
    }
}

