/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ProcessingContext;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigBlockTag;
import com.jetbrains.twig.util.TwigLookupUtil;
import org.jetbrains.annotations.NotNull;

public class TwigBlockCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement currElement;
        if (parameters == null) {
            TwigBlockCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TwigBlockCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            TwigBlockCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((currElement = parameters.getPosition().getOriginalElement()).getNode().getElementType() == TwigTokenTypes.IDENTIFIER) {
            PsiElement prevElement = currElement.getPrevSibling();
            if (prevElement instanceof PsiWhiteSpace) {
                prevElement = prevElement.getPrevSibling();
            }
            if (prevElement != null && prevElement.getNode().getElementType() == TwigTokenTypes.TAG_NAME && "block".equals(prevElement.getText())) {
                String blockNamePrefix = result.getPrefixMatcher().getPrefix();
                int spacePos = blockNamePrefix.lastIndexOf(32);
                blockNamePrefix = spacePos > 0 ? blockNamePrefix.substring(spacePos + 1) : "";
                CompletionResultSet blockNameResult = result.withPrefixMatcher(blockNamePrefix);
                TwigBlockCompletionProvider.collectBlockNames(blockNameResult, currElement);
            }
        }
    }

    private static void collectBlockNames(final @NotNull CompletionResultSet result, @NotNull PsiElement completionElement) {
        if (result == null) {
            TwigBlockCompletionProvider.$$$reportNull$$$0(3);
        }
        if (completionElement == null) {
            TwigBlockCompletionProvider.$$$reportNull$$$0(4);
        }
        if (!completionElement.isValid()) {
            return;
        }
        PsiFile file = completionElement.getContainingFile();
        TwigLookupUtil.ElementFinder finder = new TwigLookupUtil.ElementFinder(element -> element instanceof TwigBlockTag){

            @Override
            public boolean handleMatch(PsiElement element) {
                String blockName = ((TwigBlockTag)element).getName();
                if (blockName != null && !blockName.isEmpty()) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)blockName));
                }
                return false;
            }
        };
        TwigLookupUtil.lookupExtends(file, finder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionElement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/twig/completion/TwigBlockCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectBlockNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

