/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CustomFileTypeCompletionContributor
extends CompletionContributor
implements DumbAware {
    public CustomFileTypeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile().withFileType((ElementPattern)StandardPatterns.instanceOf(CustomSyntaxTableFileType.class))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (CustomFileTypeCompletionContributor.inCommentOrLiteral(parameters)) {
                    return;
                }
                FileType fileType = parameters.getOriginalFile().getFileType();
                if (!(fileType instanceof CustomSyntaxTableFileType)) {
                    return;
                }
                SyntaxTable syntaxTable = ((CustomSyntaxTableFileType)fileType).getSyntaxTable();
                String prefix = CompletionUtil.findJavaIdentifierPrefix(parameters);
                if (prefix.isEmpty() && parameters.isAutoPopup()) {
                    return;
                }
                CompletionResultSet resultSetWithPrefix = result2.withPrefixMatcher(prefix);
                CustomFileTypeCompletionContributor.addVariants(resultSetWithPrefix, syntaxTable.getKeywords1());
                CustomFileTypeCompletionContributor.addVariants(resultSetWithPrefix, syntaxTable.getKeywords2());
                CustomFileTypeCompletionContributor.addVariants(resultSetWithPrefix, syntaxTable.getKeywords3());
                CustomFileTypeCompletionContributor.addVariants(resultSetWithPrefix, syntaxTable.getKeywords4());
                WordCompletionContributor.addWordCompletionVariants(resultSetWithPrefix, parameters, Collections.emptySet());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/CustomFileTypeCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean inCommentOrLiteral(CompletionParameters parameters) {
        HighlighterIterator iterator = ((EditorEx)parameters.getEditor()).getHighlighter().createIterator(parameters.getOffset());
        if (iterator.atEnd()) {
            return false;
        }
        IElementType elementType = iterator.getTokenType();
        if (elementType == CustomHighlighterTokenType.WHITESPACE) {
            iterator.retreat();
            elementType = iterator.getTokenType();
        }
        return elementType == CustomHighlighterTokenType.LINE_COMMENT || elementType == CustomHighlighterTokenType.MULTI_LINE_COMMENT || elementType == CustomHighlighterTokenType.STRING || elementType == CustomHighlighterTokenType.SINGLE_QUOTED_STRING;
    }

    private static void addVariants(CompletionResultSet resultSet, Set<String> keywords) {
        for (String keyword : keywords) {
            resultSet.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
        }
    }
}

