/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.ModalityState;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ButtonToolbarImpl
extends JPanel {
    private final DataManager myDataManager;
    private final String myPlace;
    private final PresentationFactory myPresentationFactory;
    private final ArrayList<ActionJButton> myActions;

    public ButtonToolbarImpl(String place, @NotNull ActionGroup actionGroup, DataManager dataManager, ActionManagerEx actionManager) {
        if (actionGroup == null) {
            ButtonToolbarImpl.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        this.myActions = new ArrayList();
        this.myPlace = place;
        this.myPresentationFactory = new PresentationFactory();
        this.myDataManager = dataManager;
        this.initButtons(actionGroup);
        this.updateActions();
        actionManager.addTimerListener(500, (TimerListener)new WeakTimerListener(actionManager, new MyTimerListener()));
        this.enableEvents(48L);
    }

    private void initButtons(@NotNull ActionGroup actionGroup) {
        AnAction[] actions;
        if (actionGroup == null) {
            ButtonToolbarImpl.$$$reportNull$$$0(1);
        }
        if ((actions = actionGroup.getChildren(null)).length > 0) {
            int gridx = 0;
            this.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 0, 0), 0, 0));
            if (actions.length > 0) {
                JPanel buttonsPanel = this.createButtons(actions);
                this.add((Component)buttonsPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 0, 0, 0), 0, 0));
            }
        }
    }

    private JPanel createButtons(AnAction[] actions) {
        JPanel buttonsPanel = new JPanel(new GridLayout(1, actions.length, 5, 0));
        for (AnAction action : actions) {
            ActionJButton button = new ActionJButton(action);
            this.myActions.add(button);
            buttonsPanel.add(button);
        }
        return buttonsPanel;
    }

    public JComponent getComponent() {
        return this;
    }

    public void updateActions() {
        DataContext dataContext = ((DataManagerImpl)this.myDataManager).getDataContextTest(this);
        for (ActionJButton action : this.myActions) {
            action.updateAction(dataContext);
        }
        this.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "actionGroup";
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ButtonToolbarImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "initButtons";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)ButtonToolbarImpl.this);
        }

        public void run() {
            Dialog dialog2;
            if (!ButtonToolbarImpl.this.isShowing()) {
                return;
            }
            Window mywindow = SwingUtilities.windowForComponent(ButtonToolbarImpl.this);
            if (mywindow != null && !mywindow.isActive()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && (dialog2 = (Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(ButtonToolbarImpl.this, dialog2)) {
                return;
            }
            ButtonToolbarImpl.this.updateActions();
        }
    }

    private class ActionJButton
    extends JButton {
        private final AnAction myAction;

        ActionJButton(final AnAction action) {
            super(action.getTemplatePresentation().getText());
            this.myAction = action;
            this.setMnemonic(action.getTemplatePresentation().getMnemonic());
            this.setDisplayedMnemonicIndex(action.getTemplatePresentation().getDisplayedMnemonicIndex());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AnActionEvent event = new AnActionEvent(null, ((DataManagerImpl)ButtonToolbarImpl.this.myDataManager).getDataContextTest(ButtonToolbarImpl.this), ButtonToolbarImpl.this.myPlace, ButtonToolbarImpl.this.myPresentationFactory.getPresentation(action), ActionManager.getInstance(), e.getModifiers());
                    if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false)) {
                        ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
                    }
                }
            });
        }

        public void updateAction(DataContext dataContext) {
            AnActionEvent event = new AnActionEvent(null, dataContext, ButtonToolbarImpl.this.myPlace, ButtonToolbarImpl.this.myPresentationFactory.getPresentation(this.myAction), ActionManager.getInstance(), 0);
            event.setInjectedContext(this.myAction.isInInjectedContext());
            this.myAction.update(event);
            this.setVisible(event.getPresentation().isVisible());
            this.setEnabled(event.getPresentation().isEnabled());
        }
    }
}

