/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context;

import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.XPathVersion;

public final class ContextType {
    private static final Map<String, ContextType> ourRegistry = new HashMap<String, ContextType>();
    public static final ContextType PLAIN = ContextType.lookupOrCreate("PLAIN", XPathVersion.V1);
    public static final ContextType PLAIN_V2 = ContextType.lookupOrCreate("PLAIN_V2", XPathVersion.V2);
    @Deprecated
    public static final ContextType INTERACTIVE = ContextType.lookupOrCreate("INTERACTIVE");
    private final String myName;
    private final XPathVersion myVersion;

    public ContextType(String name, XPathVersion version) {
        assert (!ourRegistry.containsKey(name));
        ourRegistry.put(name, this);
        this.myName = name;
        this.myVersion = version;
    }

    public static synchronized ContextType valueOf(String name) {
        ContextType t = ourRegistry.get(name);
        if (t == null) {
            throw new IllegalArgumentException(name);
        }
        return t;
    }

    public static synchronized ContextType lookupOrCreate(String name, XPathVersion version) {
        return ourRegistry.containsKey(name) ? ourRegistry.get(name) : new ContextType(name, version);
    }

    public static synchronized ContextType lookupOrCreate(String name) {
        return ourRegistry.containsKey(name) ? ourRegistry.get(name) : new ContextType(name, XPathVersion.V1);
    }

    public static ContextType fromFile(XPathFile file) {
        return ContextProvider.getContextProvider((PsiFile)file).getContextType();
    }

    public XPathVersion getVersion() {
        return this.myVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextType that = (ContextType)o;
        return this.myName.equals(that.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.myName;
    }
}

