/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.CommonBundle;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

class LoadingNode
extends DefaultMutableTreeNode {
    private final String myText = CommonBundle.getLoadingTreeNodeText();
    private int myPeriod = 0;
    private final Icon[] myIcons = AnimatedIcon.Default.ICONS.toArray(new Icon[0]);
    private volatile boolean stopped = false;
    private Runnable myPeriodRequest;
    private final DefaultTreeModel myModel;

    LoadingNode(DefaultTreeModel model) {
        this.myModel = model;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public String toString() {
        return this.myText;
    }

    private void updatePeriod() {
        ++this.myPeriod;
        this.myPeriod %= this.myIcons.length;
        if (this.stopped) {
            return;
        }
        try {
            this.myModel.nodeChanged(this);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Icon getIcon() {
        return this.myIcons[this.myPeriod];
    }

    private void start(final Alarm alarm) {
        this.myPeriodRequest = new Runnable(){

            @Override
            public void run() {
                if (LoadingNode.this.getParent() != null) {
                    LoadingNode.this.updatePeriod();
                    if (!LoadingNode.this.stopped) {
                        alarm.addRequest((Runnable)this, 100);
                    }
                }
            }
        };
        alarm.addRequest(this.myPeriodRequest, 100);
    }

    private void stop(Alarm periodAlarm) {
        this.stopped = true;
        periodAlarm.cancelRequest(this.myPeriodRequest);
        TreeNode parent = this.getParent();
        this.removeFromParent();
        this.myModel.reload(parent);
    }

    public static class Manager
    implements CvsTabbedWindow.DeactivateListener {
        private final Alarm myPeriodAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final List<LoadingNode> loadingNodes = new ArrayList<LoadingNode>();

        public void addTo(DefaultTreeModel model, MutableTreeNode parent) {
            LoadingNode loadingNode = new LoadingNode(model);
            this.loadingNodes.add(loadingNode);
            model.insertNodeInto(loadingNode, parent, 0);
            loadingNode.start(this.myPeriodAlarm);
        }

        public void removeFrom(MutableTreeNode parent) {
            for (LoadingNode loadingNode : this.loadingNodes) {
                if (loadingNode.getParent() != parent) continue;
                loadingNode.stop(this.myPeriodAlarm);
                break;
            }
        }

        @Override
        public void deactivated() {
            this.myPeriodAlarm.cancelAllRequests();
        }
    }
}

