/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.w3c.css.index.AlphaComparator;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Messages;

public class TranslationTableGenerator {
    public static VelocityContext vc = new VelocityContext();
    private static String html_files_path = "../../../../";
    private static boolean done = false;
    private static String template_name = "translations.vm";

    public static void main(String[] args) {
        TranslationTableGenerator.generateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void generateTable() {
        String default_lang = "en";
        StringBuilder table_head = new StringBuilder();
        StringBuilder translations_table = new StringBuilder();
        String path = TranslationTableGenerator.class.getResource("").getPath();
        try {
            String name;
            path = new URI(path).getPath();
            Velocity.setProperty((String)"file.resource.loader.path", (Object)path);
            Velocity.addProperty((String)"file.resource.loader.path", (Object)(path + "../css/"));
            Velocity.setProperty((String)"runtime.log", (Object)("velocity-" + new SimpleDateFormat("yyyy-MM-dd_HHmm").format(new Date()) + ".log"));
            Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.AvalonLogChute");
            Velocity.init();
            Template tpl = Velocity.getTemplate((String)template_name, (String)"UTF-8");
            File out_file = new File(path + html_files_path + "translations.html");
            ApplContext ac_default = new ApplContext(default_lang);
            ArrayList languages = new ArrayList(Messages.languages_name.size());
            HashMap<String, ApplContext> translations = new HashMap<String, ApplContext>();
            HashMap<String, Integer> translation_completeness = new HashMap<String, Integer>();
            table_head.append("<tr><th scope='col'>Property</th>");
            for (int i = 0; i < Messages.languages_name.size(); ++i) {
                name = String.valueOf(Messages.languages_name.get(i));
                HashMap<String, String> l = new HashMap<String, String>();
                l.put("name", name);
                l.put("real", Messages.languages.get(name).getProperty("language_name"));
                languages.add(i, l);
                ApplContext ac_translated = new ApplContext(name);
                if (!name.equals(default_lang)) {
                    Locale locale;
                    int hy = name.indexOf("-");
                    if (hy > 0) {
                        String m = name.substring(0, hy);
                        String s = name.substring(hy + 1);
                        if ((hy = s.indexOf("-")) > 0) {
                            String v = s.substring(hy + 1);
                            s = s.substring(0, hy);
                            locale = new Locale(m, s, v);
                        } else {
                            locale = new Locale(m, s, "");
                        }
                    } else {
                        locale = new Locale(name);
                    }
                    String engName = locale.getDisplayName(Locale.US);
                    table_head.append("<th title=\"").append(engName);
                    table_head.append("\">");
                    table_head.append((String)l.get("real")).append("</th>");
                    l.put("engname", engName);
                }
                translations.put(name, ac_translated);
                translation_completeness.put(name, 0);
            }
            table_head.append("</tr>");
            Set<Object> properties_keyset = ac_default.getMsg().properties.keySet();
            Vector<Object> sorted_properties_keys = new Vector<Object>(properties_keyset);
            Collections.sort(sorted_properties_keys, new AlphaComparator());
            Iterator<Object> properties_iterator = sorted_properties_keys.iterator();
            translations_table.append("<tbody>");
            int num_properties = 0;
            while (properties_iterator.hasNext()) {
                ++num_properties;
                String property_name = String.valueOf(properties_iterator.next());
                translations_table.append("<tr><th scope=\"row\" class=\"property_name\">").append(property_name);
                translations_table.append("<p>").append(StringEscapeUtils.escapeHtml((String)ac_default.getMsg().getString(property_name)));
                translations_table.append("</p></th>");
                for (int i = 0; i < Messages.languages_name.size(); ++i) {
                    HashMap language = (HashMap)languages.get(i);
                    ApplContext translation = (ApplContext)translations.get(language.get("name"));
                    String property_translated = translation.getMsg().getString(property_name);
                    if (((String)language.get("name")).equals(default_lang)) {
                        vc.put(property_name, (Object)property_translated);
                        continue;
                    }
                    URI mail_translation = new URI("mailto", "w3c-translators@w3.org?Subject=[" + property_name + "] CSS Validator Translation&body=Property:\n  " + property_name + "\n\nText in English:\n  " + ac_default.getMsg().getString(property_name) + "\n\nLanguage:\n  " + (String)language.get("name") + "\n\nTranslation:\n\n\n-- Help translate the CSS Validator:\nhttp://qa-dev.w3.org:8001/css-validator/translations.html", "");
                    if (property_translated == null) {
                        translations_table.append("<td class=\"table_translation_missing\"><a title=\"submit a missing translation\" href=\"").append(StringEscapeUtils.escapeHtml((String)mail_translation.toASCIIString())).append("\">\u2718</a></td>\n");
                        continue;
                    }
                    if (property_translated.matches(".*translation unavailable.*")) {
                        translations_table.append("<td class=\"table_translation_missing\"><a title=\"submit a missing translation\" href=\"").append(StringEscapeUtils.escapeHtml((String)mail_translation.toASCIIString())).append("\">\u2718</a></td>\n");
                        continue;
                    }
                    translations_table.append("<td class=\"table_translation_ok\"><span title=\"").append(StringEscapeUtils.escapeHtml((String)property_translated)).append("\">\u2714</span></td>\n");
                    int completed = Integer.parseInt(((Integer)translation_completeness.get(language.get("name"))).toString());
                    translation_completeness.put((String)language.get("name"), ++completed);
                }
                translations_table.append("</tr>");
                if (num_properties % 12 != 0) continue;
                translations_table.append("</tbody><tbody>").append((CharSequence)table_head);
            }
            translations_table.append("</tbody></table>");
            for (int i = 0; i < Messages.languages_name.size(); ++i) {
                name = String.valueOf(Messages.languages_name.get(i));
                HashMap l = (HashMap)languages.get(i);
                int completeness_percent = 100 * Integer.parseInt(((Integer)translation_completeness.get(l.get("name"))).toString());
                l.put("completeness", Integer.toString(completeness_percent /= ac_default.getMsg().properties.size()));
            }
            vc.put("languages", languages);
            vc.put("num_languages", (Object)Messages.languages_name.size());
            vc.put("total_properties", (Object)ac_default.getMsg().properties.size());
            vc.put("translations_table", (Object)translations_table.toString());
            vc.put("lang", (Object)"en");
            OutputStreamWriter aFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(out_file), "UTF-8");
            tpl.merge((Context)vc, (Writer)aFileWriter);
            aFileWriter.close();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            done = true;
        }
    }
}

