/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.costing;

import com.projectlibre1.configuration.CalculationPreference;
import com.projectlibre1.datatype.ImageLink;
import com.projectlibre1.pm.calendar.HasCalendar;
import com.projectlibre1.pm.costing.EarnedValueValues;
import com.projectlibre1.pm.snapshot.BaselineScheduleFields;
import com.projectlibre1.pm.snapshot.Snapshottable;
import com.projectlibre1.pm.time.HasStartAndEnd;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.DateTime;

public class EarnedValueCalculator {
    private static final long defaultStart = 0L;
    private static final long defaultEnd = DateTime.getMaxDate().getTime();
    private static EarnedValueCalculator instance = null;
    private static final String NO_BASELINE = "There is no Earned Value data";

    private double getDivideByZeroValue() {
        return CalculationPreference.getActive().getEarnedValueDivideByZeroValue();
    }

    public double acwp(EarnedValueValues earnedValueValues) {
        return earnedValueValues.acwp(0L, defaultEnd);
    }

    public double bac(EarnedValueValues earnedValueValues) {
        return earnedValueValues.bac(0L, defaultEnd);
    }

    public double bcwp(EarnedValueValues earnedValueValues) {
        return earnedValueValues.acwp(0L, defaultEnd);
    }

    public double bcws(EarnedValueValues earnedValueValues) {
        return earnedValueValues.bcws(0L, defaultEnd);
    }

    public static EarnedValueCalculator getInstance() {
        if (instance == null) {
            instance = new EarnedValueCalculator();
        }
        return instance;
    }

    private EarnedValueCalculator() {
    }

    public double cv(EarnedValueValues earnedValueValues, long l, long l2) {
        return earnedValueValues.bcwp(l, l2) - earnedValueValues.acwp(l, l2);
    }

    public double cv(EarnedValueValues earnedValueValues) {
        return this.cv(earnedValueValues, 0L, defaultEnd);
    }

    public double sv(EarnedValueValues earnedValueValues, long l, long l2) {
        return earnedValueValues.bcwp(l, l2) - earnedValueValues.bcws(l, l2);
    }

    public double sv(EarnedValueValues earnedValueValues) {
        return this.sv(earnedValueValues, 0L, defaultEnd);
    }

    public double eac(EarnedValueValues earnedValueValues, long l, long l2) {
        double d;
        double d2 = earnedValueValues.bcwp(l, l2);
        if (d2 == 0.0) {
            if (this.getDivideByZeroValue() == 0.0) {
                return 0.0;
            }
            d2 = earnedValueValues.cost(l, l2);
        }
        if ((d = earnedValueValues.acwp(l, l2)) == 0.0 && this.getDivideByZeroValue() != 0.0) {
            return earnedValueValues.cost(l, l2);
        }
        return d + d * (earnedValueValues.bac(l, l2) - d2) / d2;
    }

    public double eac(EarnedValueValues earnedValueValues) {
        return this.eac(earnedValueValues, 0L, defaultEnd);
    }

    public double vac(EarnedValueValues earnedValueValues, long l, long l2) {
        return earnedValueValues.bac(l, l2) - this.eac(earnedValueValues, l, l2);
    }

    public double vac(EarnedValueValues earnedValueValues) {
        return this.vac(earnedValueValues, 0L, defaultEnd);
    }

    public double cpi(EarnedValueValues earnedValueValues, long l, long l2) {
        double d = earnedValueValues.acwp(l, l2);
        if (d == 0.0) {
            return this.getDivideByZeroValue();
        }
        return earnedValueValues.bcwp(l, l2) / d;
    }

    public double cpi(EarnedValueValues earnedValueValues) {
        return this.cpi(earnedValueValues, 0L, defaultEnd);
    }

    public double spi(EarnedValueValues earnedValueValues, long l, long l2) {
        double d = earnedValueValues.bcws(l, l2);
        if (d == 0.0) {
            return this.getDivideByZeroValue();
        }
        return earnedValueValues.bcwp(l, l2) / d;
    }

    public double spi(EarnedValueValues earnedValueValues) {
        return this.spi(earnedValueValues, 0L, defaultEnd);
    }

    public double csi(EarnedValueValues earnedValueValues, long l, long l2) {
        return this.spi(earnedValueValues, l, l2) * this.cpi(earnedValueValues, l, l2);
    }

    public double csi(EarnedValueValues earnedValueValues) {
        return this.spi(earnedValueValues) * this.cpi(earnedValueValues);
    }

    public double cvPercent(EarnedValueValues earnedValueValues, long l, long l2) {
        double d = earnedValueValues.bcwp(l, l2);
        if (d == 0.0) {
            return this.getDivideByZeroValue();
        }
        return (d - earnedValueValues.acwp(l, l2)) / d;
    }

    public double cvPercent(EarnedValueValues earnedValueValues) {
        return this.cvPercent(earnedValueValues, 0L, defaultEnd);
    }

    public double svPercent(EarnedValueValues earnedValueValues, long l, long l2) {
        double d = earnedValueValues.bcws(l, l2);
        if (d == 0.0) {
            return this.getDivideByZeroValue();
        }
        return (earnedValueValues.bcwp(l, l2) - d) / d;
    }

    public double svPercent(EarnedValueValues earnedValueValues) {
        return this.svPercent(earnedValueValues, 0L, defaultEnd);
    }

    public double tcpi(EarnedValueValues earnedValueValues, long l, long l2) {
        double d;
        double d2 = earnedValueValues.bac(l, l2);
        if (d2 == (d = earnedValueValues.acwp(l, l2))) {
            return this.getDivideByZeroValue();
        }
        return (d2 - earnedValueValues.bcwp(l, l2)) / (d2 - d);
    }

    public double tcpi(EarnedValueValues earnedValueValues) {
        return this.tcpi(earnedValueValues, 0L, defaultEnd);
    }

    public double bcwr(EarnedValueValues earnedValueValues, long l, long l2) {
        return earnedValueValues.bac(l, l2) - earnedValueValues.bcwp(l, l2);
    }

    public double bcwr(EarnedValueValues earnedValueValues) {
        return this.bcwr(earnedValueValues, 0L, defaultEnd);
    }

    public long getStartOffset(EarnedValueValues earnedValueValues) {
        int n = Snapshottable.BASELINE;
        if (!(earnedValueValues instanceof HasStartAndEnd)) {
            return 0L;
        }
        if (!(earnedValueValues instanceof BaselineScheduleFields)) {
            return 0L;
        }
        if (!(earnedValueValues instanceof HasCalendar)) {
            return 0L;
        }
        long l = ((BaselineScheduleFields)((Object)earnedValueValues)).getBaselineStart(n);
        if (l == 0L) {
            return 0L;
        }
        long l2 = ((HasStartAndEnd)((Object)earnedValueValues)).getStart();
        return ((HasCalendar)((Object)earnedValueValues)).getEffectiveWorkCalendar().compare(l2, l, false);
    }

    public long getFinishOffset(EarnedValueValues earnedValueValues) {
        int n = Snapshottable.BASELINE;
        if (!(earnedValueValues instanceof HasStartAndEnd)) {
            return 0L;
        }
        if (!(earnedValueValues instanceof BaselineScheduleFields)) {
            return 0L;
        }
        if (!(earnedValueValues instanceof HasCalendar)) {
            return 0L;
        }
        long l = ((BaselineScheduleFields)((Object)earnedValueValues)).getBaselineFinish(n);
        if (l == 0L) {
            return 0L;
        }
        long l2 = ((HasStartAndEnd)((Object)earnedValueValues)).getEnd();
        return ((HasCalendar)((Object)earnedValueValues)).getEffectiveWorkCalendar().compare(l2, l, false);
    }

    public ImageLink getScheduleStatusIndicator(double d) {
        return ImageLink.trafficLight(d == 0.0 ? NO_BASELINE : Messages.getString("EarnedValueCalculator.SPI") + "=" + d, d, 1.0, 0.9);
    }

    public ImageLink getBudgetStatusIndicator(double d) {
        return ImageLink.trafficLight(d == 0.0 ? NO_BASELINE : Messages.getString("EarnedValueCalculator.CPI") + "=" + d, d, 1.0, 0.9);
    }

    public ImageLink getStatusIndicator(double d) {
        return ImageLink.trafficLight(d == 0.0 ? NO_BASELINE : Messages.getString("EarnedValueCalculator.CSI") + "=" + d, d, 1.0, 0.81);
    }
}

