/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.common;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RubyClassCellRenderer
extends DefaultListCellRenderer {
    private final boolean a;

    public RubyClassCellRenderer() {
        this.setOpaque(true);
        this.a = true;
    }

    public RubyClassCellRenderer(boolean showReadOnly) {
        this.setOpaque(true);
        this.a = showReadOnly;
    }

    @Override
    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
        return RubyClassCellRenderer.customizeRenderer(this, value, this.a);
    }

    public static JLabel customizeRenderer(JLabel cellRendererComponent, Object value, boolean showReadOnly) {
        Icon icon;
        RContainer rContainer = (RContainer)value;
        cellRendererComponent.setText(RubyClassCellRenderer.getClassText(rContainer));
        int n2 = 1;
        if (showReadOnly) {
            n2 |= 2;
        }
        if ((icon = rContainer.getIcon(n2)) != null) {
            cellRendererComponent.setIcon(icon);
        }
        return cellRendererComponent;
    }

    public static String getClassText(RContainer aClass) {
        String string = aClass instanceof RClass ? ((RClass)aClass).getQualifiedName() : ((RModule)aClass).getQualifiedName();
        if (string != null) {
            return string;
        }
        return aClass.getName();
    }
}

