/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.enter.BaseIndentEnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.slim.SlimLanguage;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;

public final class SlimEnterHandler
extends BaseIndentEnterHandler
implements EnterHandlerDelegate {
    private static final TokenSet INDENT_INDICATORS = TokenSet.create((IElementType[])new IElementType[]{SlimTokenTypes.ID, SlimTokenTypes.CLASS, SlimTokenTypes.TAG, SlimTokenTypes.FILTER, SlimTokenTypes.HTML_COMMENT, SlimTokenTypes.CODE_COMMENT});

    public SlimEnterHandler() {
        super((Language)SlimLanguage.INSTANCE, INDENT_INDICATORS, SlimTokenTypes.CODE_COMMENT, "/", TokenSet.create((IElementType[])new IElementType[]{SlimTokenTypes.WHITESPACE}), true);
    }

    protected String getNewIndent(@NotNull PsiFile file, @NotNull Document document, @NotNull CharSequence oldIndent) {
        if (file == null) {
            SlimEnterHandler.$$$reportNull$$$0(0);
        }
        if (document == null) {
            SlimEnterHandler.$$$reportNull$$$0(1);
        }
        if (oldIndent == null) {
            SlimEnterHandler.$$$reportNull$$$0(2);
        }
        CodeStyleSettings currentSettings = CodeStyle.getSettings((PsiFile)file);
        CommonCodeStyleSettings.IndentOptions indentOptions = currentSettings.getIndentOptions(file.getFileType());
        String tabInSpaces = StringUtil.repeatSymbol((char)' ', (int)indentOptions.TAB_SIZE);
        String newIndent = oldIndent + StringUtil.repeatSymbol((char)' ', (int)indentOptions.INDENT_SIZE);
        newIndent = newIndent.replaceAll("\t", tabInSpaces);
        if (indentOptions.USE_TAB_CHARACTER) {
            newIndent = newIndent.replaceAll(tabInSpaces, "\t");
        }
        return newIndent;
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        EnterHandlerDelegate.Result res;
        if (file == null) {
            SlimEnterHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            SlimEnterHandler.$$$reportNull$$$0(4);
        }
        if (caretOffset == null) {
            SlimEnterHandler.$$$reportNull$$$0(5);
        }
        if (caretAdvance == null) {
            SlimEnterHandler.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            SlimEnterHandler.$$$reportNull$$$0(7);
        }
        if ((res = this.shouldSkipWithResult(file, editor, dataContext)) != null) {
            return res;
        }
        IElementType type = SlimEnterHandler.getElementTypeBeforeTheCaret(editor, file);
        if (type == null || type.getLanguage() != SlimLanguage.INSTANCE && type.getLanguage() != HTMLLanguage.INSTANCE && type.getLanguage() != XMLLanguage.INSTANCE || SlimTokenTypes.OUTER_CODE.contains(type)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return super.preprocessEnter(file, editor, caretOffset, caretAdvance, dataContext, originalHandler);
    }

    @Nullable
    private static IElementType getElementTypeBeforeTheCaret(Editor editor, PsiFile file) {
        ASTNode node;
        int caret = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(caret - 1);
        if (element == null) {
            return null;
        }
        for (node = element.getNode(); node != null && node.getElementType() == TokenType.WHITE_SPACE; node = node.getTreePrev()) {
        }
        if (node == null) {
            return null;
        }
        return node.getElementType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldIndent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/slim/SlimEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewIndent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

