/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch;

import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperationOnFiles;
import com.intellij.openapi.vcs.FilePath;
import org.netbeans.lib.cvsclient.command.AbstractCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;

public class BranchOperation
extends CvsOperationOnFiles {
    private final String myBranchName;
    private final boolean myOverrideExisting;

    public BranchOperation(FilePath[] files, String branchName, boolean overrideExisting) {
        this.myBranchName = branchName;
        this.myOverrideExisting = overrideExisting;
        for (FilePath file : files) {
            this.addFile(file.getIOFile());
        }
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        TagCommand tagCommand = new TagCommand();
        tagCommand.setMakeBranchTag(true);
        tagCommand.setTag(this.myBranchName);
        tagCommand.setOverrideExistingTag(this.myOverrideExisting);
        if (this.myOverrideExisting) {
            tagCommand.setAllowMoveDeleteBranchTag(true);
        }
        this.addFilesToCommand(root, (AbstractCommand)tagCommand);
        return tagCommand;
    }

    @Override
    protected String getOperationName() {
        return "branch";
    }
}

