/*
 * Decompiled with CFR 0.152.
 */
package git4idea.attributes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.attributes.GitAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitCheckAttrParser {
    private static final Logger LOG = Logger.getInstance(GitCheckAttrParser.class);
    private static final String UNSPECIFIED_VALUE = "unspecified";
    @NotNull
    private final Map<String, Collection<GitAttribute>> myAttributes;

    private GitCheckAttrParser(@NotNull List<String> output) {
        if (output == null) {
            GitCheckAttrParser.$$$reportNull$$$0(0);
        }
        this.myAttributes = new HashMap<String, Collection<GitAttribute>>();
        for (String line : output) {
            if (line.isEmpty()) continue;
            List split = StringUtil.split((String)line, (String)":");
            LOG.assertTrue(split.size() == 3, (Object)String.format("Output doesn't match the expected format. Line: %s%nAll output:%n%s", line, StringUtil.join(output, (String)"\n")));
            String file = ((String)split.get(0)).trim();
            String attribute = ((String)split.get(1)).trim();
            String info = ((String)split.get(2)).trim();
            GitAttribute attr = GitAttribute.forName(attribute);
            if (attr == null || info.equalsIgnoreCase(UNSPECIFIED_VALUE)) continue;
            this.myAttributes.computeIfAbsent(file, f -> new ArrayList()).add(attr);
        }
    }

    @NotNull
    public static GitCheckAttrParser parse(@NotNull List<String> output) {
        if (output == null) {
            GitCheckAttrParser.$$$reportNull$$$0(1);
        }
        GitCheckAttrParser gitCheckAttrParser = new GitCheckAttrParser(output);
        if (gitCheckAttrParser == null) {
            GitCheckAttrParser.$$$reportNull$$$0(2);
        }
        return gitCheckAttrParser;
    }

    @NotNull
    public Map<String, Collection<GitAttribute>> getAttributes() {
        Map<String, Collection<GitAttribute>> map2 = this.myAttributes;
        if (map2 == null) {
            GitCheckAttrParser.$$$reportNull$$$0(3);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/attributes/GitCheckAttrParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/attributes/GitCheckAttrParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

