/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCommentInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<TextRange> ranges;
        if (file2 == null) {
            TodoCommentInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            TodoCommentInspection.$$$reportNull$$$0(1);
        }
        if ((ranges = TodoCommentInspection.getTodoRanges(file2)).isEmpty()) {
            return null;
        }
        SmartList result2 = new SmartList();
        int lastEndOffset = -1;
        for (TextRange todoRange : ranges) {
            PsiElement element;
            int todoStart = todoRange.getStartOffset();
            int todoEnd = todoRange.getEndOffset();
            if (todoStart < lastEndOffset) continue;
            for (element = file2.findElementAt(todoStart); element != null && element.getTextRange().getEndOffset() < todoEnd; element = element.getParent()) {
            }
            if (element == null) continue;
            int elementStart = element.getTextRange().getStartOffset();
            TextRange range2 = new TextRange(todoStart - elementStart, todoEnd - elementStart);
            result2.add(manager.createProblemDescriptor(element, range2, InspectionsBundle.message((String)"todo.comment.problem.descriptor", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
            lastEndOffset = todoEnd;
        }
        return result2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static List<TextRange> getTodoRanges(@NotNull PsiFile file2) {
        if (file2 == null) {
            TodoCommentInspection.$$$reportNull$$$0(2);
        }
        TodoIndexPatternProvider todoIndexPatternProvider = TodoIndexPatternProvider.getInstance();
        assert (todoIndexPatternProvider != null);
        Collection occurrences = IndexPatternSearch.search((PsiFile)file2, (IndexPatternProvider)todoIndexPatternProvider, (boolean)TodoConfiguration.getInstance().isMultiLine()).findAll();
        return occurrences.stream().map(occurrence -> {
            TextRange mainRange = occurrence.getTextRange();
            List additionalRanges = occurrence.getAdditionalTextRanges();
            return additionalRanges.isEmpty() ? mainRange : new TextRange(mainRange.getStartOffset(), ((TextRange)additionalRanges.get(additionalRanges.size() - 1)).getEndOffset());
        }).sorted((a, b) -> Comparing.compare((int)a.getStartOffset(), (int)b.getStartOffset())).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/TodoCommentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTodoRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

