/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ColorUIResource;

public class TextureInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public TextureInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    protected int getHorSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 1 : 0;
    }

    protected int getVerSpacing() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? 3 : 0;
    }

    protected boolean centerButtons() {
        return false;
    }

    public void paintPalette(Graphics g) {
        TextureUtils.fillComponent(g, this, 0);
    }

    public void paintBackground(Graphics g) {
        TextureUtils.fillComponent(g, this, 0);
    }

    public void paintBorder(Graphics g) {
    }

    public void paintText(Graphics g, int x, int y, String title) {
        if (this.isMacStyleWindowDecoration()) {
            x += this.paintIcon(g, x, y) + 5;
        }
        Graphics2D g2D = (Graphics2D)g;
        Shape savedClip = g2D.getClip();
        ColorUIResource fc = AbstractLookAndFeel.getWindowTitleForegroundColor();
        if (fc.equals(Color.white)) {
            ColorUIResource bc = AbstractLookAndFeel.getWindowTitleColorDark();
            g2D.setColor(bc);
            JTattooUtilities.drawString(this.frame, g, title, x - 1, y - 1);
            g2D.setColor(ColorHelper.darker(bc, 30.0));
            JTattooUtilities.drawString(this.frame, g, title, x + 1, y + 1);
        }
        g.setColor(fc);
        JTattooUtilities.drawString(this.frame, g, title, x, y);
        Area clipArea = new Area(new Rectangle2D.Double(x, this.getHeight() / 2, this.getWidth(), this.getHeight()));
        clipArea.intersect(new Area(savedClip));
        g2D.setClip(clipArea);
        g.setColor(ColorHelper.darker(fc, 20.0));
        JTattooUtilities.drawString(this.frame, g, title, x, y);
        g2D.setClip(savedClip);
    }
}

