/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.filechooser.FileSystemView;

class RootManager {
    private File[] roots = RootManager.getAllRoots();
    private int rootCount = this.roots.length;
    private static final RootManager INSTANCE = new RootManager();

    private RootManager() {
    }

    private static final File[] getAllRoots() {
        FileSystemView fsv = FileSystemView.getFileSystemView();
        ArrayList<File> list = new ArrayList<File>(Arrays.asList(fsv.getRoots()));
        File[] moreRoots = File.listRoots();
        for (int i = 0; i < moreRoots.length; ++i) {
            if (list.contains(moreRoots[i])) continue;
            list.add(moreRoots[i]);
        }
        Collections.sort(list);
        File[] fileArray = new File[list.size()];
        return list.toArray(fileArray);
    }

    public static RootManager getInstance() {
        return INSTANCE;
    }

    public File getRootForFile(File file) {
        for (File f2 = file.getAbsoluteFile(); f2 != null; f2 = f2.getParentFile()) {
            for (int i = 0; i < this.rootCount; ++i) {
                if (!f2.equals(this.roots[i])) continue;
                return f2;
            }
        }
        return null;
    }

    public File getRootForFile(String file) {
        return this.getRootForFile(new File(file));
    }

    public boolean isRoot(File file) {
        for (int i = 0; i < this.rootCount; ++i) {
            if (!this.roots[i].equals(file)) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return new RootIterator();
    }

    class RootIterator
    implements Iterator {
        private int i = 0;

        RootIterator() {
        }

        public boolean hasNext() {
            return this.i < RootManager.this.rootCount;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return RootManager.this.roots[this.i++];
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove roots");
        }
    }
}

