/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.settings;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.settings.util.Filter;
import org.jmeld.settings.util.FilterRule;
import org.jmeld.util.ObjectUtil;
import org.jmeld.util.conf.AbstractConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class FilterSettings
extends AbstractConfigurationElement {
    @XmlElement
    private List<Filter> filters = new ArrayList<Filter>();

    public void init(JMeldSettings parent) {
        super.init(parent);
        for (Filter f : this.filters) {
            f.init(parent);
        }
        this.initDefault();
    }

    public void addFilter(Filter filter) {
        filter.init(this.configuration);
        this.filters.add(filter);
        this.fireChanged();
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
        this.fireChanged();
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public Filter getFilter(String name) {
        for (Filter f : this.filters) {
            if (!ObjectUtil.equals(f.getName(), name)) continue;
            return f;
        }
        return null;
    }

    private void initDefault() {
        if (this.getFilter("default") != null) {
            return;
        }
        Filter filter = new Filter("default");
        filter.addRule(new FilterRule("Temporary files", FilterRule.Rule.excludes, "**/*~", true));
        filter.addRule(new FilterRule("Temporary files", FilterRule.Rule.excludes, "**/#*#", true));
        filter.addRule(new FilterRule("Temporary files", FilterRule.Rule.excludes, "**/.#*", true));
        filter.addRule(new FilterRule("Temporary files", FilterRule.Rule.excludes, "**/%*%", true));
        filter.addRule(new FilterRule("Temporary files", FilterRule.Rule.excludes, "**/._*", true));
        filter.addRule(new FilterRule("Versioncontrol", FilterRule.Rule.excludes, "**/.svn", true));
        filter.addRule(new FilterRule("Versioncontrol", FilterRule.Rule.excludes, "**/.svn/**", true));
        filter.addRule(new FilterRule("Versioncontrol", FilterRule.Rule.excludes, "**/CVS", true));
        filter.addRule(new FilterRule("Versioncontrol", FilterRule.Rule.excludes, "**/CVS/**", true));
        filter.addRule(new FilterRule("Versioncontrol", FilterRule.Rule.excludes, "**/SCCS", true));
        filter.addRule(new FilterRule("Versioncontrol", FilterRule.Rule.excludes, "**/SCCS/**", true));
        filter.addRule(new FilterRule("Versioncontrol", FilterRule.Rule.excludes, "**/vssver.scc", true));
        filter.addRule(new FilterRule("Mac", FilterRule.Rule.excludes, "**/.DS_Store", true));
        filter.addRule(new FilterRule("Media", FilterRule.Rule.excludes, "**/.jpg", true));
        filter.addRule(new FilterRule("Media", FilterRule.Rule.excludes, "**/.gif", true));
        filter.addRule(new FilterRule("Media", FilterRule.Rule.excludes, "**/.png", true));
        filter.addRule(new FilterRule("Media", FilterRule.Rule.excludes, "**/.wav", true));
        filter.addRule(new FilterRule("Media", FilterRule.Rule.excludes, "**/.mp3", true));
        filter.addRule(new FilterRule("Media", FilterRule.Rule.excludes, "**/.ogg", true));
        filter.addRule(new FilterRule("Media", FilterRule.Rule.excludes, "**/.xcf", true));
        filter.addRule(new FilterRule("Media", FilterRule.Rule.excludes, "**/.xpm", true));
        filter.addRule(new FilterRule("Binaries", FilterRule.Rule.excludes, "**/.pyc", true));
        filter.addRule(new FilterRule("Binaries", FilterRule.Rule.excludes, "**/.a", true));
        filter.addRule(new FilterRule("Binaries", FilterRule.Rule.excludes, "**/.obj", true));
        filter.addRule(new FilterRule("Binaries", FilterRule.Rule.excludes, "**/.o", true));
        filter.addRule(new FilterRule("Binaries", FilterRule.Rule.excludes, "**/.so", true));
        filter.addRule(new FilterRule("Binaries", FilterRule.Rule.excludes, "**/.la", true));
        filter.addRule(new FilterRule("Binaries", FilterRule.Rule.excludes, "**/.lib", true));
        filter.addRule(new FilterRule("Binaries", FilterRule.Rule.excludes, "**/.dll", true));
        filter.addRule(new FilterRule("Java", FilterRule.Rule.excludes, "**/*.class", true));
        filter.addRule(new FilterRule("Java", FilterRule.Rule.excludes, "**/*.jar", true));
        this.addFilter(filter);
    }
}

