/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.prefs;

import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmeld.util.StringUtil;
import org.jmeld.util.prefs.Preference;

public class TabbedPanePreference
extends Preference {
    private static String TITLE = "TITLE";
    private JTabbedPane target;

    public TabbedPanePreference(String preferenceName, JTabbedPane target) {
        super("TabbedPane-" + preferenceName);
        this.target = target;
        this.init();
    }

    private void init() {
        String title = this.getString(TITLE, "");
        if (!StringUtil.isEmpty(title)) {
            for (int index = 0; index < this.target.getTabCount(); ++index) {
                if (!title.equals(this.target.getTitleAt(index))) continue;
                this.target.setSelectedIndex(index);
                break;
            }
        }
        this.target.getModel().addChangeListener(this.getChangeListener());
    }

    private void save() {
        int index = this.target.getSelectedIndex();
        String title = index == -1 ? null : this.target.getTitleAt(index);
        this.putString(TITLE, title);
    }

    private ChangeListener getChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TabbedPanePreference.this.save();
            }
        };
    }
}

