/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;

class TonicDropTargetListener
implements DropTargetListener,
UIResource,
ActionListener {
    private Timer timer;
    private Point lastPosition;
    private Rectangle outer = new Rectangle();
    private Rectangle inner = new Rectangle();
    private int hysteresis = 10;
    private boolean canImport;
    private JComponent component;

    protected TonicDropTargetListener() {
    }

    protected void saveComponentState(JComponent c) {
    }

    protected void restoreComponentState(JComponent c) {
    }

    protected void restoreComponentStateForDrop(JComponent c) {
    }

    protected void updateInsertionLocation(JComponent c, Point p) {
    }

    void updateAutoscrollRegion(JComponent c) {
        Rectangle visible = c.getVisibleRect();
        this.outer.reshape(visible.x, visible.y, visible.width, visible.height);
        Insets i = new Insets(0, 0, 0, 0);
        if (c instanceof Scrollable) {
            Scrollable s = (Scrollable)((Object)c);
            i.left = s.getScrollableUnitIncrement(visible, 0, 1);
            i.top = s.getScrollableUnitIncrement(visible, 1, 1);
            i.right = s.getScrollableUnitIncrement(visible, 0, -1);
            i.bottom = s.getScrollableUnitIncrement(visible, 1, -1);
        }
        this.inner.reshape(visible.x + i.left, visible.y + i.top, visible.width - (i.left + i.right), visible.height - (i.top + i.bottom));
    }

    void autoscroll(JComponent c, Point pos) {
        if (c instanceof Scrollable) {
            int dx;
            Rectangle r;
            int dy;
            Scrollable s = (Scrollable)((Object)c);
            if (pos.y < this.inner.y) {
                dy = s.getScrollableUnitIncrement(this.outer, 1, 1);
                r = new Rectangle(this.inner.x, this.outer.y - dy, this.inner.width, dy);
                c.scrollRectToVisible(r);
            } else if (pos.y > this.inner.y + this.inner.height) {
                dy = s.getScrollableUnitIncrement(this.outer, 1, -1);
                r = new Rectangle(this.inner.x, this.outer.y + this.outer.height, this.inner.width, dy);
                c.scrollRectToVisible(r);
            }
            if (pos.x < this.inner.x) {
                dx = s.getScrollableUnitIncrement(this.outer, 0, 1);
                r = new Rectangle(this.outer.x - dx, this.inner.y, dx, this.inner.height);
                c.scrollRectToVisible(r);
            } else if (pos.x > this.inner.x + this.inner.width) {
                dx = s.getScrollableUnitIncrement(this.outer, 0, -1);
                r = new Rectangle(this.outer.x + this.outer.width, this.inner.y, dx, this.inner.height);
                c.scrollRectToVisible(r);
            }
        }
    }

    private void initPropertiesIfNecessary() {
        if (this.timer == null) {
            Toolkit t = Toolkit.getDefaultToolkit();
            Integer initial = new Integer(100);
            Integer interval = new Integer(100);
            try {
                initial = (Integer)t.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                interval = (Integer)t.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer = new Timer(interval, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(initial);
            try {
                this.hysteresis = (Integer)t.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static JComponent getComponent(DropTargetEvent e) {
        DropTargetContext context = e.getDropTargetContext();
        return (JComponent)context.getComponent();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        this.updateAutoscrollRegion(this.component);
        if (this.outer.contains(this.lastPosition) && !this.inner.contains(this.lastPosition)) {
            this.autoscroll(this.component, this.lastPosition);
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        this.component = TonicDropTargetListener.getComponent(e);
        TransferHandler th = this.component.getTransferHandler();
        this.canImport = th.canImport(this.component, e.getCurrentDataFlavors());
        if (this.canImport) {
            this.saveComponentState(this.component);
            this.lastPosition = e.getLocation();
            this.updateAutoscrollRegion(this.component);
            this.initPropertiesIfNecessary();
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        if (this.canImport) {
            Point p = e.getLocation();
            this.updateInsertionLocation(this.component, p);
            TonicDropTargetListener tonicDropTargetListener = this;
            synchronized (tonicDropTargetListener) {
                if (Math.abs(p.x - this.lastPosition.x) > this.hysteresis || Math.abs(p.y - this.lastPosition.y) > this.hysteresis) {
                    if (this.timer.isRunning()) {
                        this.timer.stop();
                    }
                } else if (!this.timer.isRunning()) {
                    this.timer.start();
                }
                this.lastPosition = p;
            }
        }
    }

    public void dragExit(DropTargetEvent e) {
        if (this.canImport) {
            this.restoreComponentState(this.component);
        }
        this.cleanup();
    }

    public void drop(DropTargetDropEvent e) {
        if (this.canImport) {
            this.restoreComponentStateForDrop(this.component);
        }
        this.cleanup();
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private void cleanup() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.component = null;
        this.lastPosition = null;
    }
}

