/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

public final class CookieSupport {
    public static final boolean STRICT_SERVLET_COMPLIANCE;
    public static final boolean ALLOW_EQUALS_IN_VALUE;
    public static final boolean ALLOW_HTTP_SEPARATORS_IN_V0;
    public static final boolean ALWAYS_ADD_EXPIRES;
    public static final boolean FWD_SLASH_IS_SEPARATOR;
    public static final boolean ALLOW_NAME_ONLY;
    public static final boolean PRESERVE_COOKIE_HEADER;
    private static final char[] V0_SEPARATORS;
    private static final boolean[] V0_SEPARATOR_FLAGS;
    private static final char[] HTTP_SEPARATORS;
    private static final boolean[] HTTP_SEPARATOR_FLAGS;

    public static final boolean isV0Separator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw new IllegalArgumentException("Control character in cookie value or attribute.");
        }
        return V0_SEPARATOR_FLAGS[c];
    }

    public static boolean isV0Token(String value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length();
        if (CookieSupport.alreadyQuoted(value)) {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (CookieSupport.isV0Separator(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isHttpSeparator(char c) {
        if ((c < ' ' || c >= '\u007f') && c != '\t') {
            throw new IllegalArgumentException("Control character in cookie value or attribute.");
        }
        return HTTP_SEPARATOR_FLAGS[c];
    }

    public static boolean isHttpToken(String value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length();
        if (CookieSupport.alreadyQuoted(value)) {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (CookieSupport.isHttpSeparator(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean alreadyQuoted(String value) {
        if (value == null || value.length() < 2) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    private CookieSupport() {
    }

    static {
        int i;
        V0_SEPARATORS = new char[]{',', ';', ' ', '\t'};
        V0_SEPARATOR_FLAGS = new boolean[128];
        HTTP_SEPARATOR_FLAGS = new boolean[128];
        STRICT_SERVLET_COMPLIANCE = Boolean.parseBoolean(System.getProperty("org.apache.catalina.STRICT_SERVLET_COMPLIANCE", "false"));
        ALLOW_EQUALS_IN_VALUE = Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALLOW_EQUALS_IN_VALUE", "false"));
        ALLOW_HTTP_SEPARATORS_IN_V0 = Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALLOW_HTTP_SEPARATORS_IN_V0", "false"));
        String alwaysAddExpires = System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALWAYS_ADD_EXPIRES");
        ALWAYS_ADD_EXPIRES = alwaysAddExpires == null ? !STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(alwaysAddExpires);
        String preserveCookieHeader = System.getProperty("org.apache.tomcat.util.http.ServerCookie.PRESERVE_COOKIE_HEADER");
        PRESERVE_COOKIE_HEADER = preserveCookieHeader == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(preserveCookieHeader);
        String fwdSlashIsSeparator = System.getProperty("org.apache.tomcat.util.http.ServerCookie.FWD_SLASH_IS_SEPARATOR");
        FWD_SLASH_IS_SEPARATOR = fwdSlashIsSeparator == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(fwdSlashIsSeparator);
        ALLOW_NAME_ONLY = Boolean.parseBoolean(System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALLOW_NAME_ONLY", "false"));
        HTTP_SEPARATORS = FWD_SLASH_IS_SEPARATOR ? new char[]{'\t', ' ', '\"', '(', ')', ',', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'} : new char[]{'\t', ' ', '\"', '(', ')', ',', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '{', '}'};
        for (i = 0; i < 128; ++i) {
            CookieSupport.V0_SEPARATOR_FLAGS[i] = false;
            CookieSupport.HTTP_SEPARATOR_FLAGS[i] = false;
        }
        for (i = 0; i < V0_SEPARATORS.length; ++i) {
            CookieSupport.V0_SEPARATOR_FLAGS[CookieSupport.V0_SEPARATORS[i]] = true;
        }
        for (i = 0; i < HTTP_SEPARATORS.length; ++i) {
            CookieSupport.HTTP_SEPARATOR_FLAGS[CookieSupport.HTTP_SEPARATORS[i]] = true;
        }
    }
}

